/*************************************************************************
 *
 *  $RCSfile: XclExpHelper.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:38:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLEXPHELPER_HXX
#include "XclExpHelper.hxx"
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef _EXCRECDS_HXX
#include "excrecds.hxx"
#endif

using namespace rtl;

//___________________________________________________________________
// class XclExpUniString

XclExpUniString::XclExpUniString() :
	pBuffer( NULL ),
	nLen( 0 ),
    b16Bit( sal_False )
{
}

XclExpUniString::XclExpUniString( const XclExpUniString& rCopy ) :
	pBuffer( NULL ),
	nLen( rCopy.pBuffer ? rCopy.nLen : 0 ),
	b16Bit( rCopy.b16Bit )
{
	if( rCopy.pBuffer && nLen )
	{
        pBuffer = new sal_uInt16[ nLen + 1 ];
        memcpy( pBuffer, rCopy.pBuffer, (nLen + 1) * sizeof(sal_uInt16) );
	}
}

XclExpUniString::XclExpUniString( const String& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit )
{
    Build(
        rString.GetBuffer(),
        static_cast< sal_uInt16 >( Min( rString.Len(), static_cast< xub_StrLen >( nMaxLen ) ) ),
        bForce16Bit );
}

XclExpUniString::XclExpUniString( const OUString& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit )
{
	Build(
		rString.getStr(),
        static_cast< sal_uInt16 >( Min( Max( rString.getLength(), 0L ), static_cast< sal_Int32 >( nMaxLen ) ) ),
		bForce16Bit );
}

XclExpUniString::~XclExpUniString()
{
	if( pBuffer )
		delete[] pBuffer;
}

void XclExpUniString::Build( const sal_Unicode* pSource, sal_uInt16 nCount, sal_Bool bForce16Bit )
{
	nLen = nCount;
	if( nCount )
	{
        pBuffer = new sal_uInt16[ nCount + 1 ];
		b16Bit = bForce16Bit;

        const sal_Unicode* pSrcChar = pSource;
        sal_uInt16* pDstChar = pBuffer;
        sal_uInt16* pEndChar = pBuffer + nCount;

        for( ; pDstChar < pEndChar; ++pSrcChar, ++pDstChar )
		{
            *pDstChar = static_cast< sal_uInt16 >( *pSrcChar ? *pSrcChar : '?' );
			if( *pDstChar & 0xFF00 )
                b16Bit = sal_True;
		}
		*pDstChar = 0;
	}
	else
    {
		pBuffer = NULL;
        b16Bit = sal_False;
    }
}

void XclExpUniString::PrepareWrite( XclExpStream& rStrm, sal_uInt32 nBytes ) const
{
	rStrm.SetSliceLen( nBytes + (b16Bit ? 2 : 1) );
}

void XclExpUniString::Assign( const String& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit )
{
	if( pBuffer )
		delete[] pBuffer;
    Build(
        rString.GetBuffer(),
        static_cast< sal_uInt16 >( Min( rString.Len(), static_cast< xub_StrLen >( nMaxLen ) ) ),
        bForce16Bit );
}

void XclExpUniString::Assign( const OUString& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit )
{
	if( pBuffer )
		delete[] pBuffer;
	Build(
		rString.getStr(),
        static_cast< sal_uInt16 >( Min( Max( rString.getLength(), 0L ), static_cast< sal_Int32 >( nMaxLen ) ) ),
		bForce16Bit );
}

sal_uInt8 XclExpUniString::GetGrbit() const
{
	return b16Bit ? EXC_STR_16BIT : 0x00;
}

sal_uInt32 XclExpUniString::GetByteCount() const
{
	return GetBufferByteCount() + 3;
}

void XclExpUniString::WriteBuffer( void* pDest ) const
{
	if( pBuffer && nLen )
	{
        sal_uInt8* pDest8 = static_cast< sal_uInt8* >( pDest );
        for( sal_uInt16 nIndex = 0; nIndex < nLen; ++nIndex )
		{
            *pDest8++ = static_cast< sal_uInt8 >( pBuffer[ nIndex ] );
			if( b16Bit )
                *pDest8++ = static_cast< sal_uInt8 >( pBuffer[ nIndex ] >> 8 );
		}
	}
}

void XclExpUniString::WriteFlags( XclExpStream& rStrm ) const
{
	PrepareWrite( rStrm, 1 );
	rStrm << GetGrbit();
	rStrm.SetSliceLen( 0 );
}

void XclExpUniString::WriteRawHeader( XclExpStream& rStrm, sal_uInt32 nAddLen, sal_Bool b16BitCount, sal_Bool bForceFlags ) const
{
	DBG_ASSERT( b16BitCount || (nLen < 256), "XclExpUniString::WriteRawHeader - string too long" );

    sal_Bool bWriteFlags = GetLen() || bForceFlags;
	PrepareWrite( rStrm, (b16BitCount ? 2 : 1) + (bWriteFlags ? 1 : 0) + nAddLen );
	if( b16BitCount )
		rStrm << GetLen();
	else
        rStrm << static_cast< sal_uInt8 >( GetLen() );
	if( bWriteFlags )
		rStrm << GetGrbit();
}

void XclExpUniString::WriteHeader( XclExpStream& rStrm, sal_Bool b16BitCount, sal_Bool bForceFlags ) const
{
	WriteRawHeader( rStrm, 0, b16BitCount, bForceFlags );
	rStrm.SetSliceLen( 0 );
}

void XclExpUniString::WriteBuffer( XclExpStream& rStrm ) const
{
	if( pBuffer && nLen )
		rStrm.WriteUnicodeBuffer( pBuffer, nLen, GetGrbit() );
}

void XclExpUniString::Write( XclExpStream& rStrm, sal_Bool b16BitCount, sal_Bool bForceFlags ) const
{
	WriteHeader( rStrm, b16BitCount, bForceFlags );
	WriteBuffer( rStrm );
}



//___________________________________________________________________
// class XclExpRichString

XclExpRichString::XclExpRichString() :
	XclExpUniString(),
	pRichData( NULL )
{
}

XclExpRichString::XclExpRichString( const XclExpRichString& rCopy ) :
	XclExpUniString( rCopy ),
	pRichData( rCopy.pRichData ? new ExcRichStr( *rCopy.pRichData ) : NULL )
{
}

XclExpRichString::XclExpRichString( const String& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit ) :
	XclExpUniString( rString, nMaxLen, bForce16Bit ),
	pRichData( NULL )
{
}

XclExpRichString::XclExpRichString( const OUString& rString, sal_uInt16 nMaxLen, sal_Bool bForce16Bit ) :
	XclExpUniString( rString, nMaxLen, bForce16Bit ),
	pRichData( NULL )
{
}

XclExpRichString::~XclExpRichString()
{
	if( pRichData )
		delete pRichData;
}

void XclExpRichString::SetRichData( ExcRichStr* pNewData )
{
	if( pRichData )
		delete pRichData;
	pRichData = pNewData;
}

sal_uInt8 XclExpRichString::GetGrbit() const
{
	return XclExpUniString::GetGrbit() | (pRichData ? EXC_STR_RICH : 0x00);
}

sal_uInt32 XclExpRichString::GetByteCount() const
{
	return XclExpUniString::GetByteCount() + (pRichData ? 2 + pRichData->GetByteCount() : 0);
}

void XclExpRichString::WriteHeader( XclExpStream& rStrm, sal_Bool b16BitCount, sal_Bool bForceFlags ) const
{
	if( pRichData )
	{
		WriteRawHeader( rStrm, 2, b16BitCount, bForceFlags );
		rStrm << pRichData->GetFormCount();
		rStrm.SetSliceLen( 0 );
	}
	else
		XclExpUniString::WriteHeader( rStrm, b16BitCount, bForceFlags );
}

void XclExpRichString::Write( XclExpStream& rStrm, sal_Bool b16BitCount, sal_Bool bForceFlags ) const
{
	WriteHeader( rStrm, b16BitCount, bForceFlags );
	WriteBuffer( rStrm );
	if( pRichData )
		pRichData->Write( rStrm );
}



//___________________________________________________________________
// classes XclExpCachedValue, XclExpCachedValueDbl,
//   XclExpCachedValueStr, XclExpCachedValueList

XclExpCachedValue::~XclExpCachedValue()
{
}

void XclExpCachedValueDbl::Save( XclExpStream& rStrm )
{
    rStrm.SetSliceLen( 9 );
    rStrm   << static_cast< sal_uInt8 >( EXC_CACHEDVAL_DOUBLE )
            << fVal;
}

XclExpCachedValueStr::XclExpCachedValueStr( const String& rStr, sal_Bool b16BitCount ) :
    b16BitCnt( b16BitCount )
{
    if( b16BitCnt )
        aStr.Assign( rStr );
    else
        aStr.Assign( rStr, 255 );
}

void XclExpCachedValueStr::Save( XclExpStream& rStrm )
{
    rStrm.SetSliceLen( 6 );
    rStrm << static_cast< sal_uInt8 >( EXC_CACHEDVAL_STRING );
    aStr.Write( rStrm, b16BitCnt );
}



XclExpCachedValueList::XclExpCachedValueList(
        ScDocument& rDoc,
        sal_uInt16 _nCols, sal_uInt16 _nRows,
        const ScMatrix* pMatrix,
        sal_Bool b16BitCount ) :
    nLen( 3 ),
    nCols( _nCols ),
    nRows( _nRows ),
    b16BitCnt( b16BitCount )
{
    DBG_ASSERT( pMatrix && nCols && nRows, "XclExpCachedValueList::XclExpCachedValueList - missing matrix" );
    DBG_ASSERT( nCols <= 256, "XclExpCachedValueList::XclExpCachedValueList - too many columns" );

    String aString;
    double fValue;
    sal_Bool bIsString;
    for( sal_uInt16 nRow = 0; nRow < nRows; nRow++ )
        for( sal_uInt16 nCol = 0; nCol < nCols; nCol++ )
        {
            if( rDoc.GetDdeLinkResult( pMatrix, nCol, nRow, aString, fValue, bIsString ) )
                Append( EMPTY_STRING );
            else if( bIsString )
                Append( aString );
            else
                Append( fValue );
        }
}

void XclExpCachedValueList::Append( double fVal )
{
    ScfObjList< XclExpCachedValue >::Append( new XclExpCachedValueDbl( fVal ) );
    nLen += 9;
}

void XclExpCachedValueList::Append( const String& rStr )
{
    XclExpCachedValueStr* pOp = new XclExpCachedValueStr( rStr, b16BitCnt );
    ScfObjList< XclExpCachedValue >::Append( pOp );
    nLen += pOp->GetLen();
}

void XclExpCachedValueList::Save( XclExpStream& rStrm )
{
    rStrm   << static_cast< sal_uInt8 >( nCols - 1 )
            << static_cast< sal_uInt16 >( nRows - 1 );
    for( XclExpCachedValue* pOp = First(); pOp; pOp = Next() )
        pOp->Save( rStrm );
}



//___________________________________________________________________

