/*************************************************************************
 *
 *  $RCSfile: XclExpDocContent.cxx,v $
 *
 *  $Revision: 1.3.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 16:28:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

// ============================================================================

#ifndef _SC_XCLEXPDOCCONTENT_HXX
#include "XclExpDocContent.hxx"
#endif
#ifndef _SC_XCLEXPHELPER_HXX
#include "XclExpHelper.hxx"
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_VALIDAT_HXX
#include "validat.hxx"
#endif

#include "excupn.hxx"


// Label ranges ===============================================================

// XclExpRecLabelRanges -------------------------------------------------------

XclExpRecLabelranges::XclExpRecLabelranges( RootData& rRootData ) :
    XclExpRecord( EXC_ID_LABELRANGES )
{
    ScAddress aMaxPos( rRootData.nColMax, rRootData.nRowMax, 0xFFFF );
    XclRangeState eState;
    sal_uInt16 nTab = *rRootData.pAktTab;

    // row label ranges
    FillRangeList( maRowRanges, rRootData.pDoc->GetRowNameRangesRef(), nTab );
    // row labels only over 1 column (restriction of Excel97/2000/XP)
    for( ScRange* pRange = maRowRanges.First(); pRange; pRange = maRowRanges.Next() )
        if( pRange->aStart.Col() != pRange->aEnd.Col() )
            pRange->aEnd.SetCol( pRange->aStart.Col() );
    eState = XclTools::CropCellRangeList( maRowRanges, aMaxPos );
    // TODO: evaluate eState

    // col label ranges
    FillRangeList( maColRanges, rRootData.pDoc->GetColNameRangesRef(), nTab );
    eState = XclTools::CropCellRangeList( maColRanges, aMaxPos );
    // TODO: evaluate eState

    SetRecSize( 4 + 8 * (maRowRanges.Count() + maColRanges.Count()) );
}

void XclExpRecLabelranges::FillRangeList( ScRangeList& rRanges, ScRangePairListRef xLabelRangesRef, sal_uInt16 nTab )
{
    for( const ScRangePair* pRangePair = xLabelRangesRef->First(); pRangePair; pRangePair = xLabelRangesRef->Next() )
    {
        const ScRange& rRange = pRangePair->GetRange( 0 );
        if( rRange.aStart.Tab() == nTab )
            rRanges.Append( rRange );
    }
}

void XclExpRecLabelranges::WriteBody( XclExpStream& rStrm )
{
    XclTools::WriteCellRangeList( rStrm, maRowRanges );
    XclTools::WriteCellRangeList( rStrm, maColRanges );
}

void XclExpRecLabelranges::Save( XclExpStream& rStrm )
{
    if( maRowRanges.Count() || maColRanges.Count() )
        XclExpRecord::Save( rStrm );
}


// Validation =================================================================

// XclExpRecDv ----------------------------------------------------------------

XclExpRecDv::XclExpRecDv( RootData& rRootData, sal_uInt32 nHandle ) :
    XclExpRecord( EXC_ID_DV ),
    ExcRoot( &rRootData ),
    mpValData( rRootData.pDoc->GetValidationEntry( nHandle ) ),
    mnHandle( nHandle )
{
}

void XclExpRecDv::InsertCellRange( const ScRange& rRange )
{
    maRanges.Join( rRange );
}

sal_Bool XclExpRecDv::CheckWriteRecord()
{
    DBG_ASSERT( mpValData, "XclExpRecDv::Save - missing core data" );
    XclRangeState eState = XclTools::CropCellRangeList( maRanges,
        ScAddress( pExcRoot->nColMax, pExcRoot->nRowMax, 0xFFFF ) );
    // TODO: evaluate eState
    return mpValData && maRanges.Count();
}

void XclExpRecDv::WriteBody( XclExpStream& rStrm )
{
    String aTitle, aText;

    // prompt box
    sal_Bool bShowPrompt = mpValData->GetInput( aTitle, aText );
    XclExpUniString aPromptTitle( aTitle );
    // empty strings are not empty but contain a zero character (why not)
    if( !aTitle.Len() )
        aPromptTitle.Assign( 0 );
    XclExpUniString aPromptText( aText );
    if( !aText.Len() )
        aPromptText.Assign( 0 );

    // error box
    ScValidErrorStyle eScErrorStyle;
    sal_Bool bShowError = mpValData->GetErrMsg( aTitle, aText, eScErrorStyle );
    XclExpUniString aErrorTitle( aTitle );
    if( !aTitle.Len() )
        aErrorTitle.Assign( 0 );
    XclExpUniString aErrorText( aText );
    if( !aText.Len() )
        aErrorText.Assign( 0 );

    // flags
    sal_uInt32 nFlags = EXC_DV_SUPPRESSDROPDOWN;
    switch( mpValData->GetDataMode() )
    {
        case SC_VALID_ANY:      nFlags |= EXC_DV_MODE_ANY;      break;
        case SC_VALID_WHOLE:    nFlags |= EXC_DV_MODE_WHOLE;    break;
        case SC_VALID_DECIMAL:  nFlags |= EXC_DV_MODE_DECIMAL;  break;
        case SC_VALID_LIST:     nFlags |= EXC_DV_MODE_LIST;     break;
        case SC_VALID_DATE:     nFlags |= EXC_DV_MODE_DATE;     break;
        case SC_VALID_TIME:     nFlags |= EXC_DV_MODE_TIME;     break;
        case SC_VALID_TEXTLEN:  nFlags |= EXC_DV_MODE_TEXTLEN;  break;
        case SC_VALID_CUSTOM:   nFlags |= EXC_DV_MODE_CUSTOM;   break;
        default:                DBG_ERROR( "XclExpRecDv::SaveCont - unknown mode" );
    }
    switch( mpValData->GetOperation() )
    {
        case SC_COND_EQUAL:     nFlags |= EXC_DV_COND_EQUAL;        break;
        case SC_COND_LESS:      nFlags |= EXC_DV_COND_LESS;         break;
        case SC_COND_GREATER:   nFlags |= EXC_DV_COND_GREATER;      break;
        case SC_COND_EQLESS:    nFlags |= EXC_DV_COND_EQLESS;       break;
        case SC_COND_EQGREATER: nFlags |= EXC_DV_COND_EQGREATER;    break;
        case SC_COND_NOTEQUAL:  nFlags |= EXC_DV_COND_NOTEQUAL;     break;
        case SC_COND_BETWEEN:   nFlags |= EXC_DV_COND_BETWEEN;      break;
        case SC_COND_NOTBETWEEN:nFlags |= EXC_DV_COND_NOTBETWEEN;   break;
        default:                DBG_ERROR( "XclExpRecDv::SaveCont - unknown condition" );
    }
    switch( eScErrorStyle )
    {
        case SC_VALERR_STOP:    nFlags |= EXC_DV_ERROR_STOP;    break;
        case SC_VALERR_WARNING: nFlags |= EXC_DV_ERROR_WARNING; break;
        case SC_VALERR_INFO:    nFlags |= EXC_DV_ERROR_INFO;    break;
        case SC_VALERR_MACRO:   bShowError = sal_False;         break;
        default:                DBG_ERROR( "XclExpRecDv::SaveCont - unknown error style" );
    }
    if( mpValData->IsIgnoreBlank() )
        nFlags |= EXC_DV_IGNOREBLANK;
    if( bShowPrompt )
        nFlags |= EXC_DV_SHOWPROMPT;
    if( bShowError )
        nFlags |= EXC_DV_SHOWERROR;

    // formulas
    ExcUPN* pFmlaUPN1 = NULL;
    ExcUPN* pFmlaUPN2 = NULL;
    ScTokenArray* pScTokenArr = NULL;
    EC_Codetype eDummy;

    pScTokenArr = mpValData->CreateTokenArry( 0 );
    if( pScTokenArr )
        pFmlaUPN1 = new ExcUPN( pExcRoot, *pScTokenArr, eDummy, NULL, sal_True );
    delete pScTokenArr;

    pScTokenArr = mpValData->CreateTokenArry( 1 );
    if( pScTokenArr )
        pFmlaUPN2 = new ExcUPN( pExcRoot, *pScTokenArr, eDummy, NULL, sal_True );
    delete pScTokenArr;

    sal_uInt16 nFmlaLen1 = pFmlaUPN1 ? pFmlaUPN1->GetLen() : 0;
    const sal_Char* pFmlaData1 = nFmlaLen1 ? pFmlaUPN1->GetData() : NULL;
    sal_uInt16 nFmlaLen2 = pFmlaUPN2 ? pFmlaUPN2->GetLen() : 0;
    const sal_Char* pFmlaData2 = nFmlaLen2 ? pFmlaUPN2->GetData() : NULL;

    // write it
    rStrm << nFlags;
    aPromptTitle.Write( rStrm );
    aErrorTitle.Write( rStrm );
    aPromptText.Write( rStrm );
    aErrorText.Write( rStrm );
    rStrm << nFmlaLen1 << static_cast< sal_uInt16 >( 0 );
    rStrm.Write( pFmlaData1, nFmlaLen1 );
    rStrm << nFmlaLen2 << static_cast< sal_uInt16 >( 0 );
    rStrm.Write( pFmlaData2, nFmlaLen2 );
    XclTools::WriteCellRangeList( rStrm, maRanges );
}


// XclExpRecDval --------------------------------------------------------------

XclExpRecDval::XclExpRecDval( RootData& rRootData ) :
    XclExpRecord( EXC_ID_DVAL, 18 ),
    ExcRoot( &rRootData ),
    mpLastFoundDv( NULL )
{
}

XclExpRecDv& XclExpRecDval::SearchOrCreateDv( sal_uInt32 nHandle )
{
    // test last found record
    if( mpLastFoundDv && (mpLastFoundDv->GetHandle() == nHandle) )
        return *mpLastFoundDv;

    // binary search
    sal_uInt32 nCurrIndex = 0;
    if( !maDvList.Empty() )
    {
        sal_uInt32 nFirst = 0;
        sal_uInt32 nLast = maDvList.Count() - 1;
        sal_Bool bLoop = sal_True;
        sal_uInt32 nCurrHandle;
        while( (nFirst <= nLast) && bLoop )
        {
            nCurrIndex = (nFirst + nLast) / 2;
            mpLastFoundDv = maDvList.GetObject( nCurrIndex );
            nCurrHandle = mpLastFoundDv->GetHandle();
            if( nCurrHandle == nHandle )
                bLoop = sal_False;
            else if( nCurrHandle < nHandle )
                nFirst = nCurrIndex + 1;
            else if( nCurrIndex )
                nLast = nCurrIndex - 1;
            else    // special case for nLast = -1
                bLoop = sal_False;
        }
        if( nCurrHandle == nHandle )
            return *mpLastFoundDv;
        else if( nCurrHandle < nHandle )
            ++nCurrIndex;
    }

    // create new DV record
    mpLastFoundDv = new XclExpRecDv( *pExcRoot, nHandle );
    maDvList.Insert( mpLastFoundDv, nCurrIndex );
    return *mpLastFoundDv;
}

void XclExpRecDval::InsertCellRange( const ScRange& rRange, sal_uInt32 nHandle )
{
    XclExpRecDv& rDvRec = SearchOrCreateDv( nHandle );
    rDvRec.InsertCellRange( rRange );
}

void XclExpRecDval::WriteBody( XclExpStream& rStrm )
{
    rStrm.WriteZeroBytes( 10 );
    rStrm << static_cast< sal_uInt32 >( 0xFFFFFFFF ) << maDvList.Count();
}

void XclExpRecDval::Save( XclExpStream& rStrm )
{
    // check all records
    sal_uInt32 nIndex = maDvList.Count();
    while( nIndex )
    {
        --nIndex;
        XclExpRecDv* pDvRec = maDvList.GetObject( nIndex );
        if( !pDvRec->CheckWriteRecord() )
            maDvList.Delete( nIndex );
    }

    // write the DVAL and the DV's
    if( !maDvList.Empty() )
    {
        XclExpRecord::Save( rStrm );
        maDvList.Save( rStrm );
    }
}


// ============================================================================

