/*************************************************************************
 *
 *  $RCSfile: GetLocaleInfo.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obr $ $Date: 2001/09/17 12:34:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <systools/win32/StrConvert.h>
#include <assert.h>

/************************************************************************/
/* typedefs
/************************************************************************/

typedef struct {
    const WORD  key;
    const CHAR* value;
} _pair;

/************************************************************************/
/* pair compare functions
/************************************************************************/

int __cdecl pair_compare( const void *elem1, const void *elem2 )
{
    return ((_pair *) elem1)->key - ((_pair *) elem2)->key;
}

/************************************************************************/
/* ISO language code table
/************************************************************************/

static const _pair _lang_code[] = {
    { 0x0001, "ar" },
    { 0x0002, "bg" },
    { 0x0003, "ca" },
    { 0x0004, "zh" },
    { 0x0005, "cs" },
    { 0x0006, "da" },
    { 0x0007, "de" },
    { 0x0008, "el" },
    { 0x0009, "en" },
    { 0x000A, "es" },
    { 0x000B, "fi" },
    { 0x000C, "fr" },
    { 0x000D, "iw" },
    { 0x000E, "hu" },
    { 0x000F, "is" },
    { 0x0010, "it" },
    { 0x0011, "ja" },
    { 0x0012, "ko" },
    { 0x0013, "nl" },
    { 0x0014, "no" },
    { 0x0015, "pl" },
    { 0x0016, "pt" },
    { 0x0018, "ro" },
    { 0x0019, "ru" },
    { 0x001A, "hr" },
    { 0x001B, "sk" },
    { 0x001C, "sq" },
    { 0x001D, "sv" },
    { 0x001E, "th" },
    { 0x001F, "tr" },
    { 0x0020, "ur" },
    { 0x0021, "id" },
    { 0x0022, "uk" },
    { 0x0023, "be" },
    { 0x0024, "sl" },
    { 0x0025, "et" },
    { 0x0026, "lv" },
    { 0x0027, "lt" },
    { 0x0029, "fa" },
    { 0x002A, "vi" },
    { 0x002B, "hy" },
    { 0x002C, "az" },
    { 0x002D, "eu" },
    { 0x002F, "mk" },
    { 0x0036, "af" },
    { 0x0037, "ka" },
    { 0x0038, "fo" },
    { 0x0039, "hi" },
    { 0x003E, "ms" },
    { 0x003F, "kk" },
    { 0x0041, "sw" },
    { 0x0043, "uz" },
    { 0x0044, "tt" },
    { 0x0049, "ta" },
    { 0x004E, "mr" },
    { 0x004F, "sa" },
    { 0x0057, "hi" }
};

/************************************************************************/
/* ISO country code table
/************************************************************************/

static const _pair _ctry_code[] = {
    { 0x0001, "SA" },
    { 0x0002, "BG" },
    { 0x0003, "ES" },
    { 0x0004, "TW" },
    { 0x0005, "CZ" },
    { 0x0006, "DK" },
    { 0x0007, "DE" },
    { 0x0008, "GR" },
    { 0x0009, "US" },
    { 0x000A, "ES" },
    { 0x000B, "FI" },
    { 0x000C, "FR" },
    { 0x000D, "IL" },
    { 0x000E, "HU" },
    { 0x000F, "IS" },
    { 0x0010, "IT" },
    { 0x0011, "JP" },
    { 0x0012, "KR" },
    { 0x0013, "NL" },
    { 0x0014, "NO" },
    { 0x0015, "PL" },
    { 0x0016, "BR" },
    { 0x0018, "RO" },
    { 0x0019, "RU" },
    { 0x001A, "HR" },
    { 0x001B, "SK" },
    { 0x001C, "AL" },
    { 0x001D, "SE" },
    { 0x001E, "TH" },
    { 0x001F, "TR" },
    { 0x0020, "PK" },
    { 0x0021, "ID" },
    { 0x0022, "UA" },
    { 0x0023, "BY" },
    { 0x0024, "SI" },
    { 0x0025, "EE" },
    { 0x0026, "LV" },
    { 0x0027, "LT" },
    { 0x0029, "IR" },
    { 0x002A, "VN" },
    { 0x002B, "am" },
    { 0x002C, "AZ" },
    { 0x002D, "ES" },
    { 0x002F, "MK" },
    { 0x0036, "ZA" },
    { 0x0037, "GE" },
    { 0x0038, "FO" },
    { 0x0039, "IN" },
    { 0x003E, "MY" },
    { 0x003F, "KZ" },
    { 0x0041, "KE" },
    { 0x0043, "UZ" },
    { 0x0044, "TA" },
    { 0x0049, "IN" },
    { 0x004E, "IN" },
    { 0x004F, "IN" },
    { 0x0057, "IN" },
    { 0x0400, "DE" },
    { 0x0401, "SA" },
    { 0x0402, "BG" },
    { 0x0403, "ES" },
    { 0x0404, "TW" },
    { 0x0405, "CZ" },
    { 0x0406, "DK" },
    { 0x0407, "DE" },
    { 0x0408, "GR" },
    { 0x0409, "US" },
    { 0x040A, "ES" },
    { 0x040B, "FI" },
    { 0x040C, "FR" },
    { 0x040D, "IL" },
    { 0x040E, "HU" },
    { 0x040F, "IS" },
    { 0x0410, "IT" },
    { 0x0411, "JP" },
    { 0x0412, "KR" },
    { 0x0413, "NL" },
    { 0x0414, "NO" },
    { 0x0415, "PL" },
    { 0x0416, "BR" },
    { 0x0418, "RO" },
    { 0x0419, "RU" },
    { 0x041A, "HR" },
    { 0x041B, "SK" },
    { 0x041C, "AL" },
    { 0x041D, "SE" },
    { 0x041E, "TH" },
    { 0x041F, "TR" },
    { 0x0420, "PK" },
    { 0x0421, "ID" },
    { 0x0422, "UA" },
    { 0x0423, "BY" },
    { 0x0424, "SI" },
    { 0x0425, "EE" },
    { 0x0426, "LV" },
    { 0x0427, "LT" },
    { 0x0429, "IR" },
    { 0x042A, "VN" },
    { 0x042B, "am" },
    { 0x042C, "AZ" },
    { 0x042D, "ES" },
    { 0x042F, "MK" },
    { 0x0436, "ZA" },
    { 0x0437, "GE" },
    { 0x0438, "FO" },
    { 0x0439, "IN" },
    { 0x043E, "MY" },
    { 0x043F, "KZ" },
    { 0x0441, "KE" },
    { 0x0443, "UZ" },
    { 0x0444, "TA" },
    { 0x0449, "IN" },
    { 0x044E, "IN" },
    { 0x044F, "IN" },
    { 0x0457, "IN" },
    { 0x0800, "US" },
    { 0x0801, "IQ" },
    { 0x0804, "CN" },
    { 0x0807, "CH" },
    { 0x0809, "GB" },
    { 0x080A, "MX" },
    { 0x080C, "BE" },
    { 0x0810, "CH" },
    { 0x0813, "BE" },
    { 0x0814, "NO" },
    { 0x0816, "PT" },
    { 0x081A, "SP" },
    { 0x081D, "FI" },
    { 0x082C, "AZ" },
    { 0x083E, "BN" },
    { 0x0843, "UZ" },
    { 0x0C01, "EG" },
    { 0x0C04, "HK" },
    { 0x0C07, "AT" },
    { 0x0C09, "AU" },
    { 0x0C0A, "ES" },
    { 0x0C0C, "CA" },
    { 0x0C1A, "SP" },
    { 0x1001, "LY" },
    { 0x1004, "SG" },
    { 0x1007, "LU" },
    { 0x1009, "CA" },
    { 0x100A, "GT" },
    { 0x100C, "CH" },
    { 0x1401, "DZ" },
    { 0x1404, "MO" },
    { 0x1407, "LI" },
    { 0x1409, "NZ" },
    { 0x140A, "CR" },
    { 0x140C, "LU" },
    { 0x1801, "MA" },
    { 0x1809, "IE" },
    { 0x180A, "PA" },
    { 0x180C, "MC" },
    { 0x1C01, "TN" },
    { 0x1C09, "ZA" },
    { 0x1C0A, "DO" },
    { 0x2001, "OM" },
    { 0x2009, "JM" },
    { 0x200A, "VE" },
    { 0x2401, "YE" },
    { 0x2409, "CB" },
    { 0x240A, "CO" },
    { 0x2801, "SY" },
    { 0x2809, "BZ" },
    { 0x280A, "PE" },
    { 0x2C01, "JO" },
    { 0x2C09, "TT" },
    { 0x2C0A, "AR" },
    { 0x3001, "LB" },
    { 0x3009, "ZW" },
    { 0x300A, "EC" },
    { 0x3401, "KW" },
    { 0x3409, "PH" },
    { 0x340A, "CL" },
    { 0x3801, "AE" },
    { 0x380A, "UY" },
    { 0x3C01, "BH" },
    { 0x3C0A, "PY" },
    { 0x4001, "QA" },
    { 0x400A, "BO" },
    { 0x440A, "SV" },
    { 0x480A, "HN" },
    { 0x4C0A, "NI" },
    { 0x500A, "PR" }
};


int WINAPI GetLocaleInfoW_9x(
    LCID Locale,        // locale identifier
    LCTYPE LCType,      // information type 
    LPWSTR lpLCData,    // information buffer
    int cchData         // size of buffer
)
{
    int nRet = 0;

    /* replace default locale parameters */
    if( LOCALE_SYSTEM_DEFAULT == Locale )
        Locale = GetSystemDefaultLCID();
    else if( LOCALE_USER_DEFAULT == Locale )
        Locale = GetUserDefaultLCID();

    /* iso language codes not supported on win9x */
    if( LOCALE_SISO639LANGNAME == LCType )
    {
        _pair key = { PRIMARYLANGID( LANGIDFROMLCID( Locale ) ), "" };
        _pair * result;
        
        result = (_pair *) bsearch( &key, _lang_code, sizeof( _lang_code ) / sizeof( _pair ), sizeof( _pair ), pair_compare );

        if( result )
        {
            /* MultiByteToWideChar has the same return values even if lpLCData is NULL */
            nRet = MultiByteToWideChar( CP_ACP, 0, result->value, -1, lpLCData, cchData );
        }
        else
        {
            /* set the appropriate error */
            SetLastError( ERROR_INVALID_PARAMETER );
        }
    }

    /* iso country codes not supported on win9x */
    else if( LOCALE_SISO3166CTRYNAME == LCType )
    {
        _pair key = { LANGIDFROMLCID( Locale ), "" };
        _pair * result;
        
        result = (_pair *) bsearch( &key, _ctry_code, sizeof( _ctry_code ) / sizeof( _pair ), sizeof( _pair ), pair_compare );

        if( result )
        {
            /* MultiByteToWideChar has the same return values even if lpLCData is NULL */
            nRet = MultiByteToWideChar( CP_ACP, 0, result->value, -1, lpLCData, cchData );
        }
        else
        {
            /* set the appropriate error */
            SetLastError( ERROR_INVALID_PARAMETER );
        }
    }

    /* fallback to ansi version */
    else
    {
        LPSTR lpLCDataA  = NULL;
        DWORD dwLastError;

        // reserve a necessary buffer for
        // an ascii string
        lpLCDataA = (LPSTR)HeapAlloc( 
            GetProcessHeap( ), 
            HEAP_ZERO_MEMORY, 
            cchData );

        if ( lpLCDataA )
        {
            nRet = GetLocaleInfoA(
                Locale,
                LCType,
                lpLCDataA,
                cchData );

            dwLastError = GetLastError( );

            // convert to result back to unicode
            MultiByteToWideChar( 
                CP_ACP, 
                0, 
                lpLCDataA, 
                -1, 
                lpLCData, 
                cchData );

            /* LastError not always reset */
/*            assert( 0 == GetLastError( ) ); */
        
            /* free the buffer for the ascii string */
            HeapFree( 
                GetProcessHeap( ), 
                0,
                (LPVOID)lpLCDataA );
                        
            SetLastError( dwLastError );        
        }
    }

    return nRet;
}





