/*************************************************************************
 *
 *  $RCSfile: sockimpl.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __OSL_SOCKIMPL_H__
#define __OSL_SOCKIMPL_H__

#include <premac.h>
#include <OpenTptInternet.h>
#include <OpenTptLinks.h>
#include <Threads.h>
#include <postmac.h>

#define kInvalidTask 			-1
#define kInvalidThreadID		-1
#define kInvalidThreadTaskRef 	NULL

#define INFINITE			-1
#define kMaxSocketSetSize	64

enum {
	T_TIMEOUT = (OTEventCode)0x8000
};

/*****************************************************************************/
/* Implementation of data types */
/*****************************************************************************/
typedef struct OTSyncEvent {
	OTResult		result;
} OTSyncEvent;

typedef struct T8022Address	IpxAddress;

typedef union TSocketAddress {
	OTAddressType	fAddressType;
	InetAddress		fInet;
	IpxAddress		fIpx;
} TSocketAddress;

typedef struct THostAddress {
	InetDomainName	name;
	TSocketAddress	addr;
} THostAddress;

struct _stream {
	void*	ConnectTerminated;
};

struct _datagram {
	TSocketAddress	defaultPeer;
};

typedef struct TSocket {
	EndpointRef		epRef;
	TEndpointInfo	epInfo;
	OTResult		result;
	OTSyncEvent		fSyncComplete;
	OTList			inconList;
	const sal_Char		*pszCfgPath;
	struct _stream		fStream;
	struct _datagram	fDatagram;
	UInt32			servtype;
	sal_Bool			listening;
#ifdef DEBUG
	InetDomainName	debug_localAddr;
	InetDomainName	debug_peerAddr;
#endif
} TSocket;

/* DNS utility functions */
OSStatus	OTResolveInetHost(InetHost host, InetDomainName name);
OSStatus	OTResolveInetHostName(const sal_Char *pszHostName, InetHostInfo *pHostInfo);

/* Socket utility functions */
OTResult	OTWaitForPending(EndpointRef epRef, long timeout);
OTResult	OTWaitForMultiplePending(EndpointRef *refList[], int numList, long timeout);

/* Event gate functions */

void 		OTResetEvent(OTSyncEvent *sync);
void		OTSetEvent(OTSyncEvent *sync, OTResult result);
OTResult	OTGetEvent(OTSyncEvent *sync);
OTResult	OTWaitEvent(OTSyncEvent *sync, long timeout);

/* Incoming connection queueing */

OSStatus OTGetInConnect(OTList *list, TCall *call);
OSStatus OTEnqueueInConnect(OTList *list, const TCall *call);
OSStatus OTDequeueInConnect(OTList *list, OTSequence sequence);

/* socket notifier callback */

pascal void SocketNotifier(void *context, OTEventCode code, OTResult result, void *cookie);

#endif
