PRJ=..
PRJNAME=product
TARGET=udk

.SEQUENTIAL: $(DIRLIST)

# ------------------------------------------------------------------
.INCLUDE: settings.mk
# ------------------------------------------------------------------

PRODUCT_NAME=$(TARGET)$(UDK_MAJOR).$(UDK_MINOR).$(UDK_MICRO)
PRODUCT_ZIPPREFIX=$(PRODUCT_NAME)

PRODUCTZIPFILE=$(PRODUCT_NAME).zip
PRODUCTTARGZFILE=$(PRODUCT_NAME).tar.gz
ODK_PARTZIPFILE=$(PRODUCT_NAME)_odk.zip
ODK_PARTTARGZFILE=$(PRODUCT_NAME)_odk.tar.gz

DESTDIR=$(OUT)$/bin$/$(PRODUCT_NAME)
DESTDIRINC=$(DESTDIR)$/include
DESTDIRIDL=$(DESTDIR)$/idl
DESTDIRXML=$(DESTDIR)$/xml
DESTDIREXAMPLES=$(DESTDIR)$/examples
DESTDIREXAMPLESCPP=$(DESTDIREXAMPLES)$/cpp
DESTDIRSETTINGS=$(DESTDIR)$/settings

.IF "$(BUILD_SOSL)"!=""
# for OO build
DESTDIRJAR=$(DESTDIR)$/classes
.ENDIF

BINOUT=$(SOLARBINDIR)
INCOUT=$(SOLARINCDIR)
IDLOUT=$(SOLARIDLDIR)
.IF "$(SOLXMLDIR)" == ""
XMLOUT=$(SOLARBINDIR)$/..$/xml
.ELSE
XMLOUT=$(SOLARXMLDIR)
.ENDIF
LIBOUT=$(SOLARLIBDIR)

.IF "$(GUI)"=="WNT"
#####################
# WNT ONLY
#####################
MY_DLLPREFIX=
MY_DLLPOSTFIX=.dll
MY_VERSION_DLLPOSTFIX=.dll
MY_VERSION_LINKPOSTFIX=
MY_VERSION_LINKTARGETPOSTFIX=
MY_MAJOR=$(UDK_MAJOR)
EXEPOSTFIX=.exe
DLLOUT=$(SOLARBINDIR)

# bugs in 16-bit tools
MY_DELETE_RECURSIVE=del /sxyf
MY_TEXTCOPY=cat
.ELSE
#####################
# UNX ONLY
#####################
DLLOUT=$(SOLARLIBDIR)
MY_DLLPOSTFIX=.so
MY_VERSION_DLLPOSTFIX=.so.$(UDK_MAJOR).$(UDK_MINOR).$(UDK_MICRO)
MY_VERSION_LINKPOSTFIX=.so.$(UDK_MAJOR)
MY_VERSION_LINKTARGETPOSTFIX=.$(UDK_MINOR).$(UDK_MICRO)
MY_MAJOR=
MY_DLLPREFIX=lib
EXEPOSTFIX=
MY_DELETE_RECURSIVE=rm -rf
MY_TEXTCOPY= tr -d "\015"
.ENDIF
MY_TEXTCOPY_SOURCEPRE=<
MY_TEXTCOPY_TARGETPRE=>

.IF "$(OS)$(CPU)"=="SOLARISS"
##############
# SOLARIS SPARC
##############
DESTDIRBIN=$(DESTDIR)$/solsparc$/bin
DESTDIRLIB=$(DESTDIR)$/solsparc$/lib
DESTDIRDLL=$(DESTDIRLIB)

.IF "$(COM)"=="GCC"
BINDINGDLL=$(COMNAME)_uno
STLPORTLIBNAME=libstlport_gcc.so
.ELSE
BINDINGDLL=sunpro5_uno
STLPORTLIBNAME=libstlport_sunpro.so
.ENDIF

.ELIF "$(OS)$(CPU)"=="SOLARISI"
##########
# SOLARIS INTEL
##########
DESTDIRBIN=$(DESTDIR)$/solia$/bin
DESTDIRLIB=$(DESTDIR)$/solia$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_sunpro.so

.IF "$(COM)"=="GCC"
BINDINGDLL=$(COMNAME)_uno
.ELSE
BINDINGDLL=sunpro5_uno
.ENDIF

.ELIF "$(OS)"=="LINUX"
###########
# LINUX
###########
DESTDIRBIN=$(DESTDIR)$/linux$/bin
DESTDIRLIB=$(DESTDIR)$/linux$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_gcc.so
BINDINGDLL=$(COMNAME)_uno

.IF "$(COMID)"=="gcc3"
ADDITIONAL_DLLS= \
       $(DESTDIRDLL)$/libgcc_s.so.1            \
       $(DESTDIRDLL)$/libgcc_s.so              \
       $(DESTDIRDLL)$/libstdc++.so.$(SHORTSTDCPP3)           \
       $(DESTDIRDLL)$/libstdc++.so.$(LIBSTDCPP3)
.ENDIF

.ELIF "$(OS)"=="FREEBSD"
###########
# FREEBSD
###########
DESTDIRBIN=$(DESTDIR)$/freebsd$/bin
DESTDIRLIB=$(DESTDIR)$/freebsd$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_gcc.so
BINDINGDLL=$(COMNAME)_uno
.IF "$(COMID)"=="gcc3"
ADDITIONAL_DLLS= \
       $(DESTDIRDLL)$/libgcc_s.so.1            \
       $(DESTDIRDLL)$/libgcc_s.so              \
       $(DESTDIRDLL)$/libstdc++.so.$(SHORTSTDCPP3)           \
       $(DESTDIRDLL)$/libstdc++.so.$(LIBSTDCPP3)
.ENDIF

.ELIF "$(OS)"=="NETBSD"
###########
# NETBSD
###########
DESTDIRBIN=$(DESTDIR)$/netbsd$/bin
DESTDIRLIB=$(DESTDIR)$/netbsd$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_gcc.so
BINDINGDLL=$(COMNAME)_uno
.IF "$(COMID)"=="gcc3"
ADDITIONAL_DLLS= \
       $(DESTDIRDLL)$/libgcc_s.so.1            \
       $(DESTDIRDLL)$/libgcc_s.so              \
       $(DESTDIRDLL)$/libstdc++.so.$(SHORTSTDCPP3)           \
       $(DESTDIRDLL)$/libstdc++.so.$(LIBSTDCPP3)
.ENDIF

.ELIF "$(OS)"=="IRIX"
###########
# IRIX
###########
DESTDIRBIN=$(DESTDIR)$/irix$/bin
DESTDIRLIB=$(DESTDIR)$/irix$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_gcc.so
BINDINGDLL=gcc2_uno

.ELIF "$(OS)"=="MACOSX"
###########
# MACOSX
###########
DESTDIRBIN=$(DESTDIR)$/macosx$/bin
DESTDIRLIB=$(DESTDIR)$/macosx$/lib
DESTDIRDLL=$(DESTDIRLIB)
STLPORTLIBNAME=libstlport_gcc.dylib
BINDINGDLL=gcc2_uno

.ELIF "$(OS)"=="WNT"
###########
# WINDOWS
###########
DESTDIRBIN=$(DESTDIR)$/windows$/bin
DESTDIRLIB=$(DESTDIR)$/windows$/lib
DESTDIRDLL=$(DESTDIRBIN)
BINDINGDLL=msci_uno
STLPORTLIBNAME=stlport_vc6.dll
ADDITIONAL_DLLS= \
	$(DESTDIRDLL)$/w9xucwrp.dll
.ENDIF

#STLPORTDEST=$(DESTDIRDLL)$/$(STLPORTLIBNAME)
#.IF "$(STLPORT4)" != ""
# in OOo build environment
#STLPORTOUT=$(STLPORT4)$/lib$/$(STLPORTLIBNAME)
#.ELSE
# hamburg build environment
#STLPORTOUT=$(DLLOUT)$/$(STLPORTLIBNAME)
#.ENDIF

STLPORTDEST=$(DESTDIRDLL)$/$(STLPORTLIBNAME)
.IF "$(STLPORT4)" != ""
# in OOo build environment
.IF "($STLPORT4)" != "NO_STLPORT4"
.IF "$(OS)"=="WNT"
STLPORTOUT=$(SOLARVER)$/$(UPD)$/$(INPATH)$/bin$/$(STLPORTLIBNAME)
.ELSE   # "$(OS)"=="WNT"
STLPORTOUT=$(SOLARVER)$/$(UPD)$/$(INPATH)$/lib$/$(STLPORTLIBNAME)
.ENDIF  # "$(OS)"=="WNT"
.ELSE   # "($STLPORT4)" != "NO_STLPORT4"
STLPORTOUT=$(STLPORT4)$/lib$/$(STLPORTLIBNAME)
.ENDIF  # "($STLPORT4)" != "NO_STLPORT4"
.ELSE   # "$(STLPORT4)" != ""
# hamburg build environment
STLPORTOUT=$(DLLOUT)$/$(STLPORTLIBNAME)
.ENDIF  # "$(STLPORT4)" != ""


COMPONENTLIST = \
	acceptor	\
	brdgfctr	\
	connectr	\
	corefl		\
	cpld		\
	defreg		\
	dynamicloader	\
	impreg		\
	insp		\
	inv		\
	invadp		\
	jen		\
	namingservice	\
	proxyfac	\
	rdbtdp		\
	remotebridge	\
	simreg		\
	smgr		\
	stm		\
	tcv		\
	tdmgr		\
	uuresolver

INCLUDETOPDIRLIST= \
	$(INCOUT)$/sal 		\
	$(INCOUT)$/salhelper	\
	$(INCOUT)$/rtl 		\
	$(INCOUT)$/osl 		\
	$(INCOUT)$/store 	\
	$(INCOUT)$/typelib 	\
	$(INCOUT)$/uno 		\
	$(INCOUT)$/cppu 	\
	$(INCOUT)$/cppuhelper 	\
	$(INCOUT)$/bridges 	

INCLUDEDIRLIST={$(subst,/,$/ $(shell $(FIND) $(INCLUDETOPDIRLIST) -type d -print))}

IDLDIRLIST=\
	{$(subst,/,$/ $(shell $(FIND) \
	$(IDLOUT)$/com$/sun$/star$/beans \
	$(IDLOUT)$/com$/sun$/star$/bridge \
	$(IDLOUT)$/com$/sun$/star$/connection \
	$(IDLOUT)$/com$/sun$/star$/container \
	$(IDLOUT)$/com$/sun$/star$/io \
	$(IDLOUT)$/com$/sun$/star$/java \
	$(IDLOUT)$/com$/sun$/star$/lang \
	$(IDLOUT)$/com$/sun$/star$/loader \
	$(IDLOUT)$/com$/sun$/star$/reflection \
	$(IDLOUT)$/com$/sun$/star$/registry \
	$(IDLOUT)$/com$/sun$/star$/script \
	$(IDLOUT)$/com$/sun$/star$/test \
	$(IDLOUT)$/com$/sun$/star$/uno \
	-type d -print))}

INCLUDEFILELIST=\
    $(INCOUT)$/udkversion.mk \
    $(INCOUT)$/com$/sun$/star$/uno$/Any.h \
    $(INCOUT)$/com$/sun$/star$/uno$/Any.hxx \
    $(INCOUT)$/com$/sun$/star$/uno$/genfunc.h \
    $(INCOUT)$/com$/sun$/star$/uno$/genfunc.hxx \
    $(INCOUT)$/com$/sun$/star$/uno$/Reference.h \
    $(INCOUT)$/com$/sun$/star$/uno$/Reference.hxx \
    $(INCOUT)$/com$/sun$/star$/uno$/Sequence.h \
    $(INCOUT)$/com$/sun$/star$/uno$/Sequence.hxx \
    $(INCOUT)$/com$/sun$/star$/uno$/Type.h \
    $(INCOUT)$/com$/sun$/star$/uno$/Type.hxx

XMLLIST= \
	$(foreach,c,$(COMPONENTLIST) $(DESTDIRXML)$/$c.xml) \
	$(DESTDIRXML)$/module-description.dtd
    
INCLUDELIST=\
	{$(subst,/,$/ $(shell $(FIND) $(INCLUDETOPDIRLIST) -type f -print))} \
    $(INCLUDEFILELIST)

DESTINCLUDELIST={$(subst,$(SOLARINCDIR),$(DESTDIRINC) $(INCLUDELIST))}

IDLLIST={$(subst,/,$/ $(shell $(FIND) $(IDLDIRLIST) -type f -print))}
DESTIDLLIST={$(subst,$(IDLOUT),$(DESTDIRIDL) $(IDLLIST))}

DIRLIST = \
	$(DESTDIR)  \
	$(DESTDIRBIN)       \
	$(DESTDIRLIB)       \
	$(DESTDIRJAR)       \
	$(DESTDIRXML)       \
	$(DESTDIRINC)       \
	$(DESTDIRSETTINGS)  \
	$(DESTDIREXAMPLESCPP)   \
	$(DESTDIREXAMPLESCPP)$/remoteclient \
	$(DESTDIREXAMPLESCPP)$/counter      \
	{$(subst,$(INCOUT),$(DESTDIRINC) $(INCLUDEDIRLIST))}        \
    $(DESTDIRINC)$/com$/sun$/star$/uno                          \
	{$(subst,$(IDLOUT),$(DESTDIRIDL) $(IDLDIRLIST))}

EXELIST = \
	$(DESTDIRBIN)$/cppumaker$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/regcomp$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/regmerge$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/regview$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/rdbmaker$(EXEPOSTFIX)	\
	$(DESTDIRBIN)$/idlcpp$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/idlc$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/javamaker$(EXEPOSTFIX) 	\
	$(DESTDIRBIN)$/xml2cmp$(EXEPOSTFIX)	\
	$(DESTDIRBIN)$/uno$(EXEPOSTFIX) \
	$(DESTDIRBIN)$/autodoc$(EXEPOSTFIX)

ODKDLLLIST = \
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)prot_uno_uno$(MY_DLLPOSTFIX)            		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)juh$(MY_DLLPOSTFIX) 

.IF "$(BUILD_SOSL)"!=""
# for OO build
DLLLIST += \
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)rmcxt$(MY_MAJOR)$(MY_VERSION_DLLPOSTFIX) 		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)sal$(MY_MAJOR)$(MY_VERSION_DLLPOSTFIX)  		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)store$(MY_MAJOR)$(MY_VERSION_DLLPOSTFIX) 		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)reg$(MY_MAJOR)$(MY_VERSION_DLLPOSTFIX)   		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)cppu$(MY_MAJOR)$(MY_VERSION_DLLPOSTFIX)  		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)cppuhelper$(UDK_MAJOR)$(COMID)$(MY_DLLPOSTFIX) 	\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)salhelper$(UDK_MAJOR)$(COMID)$(MY_DLLPOSTFIX)	\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)javaloader$(MY_DLLPOSTFIX)          		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)$(BINDINGDLL)$(MY_DLLPOSTFIX)           		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)java_uno$(MY_DLLPOSTFIX)            		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)iiop_uno$(MY_DLLPOSTFIX)                		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)urp_uno$(MY_DLLPOSTFIX)                 		\
	$(STLPORTDEST) 									\
	$(ADDITIONAL_DLLS) 

DLLLIST+= \
	$(foreach,c,$(COMPONENTLIST) $(DESTDIRDLL)$/$(MY_DLLPREFIX)$c$(MY_DLLPOSTFIX))

.IF "$(GUI)"=="UNX"
LINKLIST = \
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)rmcxt$(MY_VERSION_LINKPOSTFIX)		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)sal$(MY_VERSION_LINKPOSTFIX)  		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)store$(MY_VERSION_LINKPOSTFIX)		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)reg$(MY_VERSION_LINKPOSTFIX) 		\
	$(DESTDIRDLL)$/$(MY_DLLPREFIX)cppu$(MY_VERSION_LINKPOSTFIX)
.ENDIF

.ENDIF

.IF "$(BUILD_SOSL)"!=""
JARLIST = \
	$(DESTDIRJAR)$/sandbox.jar 	\
	$(DESTDIRJAR)$/jurt.jar 	\
	$(DESTDIRJAR)$/ridl.jar 	\
	$(DESTDIRJAR)$/jut.jar 		\
	$(DESTDIRJAR)$/juh.jar 		\
	$(DESTDIRJAR)$/java_uno.jar
.ENDIF

.IF "$(GUI)"=="WNT"  
LIBLIST = \
	$(DESTDIRLIB)$/istore.lib 	\
	$(DESTDIRLIB)$/ireg.lib 	\
	$(DESTDIRLIB)$/isal.lib 	\
	$(DESTDIRLIB)$/isalhelper.lib 	\
	$(DESTDIRLIB)$/icppu.lib 	\
	$(DESTDIRLIB)$/icppuhelper.lib 	\
	$(DESTDIRLIB)$/irmcxt.lib 	\
	$(DESTDIRLIB)$/stlport_vc6.lib
.ENDIF

SETTINGSLIST= \
	$(DESTDIRSETTINGS)$/settings.mk \
	$(DESTDIRSETTINGS)$/std.mk \
	$(DESTDIRSETTINGS)$/stdtarget.mk \
	$(DESTDIRSETTINGS)$/dk.mk

EXAMPLESLIST= \
	$(DESTDIREXAMPLES)$/README \
	$(DESTDIREXAMPLESCPP)$/remoteclient$/remoteclient.cxx \
	$(DESTDIREXAMPLESCPP)$/remoteclient$/remoteclientsample.xml \
	$(DESTDIREXAMPLESCPP)$/remoteclient$/Makefile         \
	$(DESTDIREXAMPLESCPP)$/remoteclient$/exports.dxp      \
	$(DESTDIREXAMPLESCPP)$/counter$/XCountable.idl	   \
	$(DESTDIREXAMPLESCPP)$/counter$/counter.xml	   \
	$(DESTDIREXAMPLESCPP)$/counter$/counter.cxx	   \
	$(DESTDIREXAMPLESCPP)$/counter$/countermain.cxx    \
	$(DESTDIREXAMPLESCPP)$/counter$/Makefile    	   \
	$(DESTDIREXAMPLESCPP)$/counter$/exports.dxp 	   


FILELIST= \
    $(EXELIST) \
    $(XMLLIST) \
	$(ODKDLLLIST) 		\
    $(LIBLIST) 		\
	$(SETTINGSLIST) 	\
	$(EXAMPLESLIST)		\
	$(DESTINCLUDELIST)	\
	$(DESTIDLLIST)
 
ADDITIONALFILELIST= \
    $(DESTDIRBIN)$/udkapi.rdb \
	$(DLLLIST) 		\
	$(LINKLIST)		\
	$(JARLIST)
    
#--------------------------------------------------
# TARGETS
#--------------------------------------------------
ALLTARGETS = \
	$(MISC)$/deltree.txt 	\
	$(DIRLIST) 		\
	$(FILELIST)

.IF "$(GUI)"=="WNT"
ALLTARGETS+= \
    $(BIN)$/$(ODK_PARTZIPFILE)
.ELSE
ALLTARGETS+= \
    $(BIN)$/$(ODK_PARTTARGZFILE)
.ENDIF
    
.IF "$(BUILD_SOSL)"!=""
#for OpenOffice build additionally a complete UDK
ALLTARGETS+= \
	$(ADDITIONALFILELIST)
.ENDIF

.IF "$(GUI)"=="WNT"
ALLTARGETS+= \
    $(BIN)$/$(PRODUCTZIPFILE)
.ELSE
ALLTARGETS+= \
    $(BIN)$/$(PRODUCTTARGZFILE)
.ENDIF

    
all: \
    $(ALLTARGETS) 

$(MISC)$/deltree.txt : deltree.txt
	+-$(RM) $(DESTDIR)$/..$/$(PRODUCT_ZIPPREFIX).zip >& $(NULLDEV)
	+-$(RM) $(DESTDIR)$/..$/$(PRODUCT_ZIPPREFIX).tar >& $(NULLDEV)
	+-$(RM) $(DESTDIR)$/..$/$(PRODUCT_ZIPPREFIX).tar.gz >& $(NULLDEV)
	+-$(MY_DELETE_RECURSIVE) $(DESTDIR) >& $(NULLDEV)
	@echo "" > $(MISC)$/deltree.txt

$(DIRLIST) : $(MISC)$/deltree.txt
	$(MKDIRHIER)	$@

$(DESTDIRBIN)$/udkapi.rdb : $(BINOUT)$/udkapi.rdb
	$(GNUCOPY) -p $(BINOUT)$/udkapi.rdb $@

.IF "$(STLPORTDEST)" != ""
#OOo build environment
$(STLPORTDEST) : $(STLPORTOUT)
 	$(GNUCOPY) -p $(STLPORTOUT) $@
.ENDIF

$(DESTDIRBIN)$/%$(EXEPOSTFIX) : $(BINOUT)$/%$(EXEPOSTFIX) $(DIRLIST)
	$(GNUCOPY) -p $(BINOUT)$/$(@:f) $@

$(DESTDIRDLL)$/%$(MY_DLLPOSTFIX) : $(DLLOUT)$/%$(MY_DLLPOSTFIX) $(DIRLIST)
	$(GNUCOPY) -p $(DLLOUT)$/$(@:f) $@

$(DESTDIRDLL)$/%$(MY_VERSION_DLLPOSTFIX) : $(DLLOUT)$/%$(MY_VERSION_DLLPOSTFIX) $(DIRLIST)
	$(GNUCOPY) -p $(DLLOUT)$/$(@:f) $@

$(DESTDIRDLL)$/%$(MY_VERSION_LINKPOSTFIX) : $(DESTDIRDLL)$/%$(MY_VERSION_DLLPOSTFIX) $(DIRLIST)
	-rm -f $@
	-rm -f $(@:db)
	+ln -s $(@:f)$(MY_VERSION_LINKTARGETPOSTFIX) $@
	+ln -s $(@:f)$(MY_VERSION_LINKTARGETPOSTFIX) $(@:db)


#---------------------------------------------------------
# special targets for linux gcc3 
.IF "$(COMID)"=="gcc3"


$(DLLOUT)$/libstdc++.so.$(LIBSTDCPP3) :
       $(GCCINSTLIB) libstdc++.so.$(LIBSTDCPP3) $(DLLOUT)

# Otherwise you get circular dependencies
$(DESTDIRDLL)$/libstdc++.so.$(LIBSTDCPP3) : $(DLLOUT)$/libstdc++.so.$(LIBSTDCPP3) $(DIRLIST)
       -rm -f $@
       $(GNUCOPY) -p $(DLLOUT)$/libstdc++.so.$(LIBSTDCPP3) $@

$(DESTDIRDLL)$/libstdc++.so.$(SHORTSTDCPP3) : $(DESTDIRDLL)$/libstdc++.so.$(LIBSTDCPP3) $(DIRLIST)
       -rm -f $@
       +ln -s libstdc++.so.$(LIBSTDCPP3) $@
.ENDIF

$(DLLOUT)$/libgcc_s.so.1 :
       $(GCCINSTLIB) libgcc_s.so.1 $(DLLOUT)

$(DESTDIRDLL)$/libgcc_s.so.1 : $(DLLOUT)$/libgcc_s.so.1 $(DIRLIST)
	-rm -f $@
	$(GNUCOPY) -p $(DLLOUT)$/libgcc_s.so.1 $@

$(DESTDIRDLL)$/libgcc_s.so : $(DESTDIRDLL)$/libgcc_s.so.1 $(DIRLIST)
	-rm -f $@
	+ln -s libgcc_s.so.1 $@
#-------------------------------------------------------------

$(DESTDIRJAR)$/%.jar : $(BINOUT)$/%.jar $(DIRLIST)
	$(GNUCOPY) -p $(BINOUT)$/$(@:f) $@

$(DESTDIRXML)$/%.xml : $(XMLOUT)$/%.xml $(DIRLIST)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIRXML)$/module-description.dtd : $(XMLOUT)$/module-description.dtd $(DIRLIST)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $(XMLOUT)$/module-description.dtd $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIRLIB)$/%.lib : $(LIBOUT)$/%.lib $(DIRLIST)
	$(GNUCOPY) -p $(LIBOUT)$/$(@:f) $@

$(DESTDIRSETTINGS)$/%.mk : $(PRJ)$/settings$/%.mk $(DIRLIST)
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

# EXAMPLES CPP RULE
$(DESTDIREXAMPLESCPP)$/% : $(PRJ)$/examples$/cpp$/% 
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIREXAMPLES)$/README : $(PRJ)$/examples$/README
	$(GNUCOPY) -p $(PRJ)$/examples$/README $@

$(DESTDIRIDL)$/% : $(IDLOUT)$/%
	+-rm -f $@
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIRINC)$/% : $(INCOUT)$/%
	+-rm -f $@
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

# ------------------------------------------------------------------------------------
#      ZIP IT
# ------------------------------------------------------------------------------------
$(BIN)$/$(ODK_PARTZIPFILE) : $(DIRLIST) $(FILELIST)
	+-$(RM) -f $(ADDITIONALFILELIST) >& $(NULLDEV)
	+-$(RM) $@
	+cd $(DESTDIR)$/.. && zip -9 -r $(ODK_PARTZIPFILE) $(PRODUCT_NAME)

$(BIN)$/$(ODK_PARTTARGZFILE) : $(DIRLIST) $(FILELIST)
	+-$(MY_DELETE_RECURSIVE) $(ADDITIONALFILELIST) >& $(NULLDEV)
	+-$(RM) $@
	+cd $(DESTDIR)$/.. && tar cvf - $(PRODUCT_NAME) | gzip -c > $(ODK_PARTTARGZFILE)
    
$(BIN)$/$(PRODUCTZIPFILE) : $(BIN)$/$(ODK_PARTZIPFILE) $(ADDITIONALFILELIST)
	+-$(RM) $@
	+cd $(DESTDIR)$/.. && zip -9 -r $(PRODUCTZIPFILE) $(PRODUCT_NAME)

$(BIN)$/$(PRODUCTTARGZFILE) : $(BIN)$/$(ODK_PARTTARGZFILE) $(ADDITIONALFILELIST)
	+-$(RM) $@
	+cd $(DESTDIR)$/.. && tar cvf - $(PRODUCT_NAME) | gzip -c > $(PRODUCTTARGZFILE)

