/*************************************************************************
 *
 *  $RCSfile: gridctrl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_GRIDCTRL_HXX
#define _SVX_GRIDCTRL_HXX

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _SVX_DBBROWSE_HXX
#include "dbbrowse.hxx"
#endif

#ifndef __SVX_DBCURSOR_HXX__
#include <svx/dbcursor.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _XNUMBERFORMATTER_REF
#define _XNUMBERFORMATTER_REF
USR_DECLIMPL_REF( XNumberFormatter, XInterface );
#endif

//==================================================================
// DBGridColumn, Spaltenbeschreibung
//==================================================================
class DBGridColumn
{
	String	aName;
	UINT32	nFormatKey;
	UINT16	nDBType;
	CellControllerRef xController;

public:
	DBGridColumn(const String& rName, UINT16 nType, UINT32 nKey = 0)
		:aName(rName)
		,nDBType(nType)
		,nFormatKey(nKey){}

	const String& GetName() const {return aName;}
	UINT16	GetType() const {return nDBType;}
	UINT32	GetKey() const {return nFormatKey;}

	void SetController(CellControllerRef _xController) {xController = _xController;}
	const CellControllerRef& GetController() const {return xController;}
};

DECLARE_LIST(DBGridColumns, DBGridColumn*);

//==================================================================
// DBGridControl
//==================================================================
class DBGridControl: public DbBrowseBox
{
	class AbsolutePos : public NumericField
	{
	public:
		AbsolutePos(Window* pParent, WinBits nStyle);
		AbsolutePos(Window* pParent, const ResId& rResId);

		virtual void KeyInput(const KeyEvent& rEvt);
		virtual void LoseFocus();
	};

	friend class DBGridControl::AbsolutePos;

public:

	// diese Optionen werden verodert und geben an, welche der einzelnen feature
	// freigegeben werden koennen, default ist readonly also 0
	enum Option
	{
		READONLY	= 0,
		INSERT		= 1,
		UPDATE		= 2,
		DELETE		= 4
	};

	INT32			nSeekPos;			// Position in der BrowseBox
	INT32			nCurrentPos;		// Position des selektierten Datensatzes
	INT32			nTotalCount;		// wird gesetzt, wenn der DatenCursor mit dem Zhlen der
										// Datenstze fertig ist
										// initial Wert ist -1
	XDatabaseCursorRef	 xDataCursor;	// Cursor fuer Updates
	XDatabaseIteratorRef xSeekCursor;	// Cursor zum seeken

	XNumberFormatterRef	 xFormatter;
	AnySequence		aSeekRecord,		// Datensatz an der Seekposition
					aCurrentRecord,		// Datensatz der aktuellen Zeile
					aAppendRecord;		// Datensatz zum einfuegen

	DBGridColumns	aColumns;			// Spaltenbeschreibung

	//	zusaetzliche Controls
	FixedText		aRecordText;
	AbsolutePos		aAbsolute;			// AbsolutePositionierung
	FixedText		aRecordOf;
	FixedText		aRecordCount;

	ImageButton		aFirstBtn;			// ImageButton fuer 'gehe zum ersten Datensatz'
	ImageButton		aPrevBtn;			// ImageButton fuer 'gehe zum vorhergehenden Datensatz'
	ImageButton		aNextBtn;			// ImageButton fuer 'gehe zum naechsten Datensatz'
	ImageButton		aLastBtn;			// ImageButton fuer 'gehe zum letzten Datensatz'
	ImageButton		aNewBtn;			// ImageButton fuer 'gehe zum neuen Datensatz'

	UINT16			nRecordStatus;
	UINT16			nOptions;			// Was kann das Control (Insert, Update, Delete)
										// default readonly
	UINT16			nEditMode;
	BOOL			bFrozen;			// Anzeige ist eingefroren
	BOOL			bDesignMode;		// default = FALSE

protected:
	virtual BOOL SeekRow(long nRow);
	virtual void VisibleRowsChanged( long nNewTopRow, USHORT nNumRows);
	virtual void PaintStatusCell(OutputDevice& rDev, const Rectangle& rRect) const;
	virtual void PaintCell(OutputDevice& rDev, const Rectangle& rRect, USHORT nColId) const;
	virtual RowStatus GetRowStatus(long nRow) const;
	virtual void CursorMoving(long nNewRow, USHORT nNewCol);
	virtual void CursorMoved();
	virtual void ArrangeControls(USHORT& nX, USHORT nY);
	virtual ULONG GetTotalCellWidth(long nRow, USHORT nColId);
	virtual void Command(const CommandEvent& rEvt);

	virtual CellController* GetController(long nRow, USHORT nCol);
	virtual void InitController(CellControllerRef& rController, long nRow, USHORT nCol);

	virtual void CellModified();
	virtual BOOL SaveModified();
	virtual BOOL IsModified() const;

public:
	DBGridControl(Window* pParentWin);
	virtual ~DBGridControl();

	void Clear();
	void InvalidateStatus();
	void SetNumberFormatter(XNumberFormatterRef _xFormatter) {xFormatter = _xFormatter;}
	XNumberFormatterRef GetNumberFormatter() const {return xFormatter;}

	// die Datenquelle
	// die Optionen koennen die Updatefaehigkeiten noch einschraenken, nicht erweitern
	virtual void SetSource(XDatabaseCursorRef& rCursor, USHORT nOpts = INSERT | UPDATE | DELETE);
	XDatabaseCursorRef GetSource() const {return xDataCursor;}

	void SetDesignMode(BOOL bMode);
	BOOL IsDesignMode() const {return bDesignMode;}

	USHORT GetOptions() const {return nOptions;}

	// Positionierung
	void MoveToPosition(ULONG nPos);
	void MoveToFirst();
	void MoveToNext();
	void MoveToPrev();
	void MoveToLast();
	void AppendNew();

protected:
	void InitColumns(XDatabaseFieldsRef xFields);
	void RecalcRows(long nNewTopRow, USHORT nLinesOnScreen, BOOL bUpdateCursor);
	BOOL SeekCursor(long nRow, BOOL bAbsolute = FALSE);
	void CleanUp();		// aufraeumen eigener strukturen
	void AdjustRows();

	// Status Methoden fuer Controls
	void InvalidateAll();
	void InvalidateState(USHORT nWhich) {SetState(nWhich);}
	void SetState(USHORT nWhich);
	BOOL GetState(USHORT nWhich) const;
	String GetCellText(USHORT nColId) const;
	void DeleteSelectedRows();
	BOOL IsValidRecord() const {return !(nRecordStatus == DBRECORDSTATUS_DELETED ||
										 nRecordStatus == DBRECORDSTATUS_INVALID);}
	BOOL IsAppendRow(long nRow) const;

private:
	DECL_LINK(OnClick, Button*);
};

#endif // _SVX_GRIDCTRL_HXX
