/*************************************************************************
 *
 *  $RCSfile: LocalOfficeWindow.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: misha $ $Date: 2002/04/30 15:15:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.beans;

import java.awt.Component;
import java.awt.Canvas;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.SystemDependent;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.WindowAttribute;
import com.sun.star.awt.WindowClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.Exception;

/**
 * This class represents a local office window. 
 */
public class LocalOfficeWindow
	extends java.awt.Canvas
	implements OfficeWindow, XEventListener
{
	private transient OfficeConnection	mConnection;
	private transient XWindowPeer		mWindow;

	/**
	 * Construnctor.
	 *
	 * @param connection The office connection object the window 
	 *	belongs to.
	 */
	/* package */ LocalOfficeWindow(OfficeConnection connection)
	{
		mConnection	= connection;
		mConnection.addEventListener((XEventListener)this);
	}

	/**
	 * Retrives an AWT component object associated with the OfficeWindow.
	 *
	 * @return The AWT component object associated with the OfficeWindow.
	 */
	public Component getAWTComponent()
	{
		return this;
	}

	/**
	 * Retrives an UNO XWindowPeer object associated with the OfficeWindow.
	 *
	 * @return The UNO XWindowPeer object associated with the OfficeWindow.
	 */
	public XWindowPeer getUNOWindowPeer()
	{
		if (mWindow == null)
			createUNOWindowPeer();
		return mWindow;
	}

	/**
	 * Receives a notification about the connection has been closed.
	 * This method has to set the connection to <code>null</code>.
	 *
	 * @source The event object.
	 */
	public void disposing(EventObject source)
	{
		// Dispose the window! The office counts document windows 
		// and will not shutdown if the window has not been closed.
		if (mWindow != null)
			mWindow.dispose();
		mConnection	= null;
	}

	/**
	 * Creates a UNO window peer from native window.
	 */
	private void createUNOWindowPeer()
	{
		try {
			// Create UNO window peer fake parent.
			int	type	= getNativeWindowSystemType();
			XWindowPeer	parentPeer	= new JavaWindowPeerFake(
				getNativeWindow(), type);
			// Create a UNO toolkit.
			XMultiComponentFactory	compfactory;
			compfactory	= mConnection.getComponentContext().getServiceManager();
			XMultiServiceFactory	factory;
			factory	= (XMultiServiceFactory)UnoRuntime.queryInterface(
				XMultiServiceFactory.class, compfactory);
			Object		object	= factory.createInstance(
				"com.sun.star.awt.Toolkit");
			XToolkit	toolkit	= (XToolkit)UnoRuntime.queryInterface(
				XToolkit.class, object);
			// Create native window descriptor.
			WindowDescriptor	desc	= new WindowDescriptor();
			desc.Type	= WindowClass.TOP;
			desc.Parent	= parentPeer;
			desc.WindowServiceName	= "workwindow";
			desc.WindowAttributes	= (type == SystemDependent.SYSTEM_WIN32)?
				WindowAttribute.SHOW: WindowAttribute.SYSTEMDEPENDENT;
			// Create UNO window peer object.
			mWindow	= toolkit.createWindow(desc);
		} catch (com.sun.star.uno.Exception exp) {
		}
	}

	/**
	 * Retrives a platform dependant system window identifier.
	 *
	 * @return The system window identifier.
	 */
    private native long getNativeWindow();

	/**
	 * Retrives a platform dependant system window type.
	 *
	 * @return The system window type.
	 */
	private native int getNativeWindowSystemType();
}
