#!/usr/bin/awk -f

##
## Package: lingucomponent-tools
##
## Copyright (C) 2002, 2003 Pavel Jank (Pavel@Janik.cz)
##
## This file is licensed under GNU LGPL and SISSL license.
##

#
# This file converts ispell .AFF file into .aff file for myspell so it
# can be used as dictionary file for OpenOffice.org.
#

# This function prints the header line of the myspell aff file.
# Be sure to change those lines to match your language.

function Myspell_header () {
  # Those values match Czech language.
  print "SET ISO8859-2";
  print "TRY aeiouybcdlmnfjkprstvghqwxAEIOUYBCDLMNFJKPRSTVGHQWX";
}

function Myspell_footer () {
  # Nothing here. Czech language does not use additional flags. But
  # e.g. Deutsch does - REPs.
}

# This function dumps all rules gathered so far with corresponding header.

function Myspell_Flush_Rules () {
  if (CURRENT_RULE_NUMBER != 0) {
    print CURRENT_RULE " " CURRENT_FLAG " " CURRENT_FLAG_CROSS_PRODUCT " " CURRENT_RULE_NUMBER;

    for (i=0; i<CURRENT_RULE_NUMBER; i++)
      print RULES[i];

    CURRENT_RULE_NUMBER=0;
  }
}

function Ispell_Rule () {

  POS=index ($0, ">");
  LEFT=substr($0, 1, POS-1);
  gsub("[\t ]", "", LEFT);

  RIGHT=substr($0, POS+1);
  gsub("[\t ]", "", RIGHT);
  STRIPSTRING="0";
  
  if (RIGHT ~ "^-") {
    POS=index(RIGHT, ",");
    STRIPSTRING=substr(RIGHT, 2, POS-2);
    RIGHT=substr(RIGHT,POS+1);
  }

  # Myspell needs `0' here instead of `-' in ispell (see affentry.cxx: a 0 here
  # indicates the NULL string).
  if (RIGHT == "-")
    RIGHT="0";

  RULES[CURRENT_RULE_NUMBER] = sprintf("%s %s   %-11s %-10s %s",
				       CURRENT_RULE,
				       CURRENT_FLAG,
				       tolower(STRIPSTRING),
				       tolower(RIGHT), tolower(LEFT));

  CURRENT_RULE_NUMBER++;
}

BEGIN {
  Myspell_header();

  CURRENT_RULE_NUMBER = 0;
}

{
  # Clear line...
  gsub("[ \t]*#.*", "");

  if ($0 ~ "^$" || $0 ~ "^\t*$" || $0 ~ "[^ \t]>" || $0 ~ ">[^ \t]") {
    # Empty or commentary line - ignore!
  }
  else if ($0 == "prefixes") {
    Myspell_Flush_Rules();
    CURRENT_RULE = "PFX";
  }
  else if ($0 == "suffixes") {
    Myspell_Flush_Rules();
    CURRENT_RULE = "SFX";
  }
  else if ($1 == "flag") {
    Myspell_Flush_Rules();
    print "";
    CURRENT_FLAG=$2;
    if (index(CURRENT_FLAG, "*"))
      CURRENT_FLAG_CROSS_PRODUCT="Y";
    else
      CURRENT_FLAG_CROSS_PRODUCT="N";
    gsub("*", "", CURRENT_FLAG);
    gsub(":", "", CURRENT_FLAG);
  }
  else if ($0 ~ "[ \t]*.*[ \t]*>[ \t]*.*") {
    Ispell_Rule();
  }
}

END {
  Myspell_Flush_Rules();
  Myspell_footer();
}
