/*************************************************************************
 *
 *  $RCSfile: Test.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package test.com.sun.star.lib.iiopbridge;


import com.sun.star.uno.Environment;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.Union;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.uno.Union;
import com.sun.star.uno.Ascii;
import com.sun.star.uno.AsciiString;
import com.sun.star.uno.XInterface;
import com.sun.star.corba.TCKind;

import com.sun.star.lib.iiopbridge.Marshal;
import com.sun.star.lib.iiopbridge.Unmarshal;


public class Test
{
    public static void main( String[] args )
    {
        try
        {
        // structure marshaling
        StructTest aS = new StructTest( 2 );
        
        Marshal aM = new Marshal( false, null );
        aM.write_struct( aS );
        Unmarshal aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        StructTest aS2 = (StructTest)aUM.read_struct( StructTest.class );
        
        if( !aS.equals( aS2 ) )
            System.err.println( "error: Struct marshal" );
            
        // exception marshaling
        ExceptionTest aE = new ExceptionTest( "Exception" );
        aE.nByte = 1;
        aE.nShort = 300;
        aE.nInt = 100000;
        aE.nLong = 10000000;
        aE.nFloat = (float)0.111;
        aE.nDouble = 111.111;
        aE.cChar = 'a';
        aE.bBoolean = true;
        aE.aString = "hallo";
        aE.aAscii = new Ascii( 'a' );
        aE.aAsciiString = new AsciiString( "asciistring" );
        
        aM = new Marshal( false, null );
        aM.write_exception( aE );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        ExceptionTest aE2 = (ExceptionTest)aUM.read_exception( ExceptionTest.class );
        
        if( !aE2.getMessage().equals( "Exception")
          || aE2.nByte != 1
          || aE2.nByte != 1
          || aE2.nShort != 300
          || aE2.nInt != 100000
          || aE2.nLong != 10000000
          || aE2.nFloat != (float)0.111
          || aE2.nDouble != 111.111
          || aE2.cChar != 'a'
          || aE2.bBoolean != true
          || !aE2.aString.equals( "hallo" )
          || aE2.aAscii.ascii != 'a'
          || !aE2.aAsciiString.asciistring.equals( "asciistring" ) )
            System.err.println( "error: Exception marshal" );

        // byte sequence marshaling
        byte szB[] = { 3, 5 };
        aM = new Marshal( false, null );
        aM.write_sequence( szB );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        byte szB2 [] = (byte [])aUM.read_sequence( szB.getClass() );
        
        if( szB2[0] != 3
          || szB2[1] != 5 )
            System.err.println( "error: byte sequence marshal" );
            
        // enum sequence marshaling
        TCKind szE[] = { TCKind.tk_ulonglong, TCKind.tk_longlong };
        aM = new Marshal( false, null );
        aM.write_sequence( szE );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        TCKind szE2 [] = (TCKind [])aUM.read_sequence( szE.getClass() );
        
        if( szE2[0] != TCKind.tk_ulonglong
          || szE2[1] != TCKind.tk_longlong )
            System.err.println( "error: byte sequence marshal" );
            
        // struct sequence marshaling
        StructTest szST[] = { aS };
        aM = new Marshal( false, null );
        aM.write_sequence( szST );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        szST = (StructTest [])aUM.read_sequence( szST.getClass() );
        
        if( szST[0].nByte != 1
          || szST[0].nByte != 1
          || szST[0].nShort != 300
          || szST[0].nInt != 100000
          || szST[0].nLong != 10000000
          || szST[0].nFloat != (float)0.111
          || szST[0].nDouble != 111.111
          || szST[0].cChar != 'a'
          || szST[0].bBoolean != true
          || !szST[0].aString.equals( "hallo" )
          || szST[0].aAscii.ascii != 'a'
          || !szST[0].aAsciiString.asciistring.equals( "asciistring" )
          || aS.eEnum != TCKind.tk_ulonglong )
            System.err.println( "error: Struct marshal" );
            
        {
        // any byte marshaling
        Byte any = new Byte( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Byte)aUM.read_any();
        if( any.byteValue() != 1 )
            System.err.println( "error: byte any marshal" );
        }

        {
        // any short marshaling
        Short any = new Short( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Short)aUM.read_any();
        if( any.shortValue() != 1 )
            System.err.println( "error: short any marshal" );
        }

        {
        // any int marshaling
        Integer any = new Integer( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Integer)aUM.read_any();
        if( any.intValue() != 1 )
            System.err.println( "error: int any marshal" );
        }

        {
        // any long marshaling
        Long any = new Long( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Long)aUM.read_any();
        if( any.longValue() != 1 )
            System.err.println( "error: long any marshal" );
        }

        {
        // any float marshaling
        Float any = new Float( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Float)aUM.read_any();
        if( any.intValue() != 1 )
            System.err.println( "error: float any marshal" );
        }

        {
        // any double marshaling
        Double any = new Double( (byte)1 );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Double)aUM.read_any();
        if( any.intValue() != 1 )
            System.err.println( "error: double any marshal" );
        }

        {
        // any boolean marshaling
        Boolean any = new Boolean( true );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Boolean)aUM.read_any();
        if( !any.booleanValue() )
            System.err.println( "error: bool any marshal" );
        }

        {
        // any char marshaling
        Character any = new Character( 'a' );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (Character)aUM.read_any();
        if( 'a' != any.charValue() )
            System.err.println( "error: char any marshal" );
        }

        {
        // any char marshaling
        String any = new String( "a" );
        aM = new Marshal( false, null );
        aM.write_any( any );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (String)aUM.read_any();
        if( !any.equals( "a") )
            System.err.println( "error: char any marshal" );
        }

        {
        // any structure marshaling
        StructTest any = new StructTest( 2 );
        
        aM = new Marshal( false, null );
        aM.write_any( aS );
        aUM = new Unmarshal( aM.getByteArray(), aM.getSize(), false, null );
        any = (StructTest)aUM.read_any();
        if( !any.equals( new StructTest( 2 ) ) )
            System.err.println( "error: struct any marshal" );
        }
        
        }
        catch( Exception e )
        {
            System.err.println( "error: exception occured" );
            e.printStackTrace();
        }
    }
}

