/*************************************************************************
 *
 *  $RCSfile: TestServer.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.rmserver;


import java.io.IOException;

import com.sun.star.bridge.XConnectionBroker;
import com.sun.star.bridge.XConnectCallback;
import com.sun.star.bridge.XConnectionServerSide;

import com.sun.star.lib.uno.environments.remote.ThreadPool;

import com.sun.star.uno.UnoRuntime;


public class TestServer {
	static class MyConnectCallback implements XConnectCallback {
		public void attemptConnect(XConnectionServerSide connectionServerSide) 
			throws com.sun.star.lang.SecurityException, 
			com.sun.star.uno.RuntimeException
		{
			connectionServerSide.provideRemoteObject(new TestFactory_Impl());
		}
	}

	static String neededServices[] = new String[] {
		"com.sun.star.comp.servicemanager.ServiceManager",
		"com.sun.star.comp.loader.JavaLoader",
		"com.sun.star.comp.connections.Connector",
  		"com.sun.star.comp.connections.Acceptor",
		"com.sun.star.comp.rmserver.ConnectionBroker",
		"com.sun.star.lib.uno.bridges.java_remote.java_remote_bridge"
	};

	static public void main(String args[]) throws IOException, com.sun.star.uno.Exception {
		com.sun.star.comp.servicemanager.ServiceManager smgr = new com.sun.star.comp.servicemanager.ServiceManager();
		smgr.addFactories(neededServices, null);

		XConnectionBroker connectionBroker = (XConnectionBroker)smgr.createInstance("com.sun.star.bridge.ConnectionBroker");

		if(connectionBroker.acceptConnections("socket:5001", new MyConnectCallback())) {
			System.in.read();

			connectionBroker.stopAccepting();
		}

		ThreadPool.reset();
		UnoRuntime.reset();
	}
}

