/*************************************************************************
 *
 *  $RCSfile: UcbDemo.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jbu $ $Date: 2001/02/26 14:34:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


package com.sun.star.demo;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;

import com.sun.star.comp.servicemanager.ServiceManager;

import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;

import com.sun.star.lang.XMultiServiceFactory;

import com.sun.star.ucb.XContent;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.XContentIdentifierFactory;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.ucb.XContentProvider;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XCommandEnvironment;
import com.sun.star.ucb.XProgressHandler;

import com.sun.star.sdbc.XRow;

import com.sun.star.beans.Property;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.Type;
import com.sun.star.bridge.XUnoUrlResolver;

class MyCommandEnvironment implements XCommandEnvironment
{
	public com.sun.star.task.XInteractionHandler getInteractionHandler(  )
		throws com.sun.star.uno.RuntimeException
		{
			return null;
		}
    public XProgressHandler getProgressHandler(  )
		throws com.sun.star.uno.RuntimeException
		{
			return null;
		}
};

class MyThread extends Thread
{
	private Object m_initialObject;
	private int m_nLoops;
	private String m_sUcbURL;

	MyThread( Object initialObject , int nLoops , String sUcbURL )
	{
		m_initialObject = initialObject;
		m_nLoops = nLoops;
		m_sUcbURL = sUcbURL;
	}
	public void run()
	{
		try {

			XMultiServiceFactory smgr =
				(XMultiServiceFactory)UnoRuntime.queryInterface(
					XMultiServiceFactory.class, m_initialObject);

			smgr =  (XMultiServiceFactory )
				UnoRuntime.queryInterface( XMultiServiceFactory.class,
				smgr.createInstance("com.sun.star.lang.ServiceManager") );

			Object ucb = smgr.createInstance("com.sun.star.ucb.RemoteContentBroker");

			XContentIdentifierFactory xFactory = (XContentIdentifierFactory)
					UnoRuntime.queryInterface( XContentIdentifierFactory.class,ucb);

			//"//  vnd.sun.star.wfs:///user/work"
  			XContentIdentifier xIdent =
  				xFactory.createContentIdentifier( m_sUcbURL );

  			XContentProvider xProv = (XContentProvider)
  				UnoRuntime.queryInterface( XContentProvider.class, ucb );

  			XContent xContent = xProv.queryContent( xIdent );
  			XCommandProcessor xProc = (XCommandProcessor)
  				UnoRuntime.queryInterface( XCommandProcessor.class , xContent );

  			int n = xProc.createCommandIdentifier();

  			MyCommandEnvironment env = new MyCommandEnvironment();
  			for( int i = 0 ; i < m_nLoops ; i ++ )
  			{
  				Property [] aProps = new Property[]{ new Property(
  					"IsFolder",0,new Type(), (short)0)};
				
  				Command command = new Command( "getPropertyValues" , 0 , aProps);
				
  				XRow row = (XRow) xProc.execute( command, n, env );
				
  				command = new Command( "getPropertyValues" , 0 ,
  						  new Property[]{ new Property("Title",0,new Type(), (short)0)});

  				row = (XRow) xProc.execute( command, n , env );
  				if( i % 100 == 0 )
  				{
  					System.out.println ( i );
  				}
  			}
			System.out.println( "Thread finished" );
  		}
  		catch ( Exception except)
  		{
  			System.out.println( except );
  			except.printStackTrace();
  		}
  	}
  };

  public class UcbDemo {
  	static String neededServices[] = new String[] {
  		"com.sun.star.comp.servicemanager.ServiceManager",
  		"com.sun.star.comp.loader.JavaLoader",
  		"com.sun.star.comp.connections.Connector",
  		"com.sun.star.comp.bridgefactory.BridgeFactory",
  		"com.sun.star.comp.urlresolver.UrlResolver",
  		"com.sun.star.comp.portal_connect.Connector"
  	};

	
  	static public void main(String args[]) throws Exception {
  		if(args.length != 2)	{
  			System.err.println("usage : UcbDemo uno:connection;protocol;objectName UCB-URL-to-ask-for-property-values");
  			System.exit(-1);
  		}

  		XMultiServiceFactory xMSF = null;
  		// initial serviceManager
  		ServiceManager serviceManager = new ServiceManager();
  		serviceManager.addFactories(neededServices);

  		String dcp1 = args[0];

  		XUnoUrlResolver resolver = (XUnoUrlResolver) UnoRuntime.queryInterface(
  			XUnoUrlResolver.class,
  			serviceManager.createInstance("com.sun.star.bridge.UnoUrlResolver" ) );

  		Object rsm = resolver.resolve( dcp1 );
  		System.out.println( "Connected to the UCB" + rsm );
		// There is no specific reason why the work is delegated to another thread,
		// it is just to ease the use of multiple connections  ( to do load tests ).
		(new MyThread( rsm ,500 , args[1] )).start();
	}
}
