/*************************************************************************
 *
 *  $RCSfile: NativeThreadPoolFactory.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kr $ $Date: 2001/05/17 12:44:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.lib.uno.environments.remote;


/**
 * This class wrapps the native uno thread pool.
 * <p>
 * @version 	$Revision: 1.1 $ $ $Date: 2001/05/17 12:44:32 $
 * @author 	    Joeg Budischewski
 * @author 	    Kay Ramme
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPoolFactory
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPool
 */
class NativeThreadPool implements IThreadPool {
	/**
	 * When set to true, enables various debugging output.
	 */
	private static final boolean DEBUG = false;

	static {
		try {
			System.loadLibrary("java_uno");
		}
		catch(UnsatisfiedLinkError unsatisfiedLinkError) {
			System.err.println("NativeThreadPool.<sinit> - unexpected: " + unsatisfiedLinkError);

			throw unsatisfiedLinkError;
		}
	}
		
	static native byte []ngetThreadId();
		
	static native long ncreate();
	static native void nattach(long handle);
	static native void ndetach(long handle);
		
	static native Object nenter(long handle, boolean disposed[]);
	static native void  nputJob(long handle, byte threadId[], Job job, boolean oneWay);
		
	static native void ndispose(long handle);
	static native void ndestroy(long handle);
		

	long      _handle;
	Throwable _throwable;

	NativeThreadPool() {
		_handle = ncreate();
	}
		
	public void attach() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".attach:");
			
		nattach(_handle);
	}
		
	public void detach() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".detach:");

		ndetach(_handle);
	}
		
	public Object enter() throws Throwable {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".enter:");
			
		boolean disposed[] = new boolean[1];

		Object result = nenter(_handle, disposed);

		if(disposed[0])
			throw _throwable;

		return result;
	}
		
	public void putJob(Job job) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".putJob:");
			
		nputJob(_handle, job.getThreadId().getBytes(), job, !job.isSynchron());
	}
		
	public void dispose(Throwable throwable) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".dispose:");

		_throwable = throwable;

		ndispose(_handle);
	}
		
	public void destroy() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".destroy:");
			
		ndetach(_handle);
	}
}

/**
 * This class wrapps the native uno thread pool.
 * <p>
 * @version 	$Revision: 1.1 $ $ $Date: 2001/05/17 12:44:32 $
 * @author 	    Kay Ramme
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPoolFactory
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPool
 * @since       UDK3.0
 */
public class NativeThreadPoolFactory implements IThreadPoolFactory {
	public ThreadId getThreadId() {
		return new ThreadId(NativeThreadPool.ngetThreadId());
	}
		
	public IThreadPool createThreadPool() {
		return new NativeThreadPool();
	}
}


