/*************************************************************************
 *
 *  $RCSfile: JarFilteredDirectory.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.test;

import com.sun.star.tool.starjar.regex.MalformedPatternException;
import com.sun.star.tool.starjar.regex.Pattern;
import com.sun.star.tool.starjar.regex.PatternCompiler;
import com.sun.star.tool.starjar.regex.PatternMatcher;
import com.sun.star.tool.starjar.regex.Perl5Compiler;
import com.sun.star.tool.starjar.regex.Perl5Matcher;

import java.io.IOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;

import com.sun.star.tool.starjar.StarJar;
import com.sun.star.tool.starjar.FileListElement;
import com.sun.star.tool.starjar.FilterElement;
import com.sun.star.tool.starjar.regex.MalformedPatternException;

public class JarFilteredDirectory {
    public static void main(String[] args) {
        StarJar starJar = new StarJar();
        Vector filter = new Vector();
        Vector fileListVector = new Vector();

        try {
            starJar.parseDirectoryTree(fileListVector,new File(System.getProperty("user.home")));
        } catch (Exception e) {}
        
        Enumeration fileList = fileListVector.elements();

        try {
            FileReader fileReader = new FileReader(args.length>0?args[0]:"TestFilter.flt");
            starJar.importFilter(filter, fileReader);
        } catch (FileNotFoundException e) {
            System.out.println("Fehler beim Einlesen der Filterdatei :\n" + e);
        }
        catch (MalformedPatternException e) {
            System.out.println("Fehler beim Parsen der Filterdatei :\n" + e);
        }

        PatternCompiler compiler = new Perl5Compiler();
        PatternMatcher matcher = new Perl5Matcher();
        
        while (fileList.hasMoreElements()) {
            FileListElement file = (FileListElement)fileList.nextElement();
            Enumeration filterEnum = filter.elements();
            Pattern pathPattern = null;
            Pattern filenamePattern = null;
            
            while (filterEnum.hasMoreElements()) {
                FilterElement filterElement = (FilterElement)filterEnum.nextElement();
                try {
                    pathPattern = compiler.compile(filterElement.getPathPattern());
                    filenamePattern = compiler.compile(filterElement.getFilenamePattern());
                } catch (MalformedPatternException e) {
                    System.out.println("Fehler im Pattern\n" + e);
                }
                if (matcher.matches(file.getPath(),pathPattern) && matcher.matches(file.getFilename(),filenamePattern))
                    file.setInclude(filterElement.isInclude());
            }
        }
        starJar.zipFiles(fileListVector,"JarDirectoryTest.jar", "");
    }
}

