/*************************************************************************
 *
 *  $RCSfile: PatternMatcherInput.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

public final class PatternMatcherInput {

    String _fld0149;
    char _fld0148[];
    char _fld0147[];
    char _fld0146[];
    int _fld0145;
    int _fld0144;
    int _fld0143;
    int _fld0142;
    int _fld0141;

    public PatternMatcherInput(String s, int i, int j) {
        _fld0142 = -1;
        _fld0141 = -1;
        setInput(s, i, j);
    }

    public PatternMatcherInput(String s) {
        this(s, 0, s.length());
    }

    public PatternMatcherInput(char ac[], int i, int j) {
        _fld0142 = -1;
        _fld0141 = -1;
        setInput(ac, i, j);
    }

    public PatternMatcherInput(char ac[]) {
        this(ac, 0, ac.length);
    }

    public int length() {
        return _fld0144 - _fld0145;
    }

    public void setInput(String s, int i, int j) {
        _fld0149 = s;
        _fld0148 = null;
        _fld0146 = null;
        _fld0147 = s.toCharArray();
        _fld0143 = i;
        _fld0142 = -1;
        _fld0141 = -1;
        _fld0145 = i;
        int k = _fld0145 + j;
        _fld0144 = k;
    }

    public void setInput(String s) {
        setInput(s, 0, s.length());
    }

    public void setInput(char ac[], int i, int j) {
        _fld0149 = null;
        _fld0146 = null;
        _fld0147 = _fld0148 = ac;
        _fld0143 = i;
        _fld0142 = -1;
        _fld0141 = -1;
        _fld0145 = i;
        int k = _fld0145 + j;
        _fld0144 = k;
    }

    public void setInput(char ac[]) {
        setInput(ac, 0, ac.length);
    }

    public char charAt(int i) {
        return _fld0147[_fld0145 + i];
    }

    public String substring(int i, int j) {
        return new String(_fld0147, _fld0145 + i, j - i);
    }

    public String substring(int i) {
        i += _fld0145;
        return new String(_fld0147, i, _fld0144 - i);
    }

    public Object getInput() {
        if(_fld0149 == null)
            return _fld0148;
        else
            return _fld0149;
    }

    public char[] getBuffer() {
        return _fld0147;
    }

    public boolean endOfInput() {
        return _fld0143 >= _fld0144;
    }

    public int getBeginOffset() {
        return _fld0145;
    }

    public int getEndOffset() {
        return _fld0144;
    }

    public int getCurrentOffset() {
        return _fld0143;
    }

    public void setBeginOffset(int i) {
        _fld0145 = i;
    }

    public void setEndOffset(int i) {
        _fld0144 = i;
    }

    public void setCurrentOffset(int i) {
        _fld0143 = i;
        _fld0142 = -1;
        _fld0141 = -1;
    }

    public String toString() {
        return new String(_fld0147, _fld0145, _fld0144 - _fld0145);
    }

    public String preMatch() {
        return new String(_fld0147, _fld0145, _fld0142 - _fld0145);
    }

    public String postMatch() {
        return new String(_fld0147, _fld0141, _fld0144 - _fld0141);
    }

    public String match() {
        return new String(_fld0147, _fld0142, _fld0141 - _fld0142);
    }

    public void setMatchOffsets(int i, int j) {
        _fld0142 = i;
        _fld0141 = j;
    }

    public int getMatchBeginOffset() {
        return _fld0142;
    }

    public int getMatchEndOffset() {
        return _fld0141;
    }
}

