/*************************************************************************
 *
 *  $RCSfile: FileListElement.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileListElement
{
    private String 			m_path;
    private String 			m_realpath;
    private String 			m_filename;
    private String 			m_jarFilename;
    private boolean 		m_include;
    private boolean 		m_inJarFile;
    private long 			m_size;
	private ZipFile 		m_zipFile;
	private ZipEntry 		m_zipFileEntry;

    public FileListElement(String path, String filename, long size)
    {
        this(path, filename, size, true);
    }

    public FileListElement(String path, String filename, long size, boolean include)
    {
        this(path, filename, size, include, null, null, null, false);
    }

    public FileListElement(String path, String filename, long size, boolean include, String jarFilename, ZipFile zipFile, ZipEntry zipFileEntry, boolean inJarFile)
    {
    	this(null,path,filename,size,include,jarFilename,zipFile,zipFileEntry,inJarFile);
	}
	
    public FileListElement(String classPrefix, String path, String filename, long size, boolean include, String jarFilename, ZipFile zipFile, ZipEntry zipFileEntry, boolean inJarFile)
    {
    	if ( classPrefix != null ) {
	        this.m_realpath = path;
	        int i=path.indexOf(classPrefix);
	        if ( i == 0 ) {
		        this.m_path=this.m_realpath.substring(classPrefix.length());
		        if ( this.m_path.startsWith("\\") || this.m_path.startsWith("/") ) 
		        	this.m_path=this.m_path.substring(1);
		    } else {
		        this.m_path = path;
		    }
	    } else {
	        this.m_realpath = null;
	        this.m_path = path;
	        if ( this.m_path.startsWith("\\") || this.m_path.startsWith("/") ) {
	        		this.m_realpath = this.m_path;
		        	this.m_path=this.m_path.substring(1);
			}
	    }
        this.m_filename = filename;
        this.m_size = size;
        this.m_jarFilename = jarFilename;        
        this.m_include = include;
        this.m_inJarFile = inJarFile;
		this.m_zipFile = zipFile;
		this.m_zipFileEntry = zipFileEntry;
    }
    
    public void setPath(String path)
    {
        this.m_path = path;
    }

    public String getPath()
    {
        return m_path;
    }
  
    public String getRealPath()
    {
        return ( (this.m_realpath != null) ? this.m_realpath : this.m_path );
    }

    public void setFilename(String filename)
    {
        this.m_filename = filename;
    }

    public String getFilename()
    {
        return m_filename;
    }

    public void setJarFilename(String jarFilename)
    {
        this.m_jarFilename = jarFilename;
    }

    public String getJarFilename()
    {
        return m_jarFilename;
    }

    public ZipFile getZipFile()
    {
        return m_zipFile;
    }

    public ZipEntry getZipFileEntry()
    {
        return m_zipFileEntry;
    }

    public void setInclude(boolean include)
    {
        this.m_include = include;
    }

    public boolean isInclude()
    {
        return m_include;
    }

    public void setInJarFile(boolean inJarFile)
    {
        this.m_inJarFile = inJarFile;
    }

    public boolean isInJarFile()
    {
        return m_inJarFile;
    }

    public String toString()
    {
        return new String((m_inJarFile?("JAR : " + m_jarFilename + " "):("")) + m_path + " - " + m_filename);
    }

    public void setSize(long size)
    {
        this.m_size = size;
    }
    
    public long getSize()
    {
        return m_size;
    }
    
    public boolean equals(Object obj)
    {
        if (!(obj instanceof FileListElement))
            return false;
        return ((((FileListElement)obj).getPath().equals(this.getPath())) 
                && (((FileListElement)obj).getFilename().equals(this.getFilename())));            
    }
}
