/*************************************************************************
 *
 *  $RCSfile: module.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _INET_MODULE_CXX "$Revision:   1.0"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_INTERLCK_H_
#include <osl/interlck.h>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif

#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif
#ifndef _INET_IMAPCLNT_HXX
#include <imapclnt.hxx>
#endif
#ifndef _INETFTP_HXX
#include <inetftp.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

/*========================================================================
 *
 * INetModule_Impl internals.
 *
 *======================================================================*/
/*
 * INetModuleInitialize.
 */
extern "C" void* SAL_CALL INetModuleInitialize (void)
{
	return NAMESPACE_INET(INetModule_Impl)::getOrCreate();
}

/*
 * Global creation functions.
 */
extern "C" 
{
	INetIMAPClient*                  SAL_CALL NewINetImapMailer (void);
	NAMESPACE_INET(INetHTTPWrapper)* SAL_CALL NewINetHTTPWrapper (void);
	NAMESPACE_INET(INetLDAPWrapper)* SAL_CALL NewINetLDAPWrapper (void);
	NAMESPACE_INET(INetCoreMailer)*  SAL_CALL NewINetCoreMailer (void);
}

/*
 * Global cleanup functions.
 */
extern "C" void SAL_CALL INetClientCleanup_Impl (void);

/*
 * __getGlobalMutex_Impl (protect the single instance creation).
 */
static NAMESPACE_VOS(IMutex)& __getGlobalMutex_Impl (void)
{
	static NAMESPACE_VOS(IMutex) *pMutex = NULL;
	if (!pMutex)
	{
		NAMESPACE_VOS(OGuard) aGuard (NAMESPACE_VOS(OMutex)::getGlobalMutex());
		if (!pMutex)
		{
			static NAMESPACE_VOS(OMutex) aGlobalMutex;
			pMutex = &aGlobalMutex;
		}
	}
	return *pMutex;
}

/*========================================================================
 *
 * INetModule_Impl implementation.
 *
 *======================================================================*/
/*
 * The single instance.
 */
NAMESPACE_INET(INetModule_Impl)*
NAMESPACE_INET(INetModule_Impl)::m_pThis = NULL;

/*
 * INetModule_Impl.
 */
INetModule_Impl::INetModule_Impl (void)
	: m_nRefCount (0)
{
	// Assign the single instance.
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = this;

	// Acquire the INetConfig instance.
	INetConfig::getOrCreate (m_xConfig);
}

/*
 * ~INetModule_Impl.
 */
INetModule_Impl::~INetModule_Impl (void)
{
	// Cleanup the single instance.
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = NULL;

	// Cleanup clients.
	::INetClientCleanup_Impl();

	// Release the INetConfig instance.
	m_xConfig.unbind();
}

/*
 * getOrCreate.
 */
INetModule_Impl* INetModule_Impl::getOrCreate (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	if (!m_pThis)
		new INetModule_Impl();
	return m_pThis;
}

/*
 * acquire.
 */
void INetModule_Impl::acquire (void)
{
	osl_incrementInterlockedCount (&m_nRefCount);
}

/*
 * release.
 */
void INetModule_Impl::release (void)
{
	if (osl_decrementInterlockedCount (&m_nRefCount) <= 0)
		delete this;
}

/*
 * getINetConfig.
 */
sal_Bool INetModule_Impl::getINetConfig (
	NAMESPACE_VOS(ORef)<INetConfig> &rxConfig)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rxConfig = m_xConfig;
	return (rxConfig.isValid());
}

/*
 * getINetCoreSSLConfig.
 */
sal_Bool INetModule_Impl::getINetCoreSSLConfig (INetCoreSSLConfig *&rpConfig)
{
	rpConfig = NULL;
	return sal_False;
}

/*
 * newINetIMAPClient.
 */
sal_Bool INetModule_Impl::newINetIMAPClient (INetIMAPClientRef &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rxClient = ::NewINetImapMailer();
	return (rxClient.Is());
}

/*
 * newINetFTPConnection.
 */
sal_Bool INetModule_Impl::newINetFTPConnection (
	NAMESPACE_VOS(ORef)<INetFTPConnection> &rxConnection)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	return INetFTPConnection::createInstance (rxConnection);
}

/*
 * newINetHTTPWrapper.
 */
sal_Bool INetModule_Impl::newINetHTTPWrapper (INetHTTPWrapper *&rpWrapper)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpWrapper = ::NewINetHTTPWrapper();
	return (!!rpWrapper);
}

/*
 * newINetLDAPWrapper.
 */
sal_Bool INetModule_Impl::newINetLDAPWrapper (INetLDAPWrapper *&rpWrapper)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpWrapper = ::NewINetLDAPWrapper();
	return (!!rpWrapper);
}

/*
 * newINetCoreMailer.
 */
sal_Bool INetModule_Impl::newINetCoreMailer (INetCoreMailer *&rpMailer)
{
	NAMESPACE_VOS(OGuard) aGuard (m_aMutex);
	rpMailer = ::NewINetCoreMailer();
	return (!!rpMailer);
}

/*
 * newINetSession.
 */
sal_Bool INetModule_Impl::newINetSession (INetSession *&rpSession)
{
	rpSession = NULL;
	return sal_False;
}

