/*************************************************************************
 *
 *  $RCSfile: recvclnt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:06:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_RECVCLNT_CXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _INETCORESTRM_HXX
#include <inetstrm.hxx>
#endif
#ifndef _INET_RECVCLNT_HXX
#include <recvclnt.hxx>
#endif

using namespace rtl;

using namespace inet;
using namespace inet::mail;
using namespace inet::pop3;

/*========================================================================
 *
 * RecvClient_Impl internals.
 *
 *======================================================================*/
namespace inet
{
namespace pop3
{

/*========================================================================
 *
 * RecvContext_Impl.
 *
 *======================================================================*/
class RecvContext_Impl : public NAMESPACE_VOS(OReference)
{
public:
	/** Representation.
	 */
	typedef INetCoreMailerCallback callback_type;

	callback_type *m_pfnCB;
	void          *m_pDataCB;

	/** Construction.
	 */
	RecvContext_Impl (callback_type *pfnCB, void *pDataCB)
		: m_pfnCB (pfnCB), m_pDataCB (pDataCB)
	{}

protected:
	/** Destruction.
	 */
	virtual ~RecvContext_Impl (void);

private:
	/** Not implemented.
	 */
	RecvContext_Impl (const RecvContext_Impl&);
	RecvContext_Impl& operator= (const RecvContext_Impl&);
};

/*
 * ~RecvContext_Impl.
 */
RecvContext_Impl::~RecvContext_Impl (void)
{
}

/*========================================================================
 *
 * LoginContext_Impl.
 *
 *======================================================================*/
class LoginContext_Impl : public RecvContext_Impl
{
	/** Representation.
	 */
	OUString m_aPassword;

public:
	/** Construction.
	 */
	LoginContext_Impl (callback_type *pfnCB, void *pDataCB)
		: RecvContext_Impl (pfnCB, pDataCB)
	{}

	/** Initialization.
	 */
	sal_Bool initialize (const OUString &rPassword)
	{
		m_aPassword = rPassword;
		return (m_aPassword.getLength() > 0);
	}

	/** Operation.
	 */
	OUString takePassword (void)
	{
		OUString aPassword (m_aPassword);
		m_aPassword = OUString();
		return aPassword;
	}
};

/*========================================================================
 *
 * MessageContext_Impl.
 *
 *======================================================================*/
class MessageContext_Impl : public RecvContext_Impl
{
	/** Representation.
	 */
	INetCoreMIMEMessageStream m_aDecoder;

public:
	MessageContext_Impl (callback_type *pfnCB, void *pDataCB)
		: RecvContext_Impl (pfnCB, pDataCB)
	{}

	/** Initialization.
	 */
	sal_Bool initialize (INetCoreMIMEMessage &rMessage)
	{
		m_aDecoder.SetTargetMessage (&rMessage);
		return sal_True;
	}

	/** Operation.
	 */
	INetCoreMessageOStream& operator() (void) { return m_aDecoder; }
};

} // pop3
} // inet

/*========================================================================
 *
 * RecvClient_Impl implementation.
 *
 *======================================================================*/
/*
 * RecvClient_Impl.
 */
RecvClient_Impl::RecvClient_Impl (ClientManager &rManager)
	: m_rManager (rManager),
	  m_eState   (STATE_NONE)
{
}

/*
 * ~RecvClient_Impl.
 */
RecvClient_Impl::~RecvClient_Impl (void)
{
}

/*
 * getMutex_Impl.
 */
inline NAMESPACE_VOS(IMutex)& RecvClient_Impl::getMutex_Impl (void) const
{
	return ((SAL_CONST_CAST(RecvClient_Impl*, this))->m_aMutex);
}

/*
 * setState_Impl.
 */
inline void RecvClient_Impl::setState_Impl (State eState)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	m_eState = eState;
}

/*
 * changeState_Impl.
 */
inline sal_Bool RecvClient_Impl::changeState_Impl (State ePrev, State eNext)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (m_eState == ePrev)
	{
		m_eState = eNext;
		return sal_True;
	}
	return sal_False;
}

/*
 * createConnection_Impl.
 */
inline sal_Bool RecvClient_Impl::createConnection_Impl (
	NAMESPACE_VOS(ORef)<connection_type> &rxConnection)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (!m_xConnection.isValid())
	{
		m_xConnection = new connection_type();
		m_xConnection->SetRetrieveCallback (onConnectionEvent, this);
		m_xConnection->SetTerminateCallback (onConnectionEvent, this);
	}
	rxConnection = m_xConnection;
	return (rxConnection.isValid());
}

/*
 * getConnection_Impl.
 */
inline sal_Bool RecvClient_Impl::getConnection_Impl (
	NAMESPACE_VOS(ORef)<connection_type> &rxConnection) const
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	rxConnection = m_xConnection;
	return (rxConnection.isValid());
}

/*
 * onConnectionEvent.
 */
sal_Bool RecvClient_Impl::onConnectionEvent (
	connection_type *pConnection,
	sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData)
{
	RecvClient_Impl *pThis = SAL_REINTERPRET_CAST(RecvClient_Impl*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(ORef)<RecvClient_Impl> xThis (pThis);
		xThis->handleConnectionEvent (pConnection, nReplyCode, pReplyText);
	}
	return sal_True;
}

/*
 * handleConnectionEvent.
 */
void RecvClient_Impl::handleConnectionEvent (
	connection_type *pConnection,
	sal_Int32 nReplyCode, const sal_Char *pReplyText)
{
	if (changeState_Impl (STATE_REPLY_N, STATE_EVENT))
	{
		NAMESPACE_VOS(ORef)<RecvContext_Impl> xContext (m_xContext);
		if (xContext.isValid())
		{
			if (nReplyCode == INETCOREPOP3_REPLY_TRANSFER_WAIT)
			{
				// Wait for next event.
				changeState_Impl (STATE_EVENT, STATE_REPLY_N);
			}
			else
			{
				// Finished.
				setState_Impl (STATE_NONE);
			}

			// Notify caller.
			if (xContext->m_pfnCB) (xContext->m_pfnCB) (
				m_rManager, nReplyCode, pReplyText, xContext->m_pDataCB);
		}
	}
	else if (changeState_Impl (STATE_REPLY_1, STATE_EVENT))
	{
		NAMESPACE_VOS(ORef)<RecvContext_Impl> xContext (m_xContext);
		if (xContext.isValid())
		{
			// Finished.
			setState_Impl (STATE_NONE);

			// Notify caller.
			if (xContext->m_pfnCB) (xContext->m_pfnCB) (
				m_rManager, nReplyCode, pReplyText, xContext->m_pDataCB);
		}
	}
	else if (changeState_Impl (STATE_USER, STATE_EVENT))
	{
		NAMESPACE_VOS(ORef)<LoginContext_Impl> xContext (
			SAL_REINTERPRET_CAST (LoginContext_Impl*, &*m_xContext));
		if (xContext.isValid())
		{
			if (nReplyCode == INETCOREPOP3_REPLY_OK)
			{
				// USER command ok, send PASS command.
				OUString aPassword (xContext->takePassword());
				if (!loginPass_Impl (aPassword))
				{
					// PASS command failure.
					nReplyCode = INETCOREPOP3_REPLY_ERROR;
					setState_Impl (STATE_NONE);

					// Notify caller.
					if (xContext->m_pfnCB) (xContext->m_pfnCB) (
						m_rManager, nReplyCode, NULL, xContext->m_pDataCB);
				}
			}
			else
			{
				// USER command failure.
				setState_Impl (STATE_NONE);

				// Notify caller.
				if (xContext->m_pfnCB) (xContext->m_pfnCB) (
					m_rManager, nReplyCode, pReplyText, xContext->m_pDataCB);
			}
		}
	}
	else if (changeState_Impl (STATE_OPEN, STATE_EVENT))
	{
		NAMESPACE_VOS(ORef)<RecvContext_Impl> xContext (m_xContext);
		if (xContext.isValid())
		{
			if ((nReplyCode == INETCOREPOP3_REPLY_RESOLVER_WAIT) ||
				(nReplyCode == INETCOREPOP3_REPLY_CONNECT_WAIT )    )
			{
				// Wait for next event.
				changeState_Impl (STATE_EVENT, STATE_OPEN);
			}
			else
			{
				// Finished.
				setState_Impl (STATE_NONE);

				// Notify caller.
				if (xContext->m_pfnCB) (xContext->m_pfnCB) (
					m_rManager, nReplyCode, pReplyText, xContext->m_pDataCB);
			}
		}
	}
	else
	{
		VOS_ASSERT(m_eState == STATE_NONE);
		if (nReplyCode == INETCOREPOP3_REPLY_NETWORK_ERROR)
		{
			// Notify manager.
			m_rManager.terminated (this);
		}
	}
}

/*
 * openConnection.
 */
sal_Bool RecvClient_Impl::openConnection (
	const OUString &rHost, sal_uInt16 nPort,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_OPEN))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!createConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->Open (rHost, nPort, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_OPEN, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * isOpen.
 */
sal_Bool RecvClient_Impl::isOpen (void) const
{
	NAMESPACE_VOS(ORef)<connection_type> xConnection;
	if (getConnection_Impl (xConnection))
		return xConnection->IsOpen();
	else
		return sal_False;
}

/*
 * closeConnection.
 */
sal_Bool RecvClient_Impl::closeConnection (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_CLOSE))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->Close (onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_CLOSE, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * abortConnection.
 */
void RecvClient_Impl::abortConnection (void)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (m_xConnection.isValid())
	{
		m_xConnection->Destroy();
		m_xConnection.unbind();
	}
	if (m_xContext.isValid())
	{
		m_xContext->m_pfnCB = 0; // setCallback (NULL, NULL);
		m_xContext.unbind();
	}
	m_eState = STATE_NONE;
}

/*
 * login.
 */
sal_Bool RecvClient_Impl::login (
	const OUString &rUsername, const OUString &rPassword,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_EVENT))
	{
		NAMESPACE_VOS(ORef)<LoginContext_Impl> xContext (
			new LoginContext_Impl (pfnCallback, pData));
		if (!xContext->initialize (rPassword))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext.bind (&*xContext);
		if (!loginUser_Impl (rUsername))
		{
			m_xContext.unbind();
			setState_Impl (STATE_NONE);
			return sal_False;
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * isLoggedIn.
 */
sal_Bool RecvClient_Impl::isLoggedIn (void) const
{
	NAMESPACE_VOS(ORef)<connection_type> xConnection;
	if (getConnection_Impl (xConnection))
		return xConnection->IsLoggedIn();
	else
		return sal_False;
}

/*
 * getMailListEntry.
 */
sal_Bool RecvClient_Impl::getMailListEntry (
	INetCoreMailInfoListEntry &rEntry,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_ENTRY))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->GetMailListEntry (rEntry, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_ENTRY, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * getMailList.
 */
sal_Bool RecvClient_Impl::getMailList (
	List &rList, INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_LIST))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->GetMailList (rList, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_LIST, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * getUniqueIdList.
 */
sal_Bool RecvClient_Impl::getUniqueIdList (
	List &rList, INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_UIDL))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->GetUniqueIdList (rList, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_UIDL, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * getMailHead.
 */
sal_Bool RecvClient_Impl::getMailHead (
	sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_HEAD))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		NAMESPACE_VOS(ORef)<MessageContext_Impl> xContext (
			new MessageContext_Impl (pfnCallback, pData));
		if (!xContext->initialize (rMessage))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext.bind (&*xContext);
		if (!xConnection->GetMailHeader (
			nIndex, (*xContext)(), onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_HEAD, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * getMail.
 */
sal_Bool RecvClient_Impl::getMail (
	sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_MAIL))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		NAMESPACE_VOS(ORef)<MessageContext_Impl> xContext (
			new MessageContext_Impl (pfnCallback, pData));
		if (!xContext->initialize (rMessage))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext.bind (&*xContext);
		if (!xConnection->RetrieveMail (
			nIndex, (*xContext)(), onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_MAIL, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * deleteMail.
 */
sal_Bool RecvClient_Impl::deleteMail (
	sal_uInt32 nIndex, INetCoreMailerCallback *pfnCallback, void *pData)
{
	if (changeState_Impl (STATE_NONE, STATE_DELETE))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_NONE);
			return sal_False;
		}

		m_xContext = new RecvContext_Impl (pfnCallback, pData);
		if (!xConnection->DeleteMail (nIndex, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_DELETE, STATE_NONE))
			{
				// Failure.
				m_xContext.unbind();
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * getTransferCount.
 */
sal_uInt32 RecvClient_Impl::getTransferCount (void) const
{
	NAMESPACE_VOS(ORef)<connection_type> xConnection;
	if (getConnection_Impl (xConnection))
		return xConnection->GetRetrieveCount();
	else
		return 0;
}

/*
 * loginUser_Impl.
 */
sal_Bool RecvClient_Impl::loginUser_Impl (const OUString &rUsername)
{
	if (changeState_Impl (STATE_EVENT, STATE_USER))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_EVENT);
			return sal_False;
		}
		if (!xConnection->LoginUser (rUsername, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_USER, STATE_EVENT))
			{
				// Failure.
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

/*
 * loginPass_Impl.
 */
sal_Bool RecvClient_Impl::loginPass_Impl (const OUString &rPassword)
{
	if (changeState_Impl (STATE_EVENT, STATE_PASS))
	{
		NAMESPACE_VOS(ORef)<connection_type> xConnection;
		if (!getConnection_Impl (xConnection))
		{
			setState_Impl (STATE_EVENT);
			return sal_False;
		}
		if (!xConnection->LoginPassword (rPassword, onConnectionEvent, this))
		{
			if (changeState_Impl (STATE_PASS, STATE_EVENT))
			{
				// Failure.
				return sal_False;
			}
		}
		return sal_True;
	}
	return sal_False;
}

