/*************************************************************************
 *
 *  $RCSfile: imapclnt.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INET_IMAPCIMP_HXX
#include <imapcimp.hxx>
#endif

//============================================================================
//
//  INetIMAPClient
//
//============================================================================

// virtual
INetIMAPClient::~INetIMAPClient()
{}

//============================================================================
// virtual
INetIMAPMessageNumberSet * INetIMAPClient::createMessageNumberSet() const
{
	return new INetIMAPMessageNumberSet;
}

//============================================================================
// virtual
INetIMAPSearchKeyList *
INetIMAPClient::createSearchKeyList(INetIMAPSearchKey * pKey) const
{
	return new INetIMAPSearchKeyList(pKey);
}

//============================================================================
// virtual
INetIMAPSimpleSearchKey *
INetIMAPClient::createSimpleSearchKey(INetIMAPSimpleSearchKey::Criterium
									      eCriterium) const
{
	return new INetIMAPSimpleSearchKey(eCriterium);
}

//============================================================================
// virtual
INetIMAPTextSearchKey *
INetIMAPClient::createTextSearchKey(INetIMAPTextSearchKey::Property eProperty,
									ByteString const & rText) const
{
	return new INetIMAPTextSearchKey(eProperty, rText);
}

//============================================================================
// virtual
INetIMAPRFC822SizeSearchKey * INetIMAPClient::createRFC822SizeSearchKey(
	                              INetIMAPRFC822SizeSearchKey::Conditional
								      eConditional,
								  sal_uInt32 nSize) const
{
	return new INetIMAPRFC822SizeSearchKey(eConditional, nSize);
}

//============================================================================
// virtual
INetIMAPDateSearchKey *
INetIMAPClient::createDateSearchKey(INetIMAPDateSearchKey::Conditional
									    eConditional,
									Date const & rDate) const
{
	return new INetIMAPDateSearchKey(eConditional, rDate);
}

//============================================================================
// virtual
INetIMAPKeywordSearchKey *
INetIMAPClient::createKeywordSearchKey(INetIMAPKeywordSearchKey::Conditional
									       eConditional,
									   ByteString const & rKeyword) const
{
	return new INetIMAPKeywordSearchKey(eConditional, rKeyword);
}

//============================================================================
// virtual
INetIMAPHeaderSearchKey *
INetIMAPClient::createHeaderSearchKey(ByteString const & rFieldName,
									  ByteString const & rText) const
{
	return new INetIMAPHeaderSearchKey(rFieldName, rText);
}

//============================================================================
// virtual
INetIMAPSetSearchKey *
INetIMAPClient::createSetSearchKey(INetIMAPMessageNumberSet * pSet) const
{
	return new INetIMAPSetSearchKey(pSet);
}

//============================================================================
// virtual
INetIMAPListSearchKey *
INetIMAPClient::createListSearchKey(INetIMAPSearchKey * pKey) const
{
	return new INetIMAPListSearchKey(pKey);
}

//============================================================================
// virtual
INetIMAPNegationSearchKey *
INetIMAPClient::createNegationSearchKey(INetIMAPSearchKey * pKey) const
{
	return new INetIMAPNegationSearchKey(pKey);
}

//============================================================================
// virtual
INetIMAPDisjunctionSearchKey *
INetIMAPClient::createDisjunctionSearchKey(INetIMAPSearchKey * pKey1,
										   INetIMAPSearchKey * pKey2) const
{
	return new INetIMAPDisjunctionSearchKey(pKey1, pKey2);
}

//============================================================================
// virtual
INetIMAPArgumentBodySection * INetIMAPClient::createArgumentBodySection()
	const
{
	return new INetIMAPArgumentBodySection;
}

//============================================================================
// virtual
INetIMAPArgumentBodySectionList *
INetIMAPClient::createArgumentBodySectionList() const
{
	return new INetIMAPArgumentBodySectionList;
}

//============================================================================
// virtual
INetIMAPHeaderFieldList * INetIMAPClient::createHeaderFieldList() const
{
	return new INetIMAPHeaderFieldList;
}

//============================================================================
// virtual
INetIMAPHeaderFieldListList * INetIMAPClient::createHeaderFieldListList()
	const
{
	return new INetIMAPHeaderFieldListList;
}

//============================================================================
//
//  NewINetImapMailer
//
//============================================================================

INetIMAPClient * __LOADONCALLAPI NewINetImapMailer()
{
	return new INetIMAPClient_Impl;
}

