/*************************************************************************
 *
 *  $RCSfile: imapcimp.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INET_IMAPCIMP_HXX
#define INET_IMAPCIMP_HXX

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef INET_IMAPCLNT_HXX
#include <imapclnt.hxx>
#endif

#ifndef INET_IMAPSCAN_HXX
#include <imapscan.hxx>
#endif

class INetCoreNewsMessageStream;
class INetCoreTCPConnection;

//============================================================================
class INetIMAPCommandArgument
{
public:
	enum Type
	{
		TYPE_LIST_OPEN,
		TYPE_LIST_CLOSE,
		TYPE_TEXT,
		TYPE_ASTRING,
		TYPE_ASTRING_WILD,
		TYPE_STREAM,
		TYPE_STREAM_BASE64
	};

private:
	ByteString m_aText;
	SvStream * m_pStream;
	INetIMAPCommandArgument * m_pNext;
	Type m_eType;

public:
	inline INetIMAPCommandArgument(Type eTheType);

	inline INetIMAPCommandArgument(Type eTheType, ByteString const & rTheText,
								   SvStream * pTheStream = 0);

	~INetIMAPCommandArgument();

	Type getType() const { return m_eType; }

	ByteString const & getText() const { return m_aText; }

	SvStream * getStream() { return m_pStream; }

	inline SvStream * takeStream();

	INetIMAPCommandArgument * getNext() { return m_pNext; }

	INetIMAPCommandArgument ** getNextAddress() { return &m_pNext; }
};

inline INetIMAPCommandArgument::INetIMAPCommandArgument(Type eTheType):
	m_eType(eTheType),
	m_pStream(0),
	m_pNext(0)
{
	DBG_ASSERT(m_eType <= TYPE_LIST_CLOSE,
			   "INetIMAPCommandArgument::INetIMAPCommandArgument():"
			       " Invalid type");
}

inline INetIMAPCommandArgument::INetIMAPCommandArgument(Type eTheType,
														ByteString const &
														    rTheText,
														SvStream *
														    pTheStream):
	m_eType(eTheType),
	m_aText(rTheText),
	m_pStream(pTheStream),
	m_pNext(0)
{
	DBG_ASSERT(m_eType >= TYPE_TEXT
			   && (!m_pStream || m_eType == TYPE_STREAM
				   || m_eType == TYPE_STREAM_BASE64),
			   "INetIMAPCommandArgument::INetIMAPCommandArgument():"
			       " Invalid type");
}

inline SvStream * INetIMAPCommandArgument::takeStream()
{
	SvStream * pTheStream = m_pStream;
	m_pStream = 0;
	return pTheStream;
}

//============================================================================
class INetIMAPClient_Impl: public INetIMAPClient
{
	enum State { STATE_INITIAL, STATE_OPENING, STATE_IDLE,
				 STATE_COMMAND_CAPABILITY, STATE_COMMAND_NOOP,
				 STATE_COMMAND_LOGOUT, STATE_COMMAND_LOGIN,
				 STATE_COMMAND_SELECT, STATE_COMMAND_EXAMINE,
				 STATE_COMMAND_CREATE, STATE_COMMAND_DELETE,
				 STATE_COMMAND_RENAME, STATE_COMMAND_SUBSCRIBE,
				 STATE_COMMAND_UNSUBSCRIBE, STATE_COMMAND_LIST,
				 STATE_COMMAND_LSUB, STATE_COMMAND_STATUS,
				 STATE_COMMAND_APPEND, STATE_COMMAND_CHECK,
				 STATE_COMMAND_CLOSE, STATE_COMMAND_EXPUNGE,
				 STATE_COMMAND_SEARCH, STATE_COMMAND_UID_SEARCH,
				 STATE_COMMAND_FETCH, STATE_COMMAND_UID_FETCH,
				 STATE_COMMAND_STORE, STATE_COMMAND_UID_STORE,
				 STATE_COMMAND_COPY, STATE_COMMAND_UID_COPY,
				 STATE_COMMAND_NAMESPACE, STATE_CLOSED };

	enum ScanState { SCAN_STATE_INITIAL, SCAN_STATE_CONTINUE,
					 SCAN_STATE_RESPONSE, SCAN_STATE_RESPONSE_STATE,
					 SCAN_STATE_RESPONSE_FLAGS,
					 SCAN_STATE_RESPONSE_FLAGS_FLAG,
					 SCAN_STATE_RESPONSE_FLAGS_FLAG_SLASH,
					 SCAN_STATE_RESPONSE_NEWLINE,
					 SCAN_STATE_RESPONSE_LIST, SCAN_STATE_RESPONSE_LIST_FLAG,
					 SCAN_STATE_RESPONSE_LIST_FLAG_SLASH,
					 SCAN_STATE_RESPONSE_LIST_HSEP,
					 SCAN_STATE_RESPONSE_LIST_NAME,
					 SCAN_STATE_RESPONSE_LIST_NEWLINE,
					 SCAN_STATE_RESPONSE_MAILBOX, SCAN_STATE_RESPONSE_SEARCH,
					 SCAN_STATE_RESPONSE_STATUS,
					 SCAN_STATE_RESPONSE_STATUS_ATTRIB_LIST,
					 SCAN_STATE_RESPONSE_STATUS_ATTRIB,
					 SCAN_STATE_RESPONSE_STATUS_ATTRIB_VALUE,
					 SCAN_STATE_RESPONSE_CAPABILITY,
					 SCAN_STATE_RESPONSE_CAPABILITY_TOO_LONG,
					 SCAN_STATE_RESPONSE_NAMESPACE,
					 SCAN_STATE_RESPONSE_NAMESPACE_LIST,
					 SCAN_STATE_RESPONSE_NAMESPACE_PREFIX,
					 SCAN_STATE_RESPONSE_NAMESPACE_HSEP,
					 SCAN_STATE_RESPONSE_NAMESPACE_EXT,
					 SCAN_STATE_RESPONSE_NAMESPACE_EXT_LIST,
					 SCAN_STATE_RESPONSE_NAMESPACE_EXT_ARG,
					 SCAN_STATE_RESPONSE_NUMBER, SCAN_STATE_RESPONSE_FETCH,
					 SCAN_STATE_RESPONSE_FETCH_ATTRIB,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_DATE,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_SUBJECT,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADR,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_LIST,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_NAME,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_ADL,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_MAILBOX,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_HOST,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_ADDRESS_CLOSE,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_IN_REPLY_TO,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_MESSAGE_ID,
					 SCAN_STATE_RESPONSE_FETCH_ENVELOPE_CLOSE,
					 SCAN_STATE_RESPONSE_FETCH_FLAGS,
					 SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG,
					 SCAN_STATE_RESPONSE_FETCH_FLAGS_FLAG_SLASH,
					 SCAN_STATE_RESPONSE_FETCH_INTERNALDATE,
					 SCAN_STATE_RESPONSE_FETCH_RFC822,
					 SCAN_STATE_RESPONSE_FETCH_RFC822_DOT,
					 SCAN_STATE_RESPONSE_FETCH_RFC822_SIZE,
					 SCAN_STATE_RESPONSE_FETCH_BODY,
					 SCAN_STATE_RESPONSE_FETCH_BODY_LIST,
					 SCAN_STATE_RESPONSE_FETCH_BODYSTRUCTURE,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_NUMBER_DOT,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_HEADER_DOT,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FIELDS_DOT,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FOPEN,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_FNAME,
					 SCAN_STATE_RESPONSE_FETCH_BODY_SECTION_CLOSE,
					 SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL,
					 SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_NUMBER,
					 SCAN_STATE_RESPONSE_FETCH_BODY_PARTIAL_CLOSE,
					 SCAN_STATE_RESPONSE_FETCH_BODY_DATA,
					 SCAN_STATE_RESPONSE_FETCH_BODY_LONG,
					 SCAN_STATE_RESPONSE_FETCH_UID, SCAN_STATE_INVALID };

	enum ResponseID { RESPONSE_INVALID, RESPONSE_OK, RESPONSE_NO,
					  RESPONSE_BAD, RESPONSE_PREAUTH, RESPONSE_BYE,
					  RESPONSE_FLAGS, RESPONSE_LIST, RESPONSE_LSUB,
					  RESPONSE_MAILBOX, RESPONSE_SEARCH, RESPONSE_STATUS,
					  RESPONSE_CAPABILITY, RESPONSE_NAMESPACE,
					  RESPONSE_EXISTS, RESPONSE_RECENT, RESPONSE_EXPUNGE,
					  RESPONSE_FETCH, RESPONSE_NUMBER };

	enum EnvelopeAdrPart { ENVELOPE_ADR_FROM, ENVELOPE_ADR_SENDER,
						   ENVELOPE_ADR_REPLY_TO, ENVELOPE_ADR_TO,
						   ENVELOPE_ADR_CC, ENVELOPE_ADR_BCC };

	enum EnvelopeAdrPrefix { PREFIX_NONE, PREFIX_SPACE, PREFIX_COMMA };

	enum CallbackType { CALLBACK_STATE, CALLBACK_UNILATERAL,
						CALLBACK_COMMAND };

	vos::OMutex m_aMutex;
	Link m_aUnilateralCallback;
	Link m_aCommandCallback;
	Link m_aStreamCallback;
	ByteString m_aSelectedMailbox;
	ByteString m_aTag;
	ByteString m_aLine;
	ByteString m_aFetchResponseEnvelopeAdr;
	ByteString m_aFetchResponseEnvelopeAdrName;
	ByteString m_aFetchResponseEnvelopeAdrADL;
	ByteString m_aFetchResponseEnvelopeAdrMailbox;
	ByteString m_aNamespaceResponsePrefix;
	SvLockBytesRef m_xScanner;
	vos::ORef< INetCoreTCPConnection > m_xConnection;
	SvLockBytesRef m_xCommandStream;
	void * m_pUnilateralResponseData;
	void * m_pCommandResponseData;
	INetIMAPResponse * m_pResponse;
	INetIMAPListResponseMailbox * m_pListResponseMailbox;
	INetIMAPFetchResponseBodySection * m_pFetchResponseBodySection;
	INetCoreNewsMessageStream * m_pFetchResponseBodySectionParser;
	sal_uInt32 m_nResponseNumber;
	sal_uInt32 m_nFetchResponseBodyLevel;
	State m_eState;
	Capabilities m_eCapabilities;
	ScanState m_eScanState;
	ResponseID m_eResponseID;
	INetIMAPStatusAttributes m_eStatusResponseAttribute;
	EnvelopeAdrPart m_eFetchResponseEnvelopeAdrPart;
	EnvelopeAdrPrefix m_eFetchResponseEnvelopeAdrPrefix;
	int m_nNamespaceResponseKind;
	xub_StrLen m_nLineOffset;
	sal_Char m_cNamespaceResponseHierarchySeparator;
	bool m_bAuthenticated;
	bool m_bCapabilitiesDetermined;
	bool m_bTaggedResponse;
	bool m_bResponseMailboxAppendable;
	bool m_bFetchResponseEnvelopeAdrMailboxNIL;

	static ByteString makeRFC822Phrase(ByteString const & rText);

	INetIMAPCodeResponse::Code
	parseResponseText(INetIMAPFlags & rPermanentFlags,
					  INetIMAPFlagKeywordList & rPermanentFlagKeywords,
					  bool & rPermanentNewFlagKeywords, sal_uInt32 & rNumber,
					  UniString & rText);

	INetIMAPScanner::Mode doneFetchResponseEnvelopeAdr(bool bAdr);

	void createFetchResponseBodySectionParser();

	static INetIMAPScanner::Mode scannerCallback(INetIMAPScannerToken const &
												     rToken,
												 void * pData);

	static int connectionTerminationCallback(INetCoreTCPConnection *
											     pTheConnection,
											 int nStatus, void * pData);

	static int connectionOpenCallback(INetCoreTCPConnection * pTheConnection,
									  int nStatus, void * pData);

	static int connectionReceiveCallback(INetCoreTCPConnection *
										     pTheConnection,
										 int nStatus, void * pData);

	static int connectionSendCallback(INetCoreTCPConnection * pTheConnection,
									  int nStatus, void * pData);

	bool callBack(INetIMAPResponse & rResponse,
				  CallbackType eType = CALLBACK_STATE);

	void freshTag();

	ErrCode startCommand(Link const & rCallback, void * pResponseData,
						 State eCommandState);

	ErrCode sendCommand();

	virtual bool hasOpenConnection() const;

	virtual bool hasClosedConnection() const;

	virtual ErrCode openConnection(UniString const & rHost, sal_uInt16 nPort,
								   UniString const & rSocksProxyHost,
								   sal_uInt16 nSocksProxyPort,
								   Link const & rTheUnilateralCallback,
								   void * pTheUnilateralResponseData,
								   Link const & rConnectCallback,
								   void * pConnectResponseData);

	virtual ErrCode abortConnection();

	virtual ErrCode cancelCommand();

	virtual ErrCode commandCapability(Link const & rCallback,
									  void * pResponseData);

	virtual ErrCode commandNoOp(Link const & rCallback, void * pResponseData);

	virtual ErrCode commandLogOut(Link const & rCallback,
								  void * pResponseData);

	virtual ErrCode commandLogIn(Link const & rCallback, void * pResponseData,
								 UniString const & rUserID,
								 UniString const & rPassword);

	virtual ErrCode commandSelect(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName);

	virtual ErrCode commandExamine(Link const & rCallback,
								   void * pResponseData,
								   ByteString const & rMailboxName);

	virtual ErrCode commandCreate(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName);

	virtual ErrCode commandDelete(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName);

	virtual ErrCode commandRename(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rOldMailboxName,
								  ByteString const & rNewMailboxName);

	virtual ErrCode commandSubscribe(Link const & rCallback,
									 void * pResponseData,
									 ByteString const & rMailboxName);

	virtual ErrCode commandUnSubscribe(Link const & rCallback,
									   void * pResponseData,
									   ByteString const & rMailboxName);

	virtual ErrCode commandList(Link const & rCallback, void * pResponseData,
								ByteString const & rReference,
								ByteString const & rPattern);

	virtual ErrCode commandLSub(Link const & rCallback, void * pResponseData,
								ByteString const & rReference,
								ByteString const & rPattern);

	virtual ErrCode commandStatus(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName,
								  INetIMAPStatusAttributes eAttributes);

	virtual ErrCode commandAppend(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName,
								  ByteString const & rRFC822Header,
								  ByteString const & rMediaType,
								  SvStream * pBody);

	virtual ErrCode commandAppend(Link const & rCallback,
								  void * pResponseData,
								  ByteString const & rMailboxName,
								  SvStream * pMessage);

	virtual ErrCode commandCheck(Link const & rCallback,
								 void * pResponseData);

	virtual ErrCode commandClose(Link const & rCallback,
								 void * pResponseData);

	virtual ErrCode commandExpunge(Link const & rCallback,
								   void * pResponseData);

	virtual ErrCode commandSearch(Link const & rCallback,
								  void * pResponseData, bool bUIDCommand,
								  rtl_TextEncoding eCharset,
								  INetIMAPSearchKeyList const & rKeys);

	virtual ErrCode commandFetch(Link const & rCallback, void * pResponseData,
								 bool bUIDCommand,
								 INetIMAPMessageNumberSet const &
								     rMessageNumberSet,
								 FetchAttributes eAttributes,
								 INetIMAPArgumentBodySectionList const *
								     pBodySections,
								 INetIMAPHeaderFieldListList const *
								     pRFC822HeaderLines,
								 Link const & rTheStreamCallback);

	virtual ErrCode commandStore(Link const & rCallback, void * pResponseData,
								 bool bUIDCommand,
								 INetIMAPMessageNumberSet  const &
								     rMessageNumberSet,
								 StoreAttribute eAttribute,
								 INetIMAPFlags eFlags,
								 INetIMAPFlagKeywordList const *
								     pFlagKeywords);

	virtual ErrCode commandCopy(Link const & rCallback, void * pResponseData,
								bool bUIDCommand,
								INetIMAPMessageNumberSet const &
								    rMessageNumberSet,
								ByteString const & rMailboxName);

	virtual ErrCode commandNamespace(Link const & rCallback,
									 void * pResponseData);

	virtual bool isAuthenticated() const;

	virtual bool hasDeterminedCapabilities() const;

	virtual Capabilities getCapabilities() const;

	virtual ByteString const & getSelectedMailbox() const;

	virtual ~INetIMAPClient_Impl();

public:
	INetIMAPClient_Impl();

	void appendCommandArgument(INetIMAPCommandArgument * pArgument);
};

#endif // INET_IMAPCIMP_HXX

