/*************************************************************************
 *
 *  $RCSfile: inetcfg.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_CONFIG_CXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _WLDCRD_HXX
#include <tools/wldcrd.hxx>
#endif

#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

using rtl::OUString;

/*=======================================================================
 *
 * INetSimpleProxyPolicy interface.
 *
 *=====================================================================*/
class INetSimpleProxyPolicy :
	public NAMESPACE_INET(INetProxyPolicy),
	public NAMESPACE_VOS(OReference)
{
public:
	INetSimpleProxyPolicy (void);

	/** INetProxyPolicy.
	 */
	virtual sal_Bool shouldUseProxy (
		const rtl::OUString& rUrl, INetProxyConfig& rProxyCfg);

	/** IReference.
	 */
	virtual RefCount SAL_CALL acquire (void)
	{
		return OReference::acquire();
	}
	virtual RefCount SAL_CALL release (void)
	{
		return OReference::release();
	}
	virtual RefCount SAL_CALL referenced (void) const
	{
		return OReference::referenced();
	}

protected:
	virtual ~INetSimpleProxyPolicy (void);

private:
	/** Not implemeted.
	*/
	INetSimpleProxyPolicy (const INetSimpleProxyPolicy&);
	INetSimpleProxyPolicy& operator= (const INetSimpleProxyPolicy&);
};

/*=======================================================================
 *
 * INetSimpleProxyPolicy implementation.
 *
 *=====================================================================*/
/*
 * INetSimpleProxyPolicy.
 */
INetSimpleProxyPolicy::INetSimpleProxyPolicy (void)
{
}

/*
 * ~INetSimpleProxyPolicy.
 */
INetSimpleProxyPolicy::~INetSimpleProxyPolicy (void)
{
}

/*
 * shouldUseProxy.
 */
sal_Bool INetSimpleProxyPolicy::shouldUseProxy (
	const OUString& rUrl, INetProxyConfig& rProxyCfg)
{
	// Check URL argument.
	INetURLObject aURL (rUrl);

	INetProtocol eProto = aURL.GetProtocol();
	if (eProto == INET_PROT_NOT_VALID)
		return sal_False;

	// Check Endpoint.
	rtl::OUStringBuffer aBuffer (aURL.GetHost());
	if (aBuffer.getLength() == 0)
		return sal_False;

	sal_uInt16 nPort = aURL.GetPort();
	if (nPort == 0)
	{
		switch (eProto)
		{
			case INET_PROT_FTP:
				nPort = eINET_FTP_PORT;
				break;

			case INET_PROT_HTTP:
				nPort = eINET_HTTP_PORT;
				break;

			case INET_PROT_HTTPS:
				nPort = eINET_HTTPS_PORT;
				break;

			case INET_PROT_IMAP:
				nPort = eINET_IMAP_PORT;
				break;

			case INET_PROT_NEWS:
				nPort = eINET_NNTP_PORT;
				break;

			case INET_PROT_POP3:
				nPort = eINET_POP3_PORT;
				break;

			case INET_PROT_OUT:
				nPort = eINET_SMTP_PORT;
				break;

			case INET_PROT_LDAP:
				nPort = eINET_LDAP_PORT;
				break;

			default:
				break;
		}
	}
	aBuffer.append (sal_Unicode(':'));
	aBuffer.append (sal_Int32(nPort));

	// Obtain ProxyConfig from INetConfig.
	NAMESPACE_VOS(ORef)<INetConfig> xConfig;
	if (INetConfig::getOrCreate (xConfig))
		rProxyCfg = xConfig->getProxyConfig();
	else
		return sal_False;

	// Setup EndPoint.
	OUString aEndpoint (aBuffer.makeStringAndClear());

	// Check NoProxyList.
	UniString aNoProxyList (rProxyCfg.getNoProxyList());
	if (aNoProxyList.Len())
	{
		// Match NoProxyList.
		sal_uInt16 i, n = aNoProxyList.GetTokenCount (';');
		for (i = 0; i < n; i++)
		{
			UniString aWildStr (aNoProxyList.GetToken (i, ';'));
			if (aWildStr.Search (':') == STRING_NOTFOUND)
				aWildStr.AppendAscii (":*");

			WildCard aWild (aWildStr);
			if (aWild.Matches (aEndpoint))
				return sal_False;
		}
	}

	// Should use a Proxy (Endpoint didn't match NoProxyList).
	switch (eProto)
	{
		case INET_PROT_FTP:
			return (rProxyCfg.hasFtpProxy() ||
					rProxyCfg.hasSocksProxy());

		case INET_PROT_HTTP:
			return (rProxyCfg.hasHttpProxy() ||
					rProxyCfg.hasSocksProxy());

		case INET_PROT_HTTPS:
			return (rProxyCfg.hasSecureSocketProxy() ||
					rProxyCfg.hasSocksProxy());

		default:
			return rProxyCfg.hasSocksProxy();
	}
}

/*=======================================================================
 *
 * INetConfig internals.
 *
 *=====================================================================*/
/*
 * __getGlobalMutex_Impl (protect single instance creation).
 */
static NAMESPACE_VOS(IMutex)& __getGlobalMutex_Impl (void)
{
	static NAMESPACE_VOS(IMutex) *pMutex = NULL;
	if (!pMutex)
	{
		NAMESPACE_VOS(OGuard) aGuard (NAMESPACE_VOS(OMutex)::getGlobalMutex());
		if (!pMutex)
		{
			static NAMESPACE_VOS(OMutex) aGlobalMutex;
			pMutex = &aGlobalMutex;
		}
	}
	return *pMutex;
}

/*=======================================================================
 *
 * INetConfig implementation.
 *
 *=====================================================================*/
VOS_IMPLEMENT_CLASSINFO(
	VOS_CLASSNAME (INetConfig, inet),
	VOS_NAMESPACE (INetConfig, inet),
	VOS_NAMESPACE (OObject, vos),
	0);

/*
 * The single instance.
 */
NAMESPACE_INET(INetConfig)*
NAMESPACE_INET(INetConfig)::m_pThis = NULL;

/*
 * INetConfig.
 */
INetConfig::INetConfig (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = this;
}

/*
 * ~INetConfig.
 */
INetConfig::~INetConfig (void)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	m_pThis = NULL;
}

/*
 * getOrCreate.
 */
sal_Bool INetConfig::getOrCreate (NAMESPACE_VOS(ORef)<INetConfig> &rxConfig)
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	if (!m_pThis)
		new INetConfig();
	rxConfig = m_pThis;
	return rxConfig.isValid();
}

/*
 * getProxyPolicy.
 */
NAMESPACE_VOS(ORef)<INetProxyPolicy> INetConfig::getProxyPolicy (void) const
{
	NAMESPACE_VOS(OGuard) aGuard (__getGlobalMutex_Impl());
	if (!m_xProxyPolicy.isValid())
	{
		// Create default policy.
		INetConfig *pThis = SAL_CONST_CAST(INetConfig*, this);
		pThis->m_xProxyPolicy = new INetSimpleProxyPolicy();
	}
	return m_xProxyPolicy;
}

/*
 * setSecureSocketCertificatePath.
 */
void INetConfig::setSecureSocketCertificatePath (const OUString &rPath)
{
#if 0  /* SOLAR_SSL */
	INetCoreSSLConfig *pConfig = ::GetINetCoreSSLConfig();
	if (pConfig)
		pConfig->SetCertPath (rPath);
#endif /* SOLAR_SSL */
}

/*
 * setSecureSocketCipherLevel.
 */
void INetConfig::setSecureSocketCipherLevel (sal_uInt16 nLevel)
{
#if 0  /* SOLAR_SSL */
	INetCoreSSLConfig *pConfig = ::GetINetCoreSSLConfig();
	if (pConfig)
		pConfig->SetCipherLevel (nLevel);
#endif /* SOLAR_SSL */
}

