/*************************************************************************
 *
 *  $RCSfile: ldapmsg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:12:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _LDAPMSG_HXX
#define _LDAPMSG_HXX 1

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

/*=======================================================================
 *
 * LDAP Message Objects.
 *
 * References:
 *   RFC 1777 - Lightweight Directory Access Protocol (Draft Standard).
 *   RFC 1823 - The LDAP Application Program Interface (Informational).
 *   RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/
struct ldap_result_st;
struct ldap_attribute_value_pair_st;
struct ldap_attributes_st;
struct ldap_entry_st;
struct ldap_filter_st;
struct ldap_modification_st;
struct ldap_message_st;

/*=======================================================================
 *
 * INetCoreLDAPResultCode.
 *
 *=====================================================================*/
enum INetCoreLDAPResultCode
{
	// Implementation defined Reply (-x).
	INETCORELDAP_REPLY_CONNECTION_TERMINATED        = -19,

	INETCORELDAP_REPLY_SEARCHENTRY                  = -18,

	INETCORELDAP_REPLY_RESPONSE_DONE                = -16,
	INETCORELDAP_REPLY_RESPONSE_ERROR               = -15,
	INETCORELDAP_REPLY_RESPONSE_WAIT                = -14,

	INETCORELDAP_REPLY_REQUEST_DONE                 = -12,
	INETCORELDAP_REPLY_REQUEST_ERROR                = -11,
	INETCORELDAP_REPLY_REQUEST_WAIT                 = -10,

	INETCORELDAP_REPLY_CONNECT_DONE                 = -8,
	INETCORELDAP_REPLY_CONNECT_ERROR                = -7,
	INETCORELDAP_REPLY_CONNECT_WAIT                 = -6,

	INETCORELDAP_REPLY_RESOLVER_DONE                = -4,
	INETCORELDAP_REPLY_RESOLVER_ERROR               = -3,
	INETCORELDAP_REPLY_RESOLVER_WAIT                = -2,

	INETCORELDAP_REPLY_NETWORK_ERROR                = -1,

	// Protocol defined Result (x).
	INETCORELDAP_RESULT_SUCCESS                      =  0,
	INETCORELDAP_RESULT_OPERATIONS_ERROR             =  1,
	INETCORELDAP_RESULT_PROTOCOL_ERROR               =  2,
	INETCORELDAP_RESULT_TIMELIMIT_EXCEEDED           =  3,
	INETCORELDAP_RESULT_SIZELIMIT_EXCEEDED           =  4,
	INETCORELDAP_RESULT_COMPARE_FALSE                =  5,
	INETCORELDAP_RESULT_COMPARE_TRUE                 =  6,
	INETCORELDAP_RESULT_AUTH_METHOD_NOT_SUPPORTED    =  7,
	INETCORELDAP_RESULT_STRONG_AUTH_REQUIRED         =  8,
	INETCORELDAP_RESULT_NO_SUCH_ATTRIBUTE            = 16,
	INETCORELDAP_RESULT_UNDEFINED_ATTRIBUTE_TYPE     = 17,
	INETCORELDAP_RESULT_INAPPROPRIATE_MATCHING       = 18,
	INETCORELDAP_RESULT_CONSTRAINT_VIOLATING         = 19,
	INETCORELDAP_RESULT_ATTRIBUTE_OR_VALUE_EXISTS    = 20,
	INETCORELDAP_RESULT_INVALID_ATTRIBUTE_SYNTAX     = 21,
	INETCORELDAP_RESULT_NO_SUCH_OBJECT               = 32,
	INETCORELDAP_RESULT_ALIAS_PROBLEM                = 33,
	INETCORELDAP_RESULT_INVALID_DN_SYNTAX            = 34,
	INETCORELDAP_RESULT_IS_LEAF                      = 35,
	INETCORELDAP_RESULT_ALIAS_DEREF_PROBLEM          = 36,
	INETCORELDAP_RESULT_INAPPROPRIATE_AUTHENTICATION = 48,
	INETCORELDAP_RESULT_INVALID_CREDENTIALS          = 49,
	INETCORELDAP_RESULT_INSUFFICIENT_ACCESS_RIGHTS   = 50,
	INETCORELDAP_RESULT_BUSY                         = 51,
	INETCORELDAP_RESULT_UNAVAILABLE                  = 52,
	INETCORELDAP_RESULT_UNWILLING_TO_PERFORM         = 53,
	INETCORELDAP_RESULT_LOOP_DETECT                  = 54,
	INETCORELDAP_RESULT_NAMING_VIOLATION             = 64,
	INETCORELDAP_RESULT_OBJECT_CLASS_VIOLATION       = 65,
	INETCORELDAP_RESULT_NOT_ALLOWED_ON_NONLEAF       = 66,
	INETCORELDAP_RESULT_NOT_ALLOWED_ON_RDN           = 67,
	INETCORELDAP_RESULT_ENTRY_ALREADY_EXISTS         = 68,
	INETCORELDAP_RESULT_OBJECT_CLASS_MODS_PROHIBITED = 69,
	INETCORELDAP_RESULT_OTHER                        = 80
};

/*=======================================================================
 *
 * INetCoreLDAPResult.
 *
 *=====================================================================*/
class INetCoreLDAPResult
{
	ldap_result_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	INetCoreLDAPResult (const ldap_result_st *pImp);
	const ldap_result_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */

public:
	INetCoreLDAPResult (void);
	virtual ~INetCoreLDAPResult (void);

	virtual sal_Int32 GetResultCode (void) const;

	virtual sal_Bool GetMatchedDN (
		rtl::OUString &rMatchedDN) const;

	virtual sal_Bool GetErrorMessage (
		rtl::OUString &rErrorMessage) const;
};

/*=======================================================================
 *
 * INetCoreLDAPAttributeValuePair.
 *
 *=====================================================================*/
class INetCoreLDAPAttributeValuePair
{
	ldap_attribute_value_pair_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	INetCoreLDAPAttributeValuePair (const ldap_attribute_value_pair_st *pImp);
	const ldap_attribute_value_pair_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */

public:
	INetCoreLDAPAttributeValuePair (void);
	virtual ~INetCoreLDAPAttributeValuePair (void);

	virtual sal_Bool GetType  (rtl::OUString &rType) const;
	virtual sal_Bool GetValue (rtl::OUString &rValue) const;

	virtual sal_Bool SetType  (const rtl::OUString &rNewType);
	virtual sal_Bool SetValue (const rtl::OUString &rNewValue);
};

/*=======================================================================
 *
 * INetCoreLDAPAttribute.
 *
 *=====================================================================*/
class INetCoreLDAPAttribute
{
	ldap_attributes_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	INetCoreLDAPAttribute (const ldap_attributes_st *pImp);
	const ldap_attributes_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */

public:
	INetCoreLDAPAttribute (void);
	virtual ~INetCoreLDAPAttribute (void);

	virtual sal_Bool   GetType (
		rtl::OUString &rType) const;

	virtual sal_uInt16 GetValueCount (void) const;
	virtual sal_Bool   GetValue (
		rtl::OUString &rValue, sal_uInt16 nIndex) const;

	virtual sal_Bool   SetType (
		const rtl::OUString &rNewType);
	virtual sal_Bool   SetValue (
		const rtl::OUString &rNewValue, sal_uInt16 nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPEntry.
 *
 *=====================================================================*/
class INetCoreLDAPEntry
{
	ldap_entry_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	INetCoreLDAPEntry (const ldap_entry_st *pImp);
	const ldap_entry_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */

public:
	INetCoreLDAPEntry (void);
	virtual ~INetCoreLDAPEntry (void);

	virtual sal_Bool   GetObjectName (
		rtl::OUString &rObjectDN) const;

	virtual sal_uInt16 GetAttributeCount (void) const;
	virtual INetCoreLDAPAttribute* GetAttribute (sal_uInt16 nIndex) const;

	virtual sal_Bool   SetObjectName (
		const rtl::OUString &rNewObjectDN);
	virtual sal_Bool   SetAttribute (
		const INetCoreLDAPAttribute& rAttrib, sal_uInt16 nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPFilter.
 *
 *=====================================================================*/
class INetCoreLDAPFilter
{
	ldap_filter_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	INetCoreLDAPFilter (sal_Int32 nFilterType);
	const ldap_filter_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */
	
public:
	INetCoreLDAPFilter (void);
	virtual ~INetCoreLDAPFilter (void);
};

/*=======================================================================
 *
 * INetCoreLDAPAndFilter.
 *
 *=====================================================================*/
class INetCoreLDAPAndFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPAndFilter (void);
	virtual ~INetCoreLDAPAndFilter (void);

	virtual sal_Bool SetFilter (
		const INetCoreLDAPFilter& rFilter, sal_uInt16 nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPOrFilter.
 *
 *=====================================================================*/
class INetCoreLDAPOrFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPOrFilter (void);
	virtual ~INetCoreLDAPOrFilter (void);

	virtual sal_Bool SetFilter (
		const INetCoreLDAPFilter& rFilter, sal_uInt16 nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPNotFilter.
 *
 *=====================================================================*/
class INetCoreLDAPNotFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPNotFilter (void);
	virtual ~INetCoreLDAPNotFilter (void);

	virtual sal_Bool SetFilter (const INetCoreLDAPFilter& rFilter);
};

/*=======================================================================
 *
 * INetCoreLDAPEqualityMatchFilter.
 *
 *=====================================================================*/
class INetCoreLDAPEqualityMatchFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPEqualityMatchFilter (void);
	virtual ~INetCoreLDAPEqualityMatchFilter (void);

	virtual sal_Bool SetAssertion (
		const INetCoreLDAPAttributeValuePair& rAssertion);
};

/*=======================================================================
 *
 * INetCoreLDAPApproxMatchFilter.
 *
 *=====================================================================*/
class INetCoreLDAPApproxMatchFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPApproxMatchFilter (void);
	virtual ~INetCoreLDAPApproxMatchFilter (void);

	virtual sal_Bool SetAssertion (
		const INetCoreLDAPAttributeValuePair& rAssertion);
};

/*=======================================================================
 *
 * INetCoreLDAPGreaterOrEqualFilter.
 *
 *=====================================================================*/
class INetCoreLDAPGreaterOrEqualFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPGreaterOrEqualFilter (void);
	virtual ~INetCoreLDAPGreaterOrEqualFilter (void);

	virtual sal_Bool SetAssertion (
		const INetCoreLDAPAttributeValuePair& rAssertion);
};

/*=======================================================================
 *
 * INetCoreLDAPLessOrEqualFilter.
 *
 *=====================================================================*/
class INetCoreLDAPLessOrEqualFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPLessOrEqualFilter (void);
	virtual ~INetCoreLDAPLessOrEqualFilter (void);

	virtual sal_Bool SetAssertion (
		const INetCoreLDAPAttributeValuePair& rAssertion);
};

/*=======================================================================
 *
 * INetCoreLDAPPresentFilter.
 *
 *=====================================================================*/
class INetCoreLDAPPresentFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPPresentFilter (void);
	virtual ~INetCoreLDAPPresentFilter (void);

	virtual sal_Bool SetAttributeType (
		const rtl::OUString &rAttribType);
};

/*=======================================================================
 *
 * INetCoreLDAPSubstringFilter.
 *
 *=====================================================================*/
enum INetCoreLDAPSubstringPosition
{
	INETCORELDAP_SUBSTRING_INITIAL = 0,
	INETCORELDAP_SUBSTRING_ANY     = 1,
	INETCORELDAP_SUBSTRING_FINAL   = 2
};

class INetCoreLDAPSubstringFilter : public INetCoreLDAPFilter
{
public:
	INetCoreLDAPSubstringFilter (void);
	virtual ~INetCoreLDAPSubstringFilter (void);

	virtual sal_Bool SetAttributeType (
		const rtl::OUString &rAttributeType);
	virtual sal_Bool SetSubstring (
		const rtl::OUString           &rSubstring,
		INetCoreLDAPSubstringPosition  ePos   = INETCORELDAP_SUBSTRING_ANY,
		sal_uInt16                     nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPModification.
 *
 *=====================================================================*/
enum INetCoreLDAPModificationOpcode
{
	INETCORELDAP_MODIFICATION_ADD     = 0,
	INETCORELDAP_MODIFICATION_DELETE  = 1,
	INETCORELDAP_MODIFICATION_REPLACE = 2
};

class INetCoreLDAPModification
{
	ldap_modification_st *m_pImp;

#ifdef _LDAPMSG_CXX
public:
	const ldap_modification_st* GetpImp (void) const { return m_pImp; }
#endif /* _LDAPMSG_CXX */

public:
	INetCoreLDAPModification (void);
	virtual ~INetCoreLDAPModification (void);

	virtual sal_Bool SetOperation (INetCoreLDAPModificationOpcode eOpcode);
	virtual sal_Bool SetAttribute (const INetCoreLDAPAttribute& rAttrib);
};

/*=======================================================================
 *
 * INetCoreLDAPMessage.
 *
 *=====================================================================*/
class INetCoreLDAPMessage
{
	ldap_message_st *m_pImp;
	INetCoreLDAPMessage& operator= (const INetCoreLDAPMessage& rMessage);

protected:
	INetCoreLDAPMessage (sal_Int32 nMessageType);
	INetCoreLDAPMessage (const INetCoreLDAPMessage& rMessage);
	const ldap_message_st* GetpImp (void) const { return m_pImp; }

public:
	INetCoreLDAPMessage (sal_uInt8 **ppData, sal_uInt32 nSize);
	virtual ~INetCoreLDAPMessage (void);

	virtual sal_uInt16 GetMessageID (void) const;
	virtual sal_Bool   SetMessageID (sal_uInt16 nMessageID);

	sal_uInt32  GetEncodedLength (void) const;
	sal_uInt32  GetEncodedData (sal_uInt8 *pData, sal_uInt32 nSize) const;

	sal_Bool IsValid  (void) const { return (!!m_pImp); }
	sal_Bool IsResult (void) const;
	sal_Bool IsEntry  (void) const;

	INetCoreLDAPResult* GetResult (void) const;
	INetCoreLDAPEntry*  GetEntry  (void) const;
};

/*=======================================================================
 *
 * INetCoreLDAPBindRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPBindRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPBindRequestMessage (void);
	virtual ~INetCoreLDAPBindRequestMessage (void);

	sal_Bool SetLDAPVersion    (sal_uInt16 nVersion);
	sal_Bool SetObjectName     (const rtl::OUString &rObjectDN);
	sal_Bool SetObjectPassword (const rtl::OUString &rPassword);
};

/*=======================================================================
 *
 * INetCoreLDAPUnbindRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPUnbindRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPUnbindRequestMessage (void);
	virtual ~INetCoreLDAPUnbindRequestMessage (void);
};

/*=======================================================================
 *
 * INetCoreLDAPSearchRequestMessage.
 *
 *=====================================================================*/
enum INetCoreLDAPSearchScope
{
	INETCORELDAP_SEARCH_SCOPE_BASEOBJECT   = 0,
	INETCORELDAP_SEARCH_SCOPE_SINGLELEVEL  = 1,
	INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE = 2
};

enum INetCoreLDAPSearchDerefAlias
{
	INETCORELDAP_SEARCH_DEREF_NEVER              = 0,
	INETCORELDAP_SEARCH_DEREF_IN_SEARCHING       = 1,
	INETCORELDAP_SEARCH_DEREF_FINDING_BASEOBJECT = 2,
	INETCORELDAP_SEARCH_DEREF_ALWAYS             = 3
};

class INetCoreLDAPSearchRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPSearchRequestMessage (void);
	INetCoreLDAPSearchRequestMessage (
		const INetCoreLDAPSearchRequestMessage& rMsg);
	virtual ~INetCoreLDAPSearchRequestMessage (void);

	virtual sal_Bool SetBaseObject (
		const rtl::OUString &rBaseObject);

	virtual sal_Bool SetScope      (INetCoreLDAPSearchScope eScope);
	virtual sal_Bool SetDerefAlias (INetCoreLDAPSearchDerefAlias eDerefAlias);

	virtual sal_Bool SetSizeLimit  (sal_uInt16 nSizeLimit);
	virtual sal_Bool SetTimeLimit  (sal_uInt16 nTimeLimit);

	virtual sal_Bool SetAttributesOnly (sal_Bool bAttrsOnly = sal_True);
	virtual sal_Bool SetFilter         (const INetCoreLDAPFilter& rFilter);
	virtual sal_Bool SetAttributeType  (
		const rtl::OUString &rAttribType,
		sal_uInt16           nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPModifyRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPModifyRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPModifyRequestMessage (void);
	INetCoreLDAPModifyRequestMessage (
		const INetCoreLDAPModifyRequestMessage& rMsg);
	virtual ~INetCoreLDAPModifyRequestMessage (void);

	virtual sal_Bool SetObjectName (
		const rtl::OUString &rObjectDN);
	virtual sal_Bool SetModification (
		const INetCoreLDAPModification& rMod, sal_uInt16 nIndex = 0xffff);
};

/*=======================================================================
 *
 * INetCoreLDAPAddRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPAddRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPAddRequestMessage (void);
	virtual ~INetCoreLDAPAddRequestMessage (void);

	sal_Bool SetEntry (const INetCoreLDAPEntry& rEntry);
};

/*=======================================================================
 *
 * INetCoreLDAPDeleteRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPDeleteRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPDeleteRequestMessage (void);
	virtual ~INetCoreLDAPDeleteRequestMessage (void);

	sal_Bool SetObjectName (const rtl::OUString &rObjectDN);
};

/*=======================================================================
 *
 * INetCoreLDAPModifyRDNRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPModifyRDNRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPModifyRDNRequestMessage (void);
	virtual ~INetCoreLDAPModifyRDNRequestMessage (void);

	sal_Bool SetObjectName (const rtl::OUString &rObjectDN);
	sal_Bool SetNewRDN     (const rtl::OUString &rNewRDN);
};

/*=======================================================================
 *
 * INetCoreLDAPCompareRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPCompareRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPCompareRequestMessage (void);
	virtual ~INetCoreLDAPCompareRequestMessage (void);

	sal_Bool SetObjectName (const rtl::OUString &rObjectDN);
	sal_Bool SetAssertion  (const INetCoreLDAPAttributeValuePair& rAssertion);
};

/*=======================================================================
 *
 * INetCoreLDAPAbandonRequestMessage.
 *
 *=====================================================================*/
class INetCoreLDAPAbandonRequestMessage : public INetCoreLDAPMessage
{
public:
	INetCoreLDAPAbandonRequestMessage (void);
	virtual ~INetCoreLDAPAbandonRequestMessage (void);

	sal_Bool SetAbandonMessageID (sal_uInt16 nMessageID);
};

#endif /* !_LDAPMSG_HXX */

