/*************************************************************************
 *
 *  $RCSfile: inettcp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETTCP_HXX
#define _INETTCP_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

class SvLockBytes;

/*=======================================================================
 *
 * INetCoreTCPConnection Interface.
 *
 *=====================================================================*/
class  INetCoreTCPConnection;
struct INetCoreTCPConnectionContext;

enum INetCoreTCPConnectionStatus
{
	INETCORETCP_STATUS_NETWORK_ERROR = -1,
	INETCORETCP_STATUS_NAMERES_WAIT  =  0,
	INETCORETCP_STATUS_NAMERES_DONE  =  1,
	INETCORETCP_STATUS_NAMERES_ERROR =  2,
	INETCORETCP_STATUS_CONNECT_WAIT  =  3,
	INETCORETCP_STATUS_CONNECT_DONE  =  4,
	INETCORETCP_STATUS_CONNECT_ERROR =  5,
	INETCORETCP_STATUS_SEND_WAIT     =  6,
	INETCORETCP_STATUS_SEND_DONE     =  7,
	INETCORETCP_STATUS_RECV_WAIT     =  8,
	INETCORETCP_STATUS_RECV_ERROR    =  9
};

typedef int INetCoreTCPCallback (
	INetCoreTCPConnection *pConnection, int nStatus, void *pData);

class INetCoreTCPConnection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
public:
	INetCoreTCPConnection (sal_uInt32 nBufferSize = 4096);

	sal_Bool Open (
		const rtl::OUString &rScheme,
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetCoreTCPCallback *pfnCallback, void *pData);
	sal_Bool IsOpen (void);

	void Abort (void);

	sal_Bool Recv (
		SvLockBytes         &rRecvLB,
		INetCoreTCPCallback *pfnCallback, void *pData);
	sal_uInt32 GetRecvCount (void);
	
	sal_Bool Send (
		SvLockBytes         &rSendLB,
		INetCoreTCPCallback *pfnCallback, void *pData);
	sal_uInt32 GetSendCount (void);
	
	void SetTerminateCallback (
		INetCoreTCPCallback *pfnCallback, void *pData);

protected:
	virtual ~INetCoreTCPConnection (void);

private:
	typedef NAMESPACE_INET(INetSocket) socket_type;

	INetCoreTCPConnectionContext *m_pConCtx;

	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<socket_type> &rxSocket, sal_Int32 nEvent);
};

#endif /* !_INETTCP_HXX */

