/*************************************************************************
 *
 *  $RCSfile: inethbci.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETHBCI_HXX
#define _INETHBCI_HXX "$Revision: 1.1.1.1 $"

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

// For connect callback
#define INET_HBCI_CONNECT_SUCCESS 	0
#define INET_HBCI_NAMERESOLVE_ERROR	1
#define INET_HBCI_CONNECT_ERROR 	2

// For status callback
#define INET_HBCI_DATAWRITTEN 	1
#define INET_HBCI_NAMERESOLVED 	2

// define for nStatus
#define INET_HBCI_NOTCONNECTED	0 
#define INET_HBCI_CONNECTED		1

class INetCoreTCPConnection;

class INetHbci
{
	typedef NAMESPACE_VOS(ORef)<INetCoreTCPConnection> ConnectionRef;

	/** Representation.
	 */
	void*          pImp;
	Link           aConnectLinkHdl;
	Link           aStatusLinkHdl;
	Link           aResponseLinkHdl;
	Link           aDisconnectLinkHdl;

	ConnectionRef  xCon;
	SvLockBytesRef xSendLB;
	SvLockBytesRef xRecvLB;
	ULONG          nWritten;
	USHORT         nStatus;

#ifdef _INETHBCI_CXX
	/** Implementation.
	 */
	static int ConnectCallback (
		INetCoreTCPConnection *pCon,
		int nStatus,
		INetHbci *pThis);
	static int SendCallback (
		INetCoreTCPConnection *pCon,
		int nStatus,
		INetHbci *pThis);
	static int ReceiveCallback (
		INetCoreTCPConnection *pCon,
		int nStatus,
		INetHbci *pThis);
	static int TerminateCallback (
		INetCoreTCPConnection *pCon,
		int nStatus,
		INetHbci *pThis);
#endif /* _INETHBCI_CXX */

public:
	INetHbci();
	virtual ~INetHbci();

	// Param: USHORT nErrNumber
	// nErrNumber defined above (INET_HBCI_SUCCESS, ..)
	void SetConnectHdl(const Link& rLink) { aConnectLinkHdl = rLink; }

	// Param: USHORT
	void SetStatusHdl(const Link& rLink) { aStatusLinkHdl = rLink; }

	// Param: SvLockBytes *
	void SetResponseHdl(const Link& rLink) { aResponseLinkHdl = rLink; }

	// Param: InetHbci *
	void SetDisconnectHdl(const Link& rLink) { aDisconnectLinkHdl = rLink; }

	// sIP: Name or IP-Number
	// nPort: Port number
	virtual const BOOL Connect(const String& sHost, const USHORT nPort);

	virtual void Disconnect();

	// startet die Uebertragung aus den SvLockBytes
	virtual const BOOL WriteRequest(SvLockBytes* pLB);

	// Returns number of bytes already written since last write request
	const ULONG CountWrittenBytes() const { return nWritten; }

	// returns true, if connected
	BOOL IsConnected() const { return (nStatus == INET_HBCI_CONNECTED); }

	/** Reserved.
	 */
	virtual void dummy1();
	virtual void dummy2();
	virtual void dummy3();
};

extern "C" INetHbci* __LOADONCALLAPI NewINetHbci();

#endif /* !_INETHBCI_HXX */

