/*************************************************************************
 *
 *  $RCSfile: socks4.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_SOCKS4_H_
#define _INET_SOCKS4_H_ "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_SOCKET_H_
#include <osl/socket.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/** Opaque data type oslSocksContext.
 */
typedef void* oslSocksContext;


/** oslSocksCommand.
 */
typedef enum
{
	osl_Socks_CommandConnect = 1,
	osl_Socks_CommandBind    = 2,
	osl_Socks_Command_FORCE_EQUAL_SIZE = SAL_MAX_ENUM
} oslSocksCommand;


/** osl_socks_createContext.
 *  @param  hSocket [in]
 *  @param  hGwAddr [in]
 *  @return oslSocksContext upon success
 */
oslSocksContext SAL_CALL __osl_socks_createContext (
	oslSocket     hSocket,
	oslSocketAddr hGwAddr);


/** osl_socks_initContext.
 *  @param  hContext [in]
 *  @param  eCommand [in]
 *  @param  hDestAddr [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_initContext (
	oslSocksContext hContext,
	oslSocksCommand eCommand,
	oslSocketAddr   hDestAddr);


/** osl_socks_connectContext.
 *  @param  hContext [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_InProgress when operating over nonblocking socket,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_connectContext (
	oslSocksContext hContext);


/** osl_socks_sendContext.
 *  @param  hContext [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_InProgress when operating over nonblocking socket,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_sendContext (
	oslSocksContext hContext);


/** osl_socks_recvContext.
 *  @param  hContext [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_InProgress when operating over nonblocking socket,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_recvContext (
	oslSocksContext hContext);


/** osl_socks_getContext.
 *  @param  hContext [in]
 *  @param  phBindAddr [out] resulting Bind address upon success
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_getContext (
	oslSocksContext hContext,
	oslSocketAddr  *phBindAddr);


/** osl_socks_destroyContext.
 *  @param  hContext [in] to be destroyed.
 */
void SAL_CALL __osl_socks_destroyContext (
	oslSocksContext hContext);


/** osl_socks_connectSocketTo.
 *  @param  hContext [in]
 *  @param  hToAddr [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_InProgress when operating over nonblocking socket,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_connectSocketTo (
	oslSocksContext hContext,
	oslSocketAddr   hToAddr);


/** osl_socks_listenOnSocket.
 *  @param  hContext [in]
 *  @param  hToAddr [in]
 *  @return osl_Socket_Ok upon success,
 *          osl_Socket_InProgress when operating over nonblocking socket,
 *          osl_Socket_Error otherwise.
 */
oslSocketResult SAL_CALL __osl_socks_listenOnSocket (
	oslSocksContext hContext,
	oslSocketAddr   hToAddr);


/** osl_socks_acceptConnectionOnSocket.
 *  @param  hContext [in]
 *  @param  phFromAddr [out]
 *  @return accepted socket upon success.
 */
oslSocket SAL_CALL __osl_socks_acceptConnectionOnSocket (
	oslSocksContext hContext,
	oslSocketAddr  *phFromAddr);


#ifdef __cplusplus
}
#endif

#endif /* !_INET_SOCKS4_H_ */

