/*************************************************************************
 *
 *  $RCSfile: httpwrap.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_HTTPWRAP_HXX
#define _INET_HTTPWRAP_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

class INetCoreDNSResolver;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetHTTPConnection;

class INetHTTPGetRequest;
class INetHTTPHeadRequest;
class INetHTTPPostRequest;

class INetHTTPPutRequest;
class INetHTTPDeleteRequest;

/*=======================================================================
 *
 * INetHTTPWrapper interface.
 *
 *=====================================================================*/
class INetHTTPWrapper : public NAMESPACE_VOS(OMutex)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetHTTPWrapper, inet));

public:
	/** Construction.
	 *  @see INetWrapper::newINetHTTPWrapper().
	 */
	INetHTTPWrapper (void);
	virtual ~INetHTTPWrapper (void);


	/** Create a new INetHTTPConnection instance.
	 *  @param  rxConnection [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPConnection (
		NAMESPACE_VOS(ORef)<INetHTTPConnection> &rxConnection);


	/** Create a new INetHTTPGetRequest instance.
	 *  @param  rxRequest [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPGetRequest (
		NAMESPACE_VOS(ORef)<INetHTTPGetRequest> &rxRequest);


	/** Create a new INetHTTPHeadRequest instance.
	 *  @param  rxRequest [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPHeadRequest (
		NAMESPACE_VOS(ORef)<INetHTTPHeadRequest> &rxRequest);


	/** Create a new INetHTTPPostRequest instance.
	 *  @param  rxRequest [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPPostRequest (
		NAMESPACE_VOS(ORef)<INetHTTPPostRequest> &rxRequest);


	/** Create a new INetHTTPPutRequest instance.
	 *  @param  rxRequest [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPPutRequest (
		NAMESPACE_VOS(ORef)<INetHTTPPutRequest> &rxRequest);


	/** Create a new INetHTTPDeleteRequest instance.
	 *  @param  rxRequest [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newHTTPDeleteRequest (
		NAMESPACE_VOS(ORef)<INetHTTPDeleteRequest> &rxRequest);

private:
	/** Representation.
	 */
	INetCoreDNSResolver *m_pResolver;

	/** Not implemented.
	 */
	INetHTTPWrapper (const INetHTTPWrapper&);
	INetHTTPWrapper& operator= (const INetHTTPWrapper&);
};

/*=======================================================================
 *
 * The End.
 *
 *=====================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

extern "C" {
	NAMESPACE_INET(INetHTTPWrapper)* SAL_CALL NewINetHTTPWrapper (void);
};

#endif /* _INET_HTTPWRAP_HXX */

