/*************************************************************************
 *
 *  $RCSfile: localedata.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: er $ $Date: 2001/05/31 16:48:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <localedata.hxx>
#include "localedata_nf.hxx"

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif

#pragma hdrstop


using namespace ::com::sun::star::i18n;


LocaleData::LocaleData()
		:
		pIntl( NULL ),
		pFormats( NULL )
{
}


LocaleData::~LocaleData()
{
	delete pFormats;
	delete pIntl;
}


void LocaleData::setupInternational( const ::com::sun::star::lang::Locale& rLocale )
{
	LanguageType eLang = ConvertIsoNamesToLanguage( rLocale.Language,
													rLocale.Country );
	if ( !pIntl )
		pIntl = new International( eLang );
	else if ( eLang != pIntl->GetLanguage() )
	{
		delete pIntl;
		pIntl = new International( eLang );
		if ( pFormats )
			pFormats->scheduleIntlChange( pIntl );
	}
}


::com::sun::star::i18n::LocaleDataItem SAL_CALL
LocaleData::getLocaleItem( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	setupInternational( rLocale );
	LocaleDataItem aItem(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "generic" ) ),
		String( pIntl->GetDateSep() ),
		String( pIntl->GetNumThousandSep() ),
		String( pIntl->GetNumDecimalSep() ),
		String( pIntl->GetTimeSep() ),
		String( pIntl->GetTime100SecSep() ),
		String( pIntl->GetListSep() ),
		String( pIntl->GetQuotationMarkStart() ),
		String( pIntl->GetQuotationMarkEnd() ),
		String( pIntl->GetDoubleQuotationMarkStart() ),
		String( pIntl->GetDoubleQuotationMarkEnd() ),
		pIntl->GetTimeAM(),
		pIntl->GetTimePM(),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "metric" ) ),
		pIntl->GetLongDateDayOfWeekSep(),
		pIntl->GetLongDateDaySep(),
		pIntl->GetLongDateMonthSep(),
		pIntl->GetLongDateYearSep()
	);
	switch ( pIntl->GetMeasurementSystem() )
	{
		case MEASURE_METRIC :
			// we have that already
		break;
		case MEASURE_US :
			aItem.measurementSystem = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "us" ) );
		break;
		default:
			DBG_ERRORFILE( "unknown measurement system" );
			aItem.measurementSystem = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "unknown" ) );
	}
	return aItem;
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Calendar > SAL_CALL
LocaleData::getAllCalendars( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	static const sal_Unicode ppDayID[7][4] =
	{
		{ 's', 'u', 'n', 0 },
		{ 'm', 'o', 'n', 0 },
		{ 't', 'u', 'e', 0 },
		{ 'w', 'e', 'd', 0 },
		{ 't', 'h', 'u', 0 },
		{ 'f', 'r', 'i', 0 },
		{ 's', 'a', 't', 0 }
	};
	static const sal_Unicode ppMonthID[12][4] =
	{
		{ 'j', 'a', 'n', 0 },
		{ 'f', 'e', 'b', 0 },
		{ 'm', 'a', 'r', 0 },
		{ 'a', 'p', 'r', 0 },
		{ 'm', 'a', 'y', 0 },
		{ 'j', 'u', 'n', 0 },
		{ 'j', 'u', 'l', 0 },
		{ 'a', 'u', 'g', 0 },
		{ 's', 'e', 'p', 0 },
		{ 'o', 'c', 't', 0 },
		{ 'n', 'o', 'v', 0 },
		{ 'd', 'e', 'c', 0 }
	};
	setupInternational( rLocale );
	::com::sun::star::uno::Sequence< Calendar > aSeq(1);
	sal_Int32 j;
	::com::sun::star::uno::Sequence< CalendarItem > aDays(7);
	for ( j=0; j<7; j++ )
	{
		sal_Int32 i = (j+1) % 7;		// map Monday(0) to Sunday(0)
		aDays[i] = CalendarItem(
			ppDayID[i],									// strID
			pIntl->GetAbbrevDayText( DayOfWeek(j) ),	// strAbbrevName
			pIntl->GetDayText( DayOfWeek(j) )			// strFullName
			);
	}
	::com::sun::star::uno::Sequence< CalendarItem > aMonths(12);
	for ( j=0; j<12; j++ )
	{
		aMonths[j] = CalendarItem(
			ppMonthID[j],			   				// strID
			pIntl->GetAbbrevMonthText((USHORT)(j+1)),	// strAbbrevName
			pIntl->GetMonthText((USHORT)(j+1))			// strFullName
			);
	}
	::com::sun::star::uno::Sequence< CalendarItem > aEras(2);
	// International doesn't know anything about eras
	aEras[0] = CalendarItem(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "bc" ) ),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "BC" ) ),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "BC" ) )
		);
	aEras[1] = CalendarItem(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ad" ) ),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AD" ) ),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "AD" ) )
		);
	aSeq[0] = Calendar(
		aDays,								// sequenceDays
		aMonths,							// sequenceMonths
		aEras,								// sequenceEras
		ppDayID[ (pIntl->GetWeekStart()+1) % 7 ],	// strStartOfWeekDay, map Monday(0) to Sunday(0)
		4,		// !International			// shortMinimalDaysInFirstWeek
		sal_True,							// boolDefaultCalendar
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "gregorian" ) )		// strCalendarID
		);
	return aSeq;
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Currency > SAL_CALL
LocaleData::getAllCurrencies( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	setupInternational( rLocale );
	String aEmpty;
	::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Currency > aSeq(1);
	aSeq[0] = ::com::sun::star::i18n::Currency(
        aEmpty,                         // string ID (International doesn't have any)
        pIntl->GetCurrSymbol(),         // string Symbol
        pIntl->GetCurrBankSymbol(),     // string BankSymbol
        aEmpty,                         // string Name (International doesn't have any)
        sal_True,                       // bool Default (always the only one)
        sal_True,                       // bool UsedInCompatibleFormatCodes (always)
        pIntl->GetCurrDigits()          // short DecimalPlaces
		);
	return aSeq;
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > SAL_CALL
LocaleData::getAllFormats( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	setupInternational( rLocale );
	::com::sun::star::uno::Sequence< ::com::sun::star::i18n::FormatElement > aSeq( NF_INDEX_TABLE_ENTRIES );
	if ( !pFormats )
		pFormats = new LocaleDataFormats( pIntl );
	pFormats->getFormats( aSeq );
	return aSeq;
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Implementation > SAL_CALL
LocaleData::getCollatorImplementations( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//	setupInternational( rLocale );
#if 1
	// I18N localedata_... sets the count to zero for "normal" implementation
	::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Implementation > aSeq(0);
#else
	// if count should not be zero
	::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Implementation > aSeq(1);
	aSeq[0] = ::com::sun::star::i18n::Implementation(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "normal" ) ),	// strCollatorID
		sal_True													// boolDefaultCollator
		);
#endif
	return aSeq;
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
LocaleData::getTransliterations( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//	setupInternational( rLocale );
	::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq(3);
	aSeq[0] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "toUpper" ) );
	aSeq[1] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "toLower" ) );
	aSeq[2] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ignoreCase" ) );
	return aSeq;
}


::com::sun::star::i18n::LanguageCountryInfo SAL_CALL
LocaleData::getLanguageCountryInfo( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	// We could use the Locale directly, but this way we get what the
	// International really is.
	setupInternational( rLocale );
	String aLanguage, aCountry, aEmpty;
	ConvertLanguageToIsoNames( pIntl->GetLanguage(), aLanguage, aCountry );
	::com::sun::star::i18n::LanguageCountryInfo aInfo(
		aLanguage,		// strLangID
		aEmpty,			// strLangDefaultName
		aCountry,		// strCountryID
		aEmpty,			// strCountryDefaultName
		aEmpty			// strVariant
		);
	return aInfo;
}


::com::sun::star::i18n::ForbiddenCharacters SAL_CALL
LocaleData::getForbiddenCharacters( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
	// we don't have any
	return ::com::sun::star::i18n::ForbiddenCharacters();
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
LocaleData::getReservedWord( const ::com::sun::star::lang::Locale& rLocale  ) throw(::com::sun::star::uno::RuntimeException)
{
	setupInternational( rLocale );
	::com::sun::star::uno::Sequence< ::rtl::OUString > aSeq( reservedWords::COUNT );
    String aQuarterWord( LocaleDataFormats::GetQuarterWord( pIntl->GetLanguage() ) );
    String aQ( RTL_CONSTASCII_USTRINGPARAM( "1. " ) );
    String aQuarter;
	const sal_Unicode *pTrue, *pFalse;
	LocaleDataFormats::GetLogicalKeywords( pIntl->GetLanguage(), pTrue, pFalse );
	aSeq[ reservedWords::TRUE_WORD ] = pTrue;
	aSeq[ reservedWords::FALSE_WORD ] = pFalse;
    aQuarter = aQ;
    aQuarter.SetChar( 0, '1' );
    aQuarter += aQuarterWord;
    aSeq[ reservedWords::QUARTER1_WORD ] = aQuarter;
    aQuarter = aQ;
    aQuarter.SetChar( 0, '2' );
    aQuarter += aQuarterWord;
    aSeq[ reservedWords::QUARTER2_WORD ] = aQuarter;
    aQuarter = aQ;
    aQuarter.SetChar( 0, '3' );
    aQuarter += aQuarterWord;
    aSeq[ reservedWords::QUARTER3_WORD ] = aQuarter;
    aQuarter = aQ;
    aQuarter.SetChar( 0, '4' );
    aQuarter += aQuarterWord;
    aSeq[ reservedWords::QUARTER4_WORD ] = aQuarter;
    aSeq[ reservedWords::ABOVE_WORD ] = ::rtl::OUString::createFromAscii( "above" );
    aSeq[ reservedWords::BELOW_WORD ] = ::rtl::OUString::createFromAscii( "below" );
	return aSeq;
 }


::com::sun::star::uno::Sequence< com::sun::star::lang::Locale > SAL_CALL
LocaleData::getAllInstalledLocaleNames() throw(::com::sun::star::uno::RuntimeException)
{
	USHORT n = International::GetAvailableFormatCount();
	::com::sun::star::uno::Sequence< com::sun::star::lang::Locale > aSeq( n );
	sal_Int32 nInstalled = 0;
	for ( USHORT j = 0; j < n; j++ )
	{
		LanguageType eLang = International::GetAvailableFormat( j );
		if ( eLang != LANGUAGE_SYSTEM )
		{
			String aLanguage, aCountry;
			ConvertLanguageToIsoNames( eLang, aLanguage, aCountry );
			aSeq[nInstalled].Language = aLanguage;
			aSeq[nInstalled].Country = aCountry;
			nInstalled++;
		}
	}
	if ( nInstalled < n )
		aSeq.realloc( nInstalled );
	return aSeq;
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
LocaleData::getSearchOptions( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//!!!!!!
//!TODO: implementation
//!!!!!!
	return ::com::sun::star::uno::Sequence< ::rtl::OUString > (0);
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
LocaleData::getCollationOptions( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//!!!!!!
//!TODO: implementation
//!!!!!!
	return ::com::sun::star::uno::Sequence< ::rtl::OUString > (0);
}

::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > > SAL_CALL
LocaleData::getContinuousNumberingLevels( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//!!!!!!
//!TODO: implementation
//!!!!!!
	return ::com::sun::star::uno::Sequence<
		::com::sun::star::uno::Sequence<
		::com::sun::star::beans::PropertyValue > > (0);
}


::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::container::XIndexAccess > > SAL_CALL
LocaleData::getOutlineNumberingLevels( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
//!!!!!!
//!TODO: implementation
//!!!!!!
	return ::com::sun::star::uno::Sequence<
		::com::sun::star::uno::Reference<
		::com::sun::star::container::XIndexAccess > > (0);
}
