/*************************************************************************
 *
 *  $RCSfile: breakiterator.cxx,v $
 *
 *  $Revision: 1.16.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/04/12 11:16:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define I18N_CHARACTERCLASSIFICATION_USES_CLASS_INTERNATIONAL

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef _I18N_BREAKITERATOR_HXX_
#include <breakiterator.hxx>
#endif

#include <string.h>

using namespace ::com::sun::star::i18n;

//	----------------------------------------------------
//	class BreakIterator
//	----------------------------------------------------

#define DELIMITER				1
#define BLANK 					2
#define NODELIMITERANDBLANK		3

#define IsLower( c )	( 0 != (pIntl->GetCharType( c ) & \
			(INTN_CHAR_LOWER /*| INTN_CHAR_NUMERIC | INTN_CHAR_ALPHA*/)))


int ChkChar( const String& rS, xub_StrLen nPos, BOOL bIsDictWord )
{
	static const char pDelimChars[] =
				"!\"#$%&()*+,-/:;<=>?[]\\_^`{|}~\t \x0a\x0d\x0ab\x0bb";
	int nRet;
	sal_Unicode c;
	switch( c = rS.GetChar( nPos ) )
	{
	case 0x20:	nRet = BLANK; break;
				//  check if ' is in a word, not at the end
	case 0x2018:
	case 0x2019:
	case 0x201b:
	case 0x27:  nRet = ( bIsDictWord && nPos && nPos + 1 < rS.Len() &&
				   NODELIMITERANDBLANK	== ChkChar( rS, nPos+1, FALSE ) &&
				   NODELIMITERANDBLANK	== ChkChar( rS, nPos-1, FALSE ))
					? NODELIMITERANDBLANK : DELIMITER;
				break;
	case '.':  nRet = ( bIsDictWord && nPos &&
				   NODELIMITERANDBLANK	== ChkChar( rS, nPos-1, bIsDictWord ))
					? NODELIMITERANDBLANK : DELIMITER;
				break;

	case 0x201c:
	case 0x201d:
	case 0x201e:
	case 0x201f:
		nRet = DELIMITER;
		break;
	case 0xA0:	                        // non breaking space
		nRet = bIsDictWord ? DELIMITER : NODELIMITERANDBLANK;
		break;
	default:
		if( 0xff > c && 0 != strchr( pDelimChars, c ))
			nRet = DELIMITER;
		else
			nRet = NODELIMITERANDBLANK;
	}
	return nRet;
}

int LB_IsSpaceChar( const sal_Unicode c )
{
	static const char* pSpaceChars = " \x0a\x0d\x01";
	return c <= ' ' && 0 != strchr( pSpaceChars, c );
}

xub_StrLen LnBrk_GetSttWord( const String& rStr, xub_StrLen nPos )
{
	xub_StrLen nStt = nPos;
	for( ; nPos; --nPos )
	{
		sal_Unicode c = rStr.GetChar( nPos );
		if( LB_IsSpaceChar( c ))
			return nPos + 1;
		if( '-' == c && nPos && nPos != nStt && nPos + 1 < rStr.Len() &&
			!LB_IsSpaceChar( rStr.GetChar( nPos-1 )) &&
			!LB_IsSpaceChar( rStr.GetChar( nPos+1 )) )
			return nPos + 1;
	 }
	 return nPos;
}

BreakIterator::BreakIterator()
	: pIntl( 0 )
{
}

BreakIterator::~BreakIterator()
{
	delete pIntl;
}

void BreakIterator::setupInternational(
						const ::com::sun::star::lang::Locale& rLocale )
{
	LanguageType eLang = ConvertIsoNamesToLanguage( rLocale.Language,
													rLocale.Country );
	if ( !pIntl )
		pIntl = new International( eLang );
	else if( eLang != pIntl->GetLanguage() )
	{
		delete pIntl;
		pIntl = new International( eLang );
	}
}

sal_Int32 BreakIterator::nextCharacters( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale &rLocale,
		sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, sal_Int32& rDone )
							throw( ::com::sun::star::uno::RuntimeException)
{
	String sStr( rText);
	if( ( nStartPos + nCount ) < sStr.Len() )
		rDone = nCount;
	else
		rDone = sStr.Len() - nStartPos;
	return nStartPos + rDone;
}

sal_Int32 BreakIterator::previousCharacters( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, sal_Int32& rDone )
								throw( ::com::sun::star::uno::RuntimeException)
{
	if( nStartPos > nCount )
		rDone = nCount;
	else
		rDone = nStartPos;
	return nStartPos - rDone;
}

::com::sun::star::i18n::Boundary SAL_CALL BreakIterator::nextWord(
		const ::rtl::OUString& rText, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 nWordType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	String sStr( rText);
	::com::sun::star::i18n::Boundary aResult;
	aResult.startPos = aResult.endPos = nStartPos;

	sal_Bool bOk = TRUE;
	switch( nWordType )
	{
	case WordType::ANY_WORD:
	case WordType::ANYWORD_IGNOREWHITESPACES:
    	if( nStartPos+1 >= sStr.Len() )
        	bOk = FALSE;
		else
		{
    		int nFnd, nSttChar = ChkChar( sStr, nStartPos, FALSE );
    		while( nSttChar == ( nFnd = ChkChar( sStr, ++nStartPos, FALSE )))
        		if( nStartPos == sStr.Len() )
				{
					bOk = FALSE;
            		break;
				}
			if( bOk )
			{
				if( BLANK == nFnd &&
					nWordType == WordType::ANYWORD_IGNOREWHITESPACES )
					while( nStartPos < sStr.Len() && BLANK ==
						( nFnd = ChkChar( sStr, ++nStartPos, FALSE) ) )
						;

				aResult.startPos = aResult.endPos = nStartPos;
    			while( aResult.endPos < sStr.Len() &&
					nFnd == ChkChar( sStr, ++aResult.endPos, FALSE ))
						;
			}
		}
		break;

	case WordType::DICTIONARY_WORD:
		while( nStartPos < sStr.Len() &&
				NODELIMITERANDBLANK == ChkChar( sStr, nStartPos, TRUE ))
			++nStartPos;
		while( nStartPos < sStr.Len() &&
				NODELIMITERANDBLANK != ChkChar( sStr, nStartPos, TRUE ))
			++nStartPos;
		if( nStartPos < sStr.Len() )
		{
			aResult.startPos = nStartPos++;
   			while( nStartPos < sStr.Len() && NODELIMITERANDBLANK
					== ChkChar( sStr, nStartPos, TRUE ))
				++nStartPos;
			aResult.endPos = nStartPos;
		}
		else
			bOk = FALSE;
		break;
	}
	if( !bOk )
		aResult.startPos = aResult.endPos = sStr.Len();
	return aResult;
}

::com::sun::star::i18n::Boundary SAL_CALL BreakIterator::previousWord(
		const ::rtl::OUString& rText, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 nWordType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	String sStr( rText);
	::com::sun::star::i18n::Boundary aResult;
	aResult.startPos = aResult.endPos = nStartPos;

	sal_Bool bOk = TRUE;
	switch( nWordType )
	{
	case WordType::ANY_WORD:
	case WordType::ANYWORD_IGNOREWHITESPACES:
    	if( !nStartPos-- )
        	bOk = FALSE;
		else
		{
    		int nSttChar = ChkChar( sStr, nStartPos, FALSE );

			if( BLANK == nSttChar &&
				nWordType == WordType::ANYWORD_IGNOREWHITESPACES )
			{
				while( nStartPos && BLANK == ( nSttChar =
						ChkChar( sStr, --nStartPos, FALSE )))
					;
				if( !nStartPos && BLANK == nSttChar )
					bOk = FALSE;
			}

    		while( nStartPos && nSttChar == ChkChar(
										sStr, nStartPos-1, FALSE ))
				--nStartPos;

			aResult.startPos = aResult.endPos = nStartPos;
   			while( aResult.endPos < sStr.Len() &&
				nSttChar == ChkChar( sStr, aResult.endPos, FALSE ))
				++aResult.endPos;
		}
		break;

	case WordType::DICTIONARY_WORD:
		{
			int nSttChar;
			while( nStartPos && NODELIMITERANDBLANK !=
				( nSttChar = ChkChar( sStr, --nStartPos, TRUE )))
						;
			if( NODELIMITERANDBLANK == nSttChar )
			{
	   			while( nStartPos && NODELIMITERANDBLANK
						== ChkChar( sStr, nStartPos-1, TRUE ))
					--nStartPos;
				aResult.startPos = aResult.endPos = nStartPos;
	   			while( aResult.endPos < sStr.Len() &&
						NODELIMITERANDBLANK == ChkChar(
								sStr, aResult.endPos, TRUE ))
					++aResult.endPos;
			}
			else
				bOk = FALSE;
		}
		break;
	}
	if( !bOk )
		aResult.startPos = aResult.endPos = sStr.Len();
	return aResult;
}


::com::sun::star::i18n::Boundary SAL_CALL BreakIterator::getWordBoundary(
		const ::rtl::OUString& rText, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale, sal_Int16 nWordType,
		sal_Bool bDir ) 		throw( ::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::i18n::Boundary aResult;

	BOOL bIsDictWord = WordType::DICTIONARY_WORD == nWordType;
	String sStr( rText );

	BOOL bCalcStart = TRUE, bCalcEnd = TRUE;
	if( isEndWord( rText, nStartPos, nLocale, nWordType ) ||
		isBeginWord( rText, nStartPos, nLocale, nWordType ) )
	{
		if( bDir || !nStartPos )
		{
			bCalcStart = FALSE;
			aResult.startPos = nStartPos;
		}
		else if( !bDir )
		{
			bCalcEnd = FALSE;
			aResult.endPos = nStartPos--;
		}
	}
	else if( nStartPos <= 0 )
	{
		bCalcStart = FALSE;
		aResult.startPos = nStartPos =  0;
	}
	else if( nStartPos >= sStr.Len() )
	{
		bCalcStart = FALSE;
		aResult.endPos = nStartPos = sStr.Len();
	}

	if( bCalcStart )
	{
		int nSttChar = ChkChar( sStr, nStartPos, bIsDictWord);
		while( nStartPos &&
				nSttChar == ChkChar( sStr, nStartPos - 1, bIsDictWord) )
			--nStartPos;
		aResult.startPos = nStartPos;
	}

	if( bCalcEnd )
	{
		int nSttChar = ChkChar( sStr, nStartPos, bIsDictWord);
		while( nStartPos < sStr.Len() &&
			nSttChar == ChkChar( sStr, ++nStartPos, bIsDictWord) )
			;
		aResult.endPos = nStartPos;
	}

	return aResult;
}

sal_Int16 SAL_CALL BreakIterator::getWordType( const ::rtl::OUString& rText,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale )
								throw( ::com::sun::star::uno::RuntimeException)
{
//!!!!!!!!!!!!!!!!!!!!!!!
// must be implemented !!
//!!!!!!!!!!!!!!!!!!!!!!!
	return 0;

	String sStr( rText );
	short nRet;
	if( BLANK == ChkChar( sStr, nPos, FALSE ))
		nRet = WordType::ANYWORD_IGNOREWHITESPACES;
	else
	{
		// how can i find out, which is a alphanumeric character?
		// ?????????
		nRet = WordType::ANY_WORD;
		// ?????????
		// nRet = WordType::DICTIONARY_WORD;
	}
	return nRet;
}


sal_Int32 BreakIterator::beginOfSentence( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale &rLocale )
								throw( ::com::sun::star::uno::RuntimeException)
{
	String sStr( rText );
	while( nStartPos )
		switch ( sStr.GetChar( --nStartPos ))
		{
		case ';':
        case '.':
        case ':':
        case '!':
        case '?':
			while( nStartPos < sStr.Len() &&
					0x20 == sStr.GetChar( nStartPos + 1 ))
				++nStartPos;
			return nStartPos;
		}
	return 0;
}

sal_Int32 BreakIterator::endOfSentence( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale &rLocale )
								throw( ::com::sun::star::uno::RuntimeException)
{
	String sStr( rText );
	for( ++nStartPos; nStartPos < sStr.Len(); ++nStartPos )
		switch ( sStr.GetChar( nStartPos ))
		{
		case ';':
        case '.':
        case ':':
        case '!':
        case '?':
			while( nStartPos && 0x20 == sStr.GetChar( nStartPos - 1 ))
				--nStartPos;
			return nStartPos;
		}
	return 0;
}

::com::sun::star::i18n::LineBreakResults SAL_CALL BreakIterator::getLineBreak(
		const ::rtl::OUString& rText, sal_Int32 nStartPos,
		const ::com::sun::star::lang::Locale& nLocale,
		sal_Int32 nMinBreakPos,
		const ::com::sun::star::i18n::LineBreakHyphenationOptions& rHOptions,
		const ::com::sun::star::i18n::LineBreakUserOptions& bOptions )
								throw( ::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::i18n::LineBreakResults aResult;

	aResult.breakIndex = nStartPos;
	aResult.breakType = ::com::sun::star::i18n::BreakType::WORDBOUNDARY;

	String sStr( rText );
	xub_StrLen nWrdSttPos = ::LnBrk_GetSttWord( sStr, nStartPos );
	if( nWrdSttPos != nStartPos )
	{
		nStartPos = aResult.breakIndex = nWrdSttPos;

		if( rHOptions.rHyphenator.is() )
		{
			::com::sun::star::i18n::Boundary aWBoundary = getWordBoundary(
				sStr, nStartPos, nLocale,
				com::sun::star::i18n::WordType::ANYWORD_IGNOREWHITESPACES,
				true );

			String sWord( sStr.Copy( aWBoundary.startPos,
								aWBoundary.endPos - aWBoundary.startPos ));
			short nMaxLeading = rHOptions.hyphenIndex - nStartPos;

			::com::sun::star::uno::Reference<
				::com::sun::star::linguistic2::XHyphenatedWord > xHyphWord =
				rHOptions.rHyphenator->hyphenate( sWord, nLocale, nMaxLeading,
												  rHOptions.aHyphenationOptions );
			if( xHyphWord.is() )
			{
				aResult.rHyphenatedWord = xHyphWord;
				if( nStartPos + xHyphWord->getHyphenationPos() < nMinBreakPos )
					aResult.breakIndex = -1;
				else
					aResult.breakIndex = nStartPos;
				aResult.breakType = ::com::sun::star::i18n::BreakType::HYPHENATION;
			}
		}
	}
	return aResult;
}

sal_Bool SAL_CALL BreakIterator::isBeginWord( const ::rtl::OUString& rText,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 nWordType )	throw( ::com::sun::star::uno::RuntimeException)
{
	sal_Bool bRet = FALSE;
	String sStr( rText );
	if( !nPos )
	{
		bRet = WordType::ANY_WORD == nWordType ||
				BLANK != ChkChar( sStr, nPos, FALSE );
	}
	else
	{
		BOOL bIsDictWord = WordType::DICTIONARY_WORD == nWordType;
		int nCurChr = ChkChar( sStr, nPos, bIsDictWord),
			nPrvChr = ChkChar( sStr, --nPos, bIsDictWord);
		switch ( nWordType )
		{
		case WordType::ANY_WORD:
//			bRet = nCurChr != nPrvChr;
//			break;

		case WordType::ANYWORD_IGNOREWHITESPACES:
//			bRet = BLANK != nCurChr && nCurChr != nPrvChr;
//			break;

		case WordType::DICTIONARY_WORD:
			bRet = NODELIMITERANDBLANK == nCurChr &&
					NODELIMITERANDBLANK != nPrvChr;
			break;
		}
	}
	return bRet;
}

sal_Bool SAL_CALL BreakIterator::isEndWord( const ::rtl::OUString& rText,
		sal_Int32 nPos, const ::com::sun::star::lang::Locale& nLocale,
		sal_Int16 nWordType ) 	throw( ::com::sun::star::uno::RuntimeException)
{
	sal_Bool bRet = FALSE;
	String sStr( rText );
	if( sStr.Len() && nPos )
	{
		BOOL bIsDictWord = WordType::DICTIONARY_WORD == nWordType;
		int nCurChr = ChkChar( sStr, nPos, bIsDictWord),
			nPrvChr = ChkChar( sStr, --nPos, bIsDictWord);
		switch ( nWordType )
		{
		case WordType::ANY_WORD:
//			bRet = nCurChr != nPrvChr;
//			break;

		case WordType::ANYWORD_IGNOREWHITESPACES:
//			bRet = BLANK != nCurChr && nCurChr != nPrvChr;
//			break;

		case WordType::DICTIONARY_WORD:
			bRet = NODELIMITERANDBLANK != nCurChr &&
					NODELIMITERANDBLANK == nPrvChr;
			break;
		}
	}
	return bRet;
}

sal_Int32 BreakIterator::beginOfScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	return -1;
}

sal_Int32 BreakIterator::endOfScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	return -1;
}

sal_Int32  BreakIterator::previousScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	return -1;
}

sal_Int32 BreakIterator::nextScript( const ::rtl::OUString& Text,
		sal_Int32 nStartPos, sal_Int16 ScriptType )
								throw( ::com::sun::star::uno::RuntimeException)
{
	return -1;
}

sal_Int16 BreakIterator::getScriptType( const ::rtl::OUString& Text,
		sal_Int32 nPos ) 		throw( ::com::sun::star::uno::RuntimeException)
{
	return ScriptType::LATIN;
}

sal_Int32 BreakIterator::beginOfCharBlock( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharType ) throw( ::com::sun::star::uno::RuntimeException )
{
	sal_Int32 nRet = -1;
	if( nCharType == ::com::sun::star::i18n::CharType::LOWERCASE_LETTER )
	{
		String myStr( rText );
		setupInternational( rLocale );
		if( IsLower( myStr.GetChar( nStartPos ) ))
		{
			while( nStartPos-- > 0 &&
					IsLower( myStr.GetChar( nStartPos ) ) )
				;
			nRet = nStartPos + 1; // begin of char block is inclusive
		}
	}
	return nRet;
}

sal_Int32 BreakIterator::endOfCharBlock( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharType ) throw( ::com::sun::star::uno::RuntimeException )
{
	sal_Int32 nRet = -1;
	if( nCharType == ::com::sun::star::i18n::CharType::LOWERCASE_LETTER)
	{
		String myStr( rText );
		setupInternational( rLocale );
		if( IsLower( myStr.GetChar( nStartPos ) ))
		{
			sal_Int32 nLen = myStr.Len();
			while( nStartPos++ < nLen &&
					IsLower( myStr.GetChar( nStartPos ) ) )
				;
			nRet = nStartPos; // end of char block is exclusive
		}
	}
	return nRet;
}

sal_Int32 BreakIterator::nextCharBlock( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharType ) throw( ::com::sun::star::uno::RuntimeException )
{
	sal_Int32 nRet = -1;
	if( nCharType == ::com::sun::star::i18n::CharType::LOWERCASE_LETTER)
	{
		String myStr( rText );
		setupInternational( rLocale );
		sal_Int32 nLen = myStr.Len();
		if( IsLower( myStr.GetChar( nStartPos ) ))
			nStartPos = endOfCharBlock( rText, nStartPos, rLocale, nCharType);

		while( nStartPos++ < nLen &&
				!IsLower( myStr.GetChar( nStartPos ) ) )
			;
		if( nStartPos < nLen )
			nRet = nStartPos; // end of char block is exclusive
	}
	return nRet;
}

sal_Int32 BreakIterator::previousCharBlock( const ::rtl::OUString& rText,
		sal_Int32 nStartPos, const ::com::sun::star::lang::Locale& rLocale,
		sal_Int16 nCharType ) throw( ::com::sun::star::uno::RuntimeException)
{
	sal_Int32 nRet = -1;
	if( nCharType == ::com::sun::star::i18n::CharType::LOWERCASE_LETTER) {
		String myStr( rText ); setupInternational( rLocale ); sal_Int32 nLen
		= myStr.Len();
#if 0
		if( IsLower( myStr.GetChar( nStartPos ) ))
			nStartPos = beginOfCharBlock( rText, nStartPos, rLocale, nCharType);

		while( nStartPos-- > 0 &&
				!IsLower( myStr.GetChar( nStartPos ) ) )
			;
		if( 0 <= nStartPos )
			nRet = nStartPos + 1; // end of char block is exclusive
#else
		if( IsLower( myStr.GetChar( nStartPos ) ) &&
			0 == ( nStartPos = beginOfCharBlock( rText, nStartPos, rLocale, nCharType)))
				return -1;

		nStartPos--;

		while( nStartPos-- > 0 &&
				!IsLower( myStr.GetChar( nStartPos ) ) )
			;
		if( IsLower( myStr.GetChar( nStartPos + 1 ) ) )
			nRet = nStartPos + 1; // end of char block is exclusive
#endif
	}
	return nRet;
}


