/*************************************************************************
 *
 *  $RCSfile: collator_CJK.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: bustamam $ $Date: 2001/12/15 13:38:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _I18N_COLLATOR_CJK_HXX_
#define _I18N_COLLATOR_CJK_HXX_

#include <collator.hxx>

//	----------------------------------------------------
//	class Collator_CJK
//	----------------------------------------------------

class Collator_CJK : public Collator {
public:
	Collator_CJK (
		const ::com::sun::star::uno::Reference <
		    ::com::sun::star::lang::XMultiServiceFactory >& xMSF)
			: Collator( xMSF ) {
		implementationName = "com.sun.star.i18n.Collator_CJK";
	};
	~Collator_CJK () {};

	virtual sal_Int32 SAL_CALL compare(
			const ::rtl::OUString& s1, sal_Int32 off1, sal_Int32 len1,
			const ::rtl::OUString& s2, sal_Int32 off2, sal_Int32 len2,
			const sal_uInt16 index[],
			const sal_uInt16 weight[])
			throw(::com::sun::star::uno::RuntimeException);

};

#define COLLATOR_CJK( algorithm ) \
class Collator_##algorithm : public Collator_CJK {\
public:\
	Collator_##algorithm (\
		const ::com::sun::star::uno::Reference <\
		    ::com::sun::star::lang::XMultiServiceFactory >& xMSF)\
			: Collator_CJK( xMSF ) {\
		implementationName = "com.sun.star.i18n.Collator_##algorithm";\
	};\
	~Collator_##algorithm () {};\
\
	virtual sal_Int32 SAL_CALL compareString(\
			const ::rtl::OUString& s1,\
			const ::rtl::OUString& s2)\
			throw (::com::sun::star::uno::RuntimeException);\
\
	virtual sal_Int32 SAL_CALL compareSubstring(\
			const ::rtl::OUString& s1, sal_Int32 off1, sal_Int32 len1,\
			const ::rtl::OUString& s2, sal_Int32 off2, sal_Int32 len2)\
			throw(::com::sun::star::uno::RuntimeException);\
};

COLLATOR_CJK( zh_CN_pinyin )
COLLATOR_CJK( zh_CN_radical )
COLLATOR_CJK( zh_CN_stroke )
COLLATOR_CJK( zh_CN_charset )
COLLATOR_CJK( zh_TW_zhuyin )
COLLATOR_CJK( zh_TW_radical )
COLLATOR_CJK( zh_TW_stroke )
COLLATOR_CJK( zh_TW_charset )
COLLATOR_CJK( ko_KR_dict )
COLLATOR_CJK( ko_KR_charset )
COLLATOR_CJK( ja_JP_charset )

#endif
