/*************************************************************************
 *
 *  $RCSfile: b2dmbmp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_MBMP_HXX
#include "b2dmbmp.hxx"
#endif

//************************************************************
//   InterActionObjectBitmap
//************************************************************

TYPEINIT1(B2dIAOBitmapObj, B2dIAObject);

B2dIAOBitmapObj::B2dIAOBitmapObj(B2dIAOManager* pMan, Point aPos, 
	const Bitmap& rBmp, UINT16 nCenX, UINT16 nCenY, BOOL bUTCol, Color aTransCol)
:	B2dIAObject(pMan, aPos, aTransCol),
	bUseTransCol(bUTCol),
	aBmp(rBmp),
	nCenterX(nCenX),
	nCenterY(nCenY)
{
}

B2dIAOBitmapObj::~B2dIAOBitmapObj() 
{
}

void B2dIAOBitmapObj::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());
		aUpperLeft.X() -= (INT32)nCenterX;
		aUpperLeft.Y() -= (INT32)nCenterY;

		if(bUseTransCol)
		{
			BitmapEx aBmpEx(aBmp, GetBaseColor());
			AddBitmap(aUpperLeft, aBmpEx);
		}
		else
		{
			BitmapEx aBmpEx(aBmp);
			AddBitmap(aUpperLeft, aBmpEx);
		}
	}
}

void B2dIAOBitmapObj::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());
	aUpperLeft.X() -= (INT32)nCenterX;
	aUpperLeft.Y() -= (INT32)nCenterY;
	SetBaseRect(Rectangle(aUpperLeft, aBmp.GetSizePixel()));
}

void B2dIAOBitmapObj::SetBitmap(const Bitmap& rNew)
{
	if(rNew != aBmp)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new Bitmap
		aBmp = rNew;
	}
}

void B2dIAOBitmapObj::SetTransparenceUsed(BOOL bNew)
{
	if(bNew != bUseTransCol)
	{
		// throw away geometry
		GeometryChange(); 

		// remember new value
		bUseTransCol = bNew;
	}
}

void B2dIAOBitmapObj::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX || nNewY != nCenterY)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX)
			nCenterX = nNewX;
		if(nNewY != nCenterY)
			nCenterY = nNewY;
	}
}

//************************************************************
//   InterActionObjectBitmapEx
//************************************************************

TYPEINIT1(B2dIAOBitmapEx, B2dIAObject);

B2dIAOBitmapEx::B2dIAOBitmapEx(B2dIAOManager* pMan, Point aPos, const BitmapEx& rBmpEx,
	UINT16 nCenX, UINT16 nCenY)
:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN)),
	aBmpEx(rBmpEx),
	nCenterX(nCenX),
	nCenterY(nCenY)
{
}

B2dIAOBitmapEx::~B2dIAOBitmapEx() 
{
}

void B2dIAOBitmapEx::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());
		aUpperLeft.X() -= (INT32)nCenterX;
		aUpperLeft.Y() -= (INT32)nCenterY;
		AddBitmap(aUpperLeft, aBmpEx);
	}
}

void B2dIAOBitmapEx::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());
	aUpperLeft.X() -= (INT32)nCenterX;
	aUpperLeft.Y() -= (INT32)nCenterY;
	SetBaseRect(Rectangle(aUpperLeft, aBmpEx.GetSizePixel()));
}

void B2dIAOBitmapEx::SetBitmapEx(const BitmapEx& rNew)
{
	if(rNew != aBmpEx)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new BitmapEx
		aBmpEx = rNew;
	}
}

void B2dIAOBitmapEx::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX || nNewY != nCenterY)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX)
			nCenterX = nNewX;
		if(nNewY != nCenterY)
			nCenterY = nNewY;
	}
}

//************************************************************
//   InterActionObjectBitmapExReference
//************************************************************

TYPEINIT1(B2dIAOBitmapExReference, B2dIAObject);

B2dIAOBitmapExReference::B2dIAOBitmapExReference(B2dIAOManager* pMan, Point aPos, BitmapEx* pBEx,
	UINT16 nCenX, UINT16 nCenY)
:	B2dIAObject(pMan, aPos, Color(COL_LIGHTGREEN)),
	pBmpEx(pBEx),
	nCenterX(nCenX),
	nCenterY(nCenY)
{
}

B2dIAOBitmapExReference::~B2dIAOBitmapExReference() 
{
}

void B2dIAOBitmapExReference::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));
	
	if(!aOverRegion.IsEmpty())
	{
		Point aUpperLeft(GetBasePositionPixel());
		aUpperLeft.X() -= (INT32)nCenterX;
		aUpperLeft.Y() -= (INT32)nCenterY;
		AddBmpRef(aUpperLeft, pBmpEx);
	}
}

void B2dIAOBitmapExReference::CreateBaseRect()
{
	Point aUpperLeft(GetBasePositionPixel());
	aUpperLeft.X() -= (INT32)nCenterX;
	aUpperLeft.Y() -= (INT32)nCenterY;
	SetBaseRect(Rectangle(aUpperLeft, pBmpEx->GetSizePixel()));
}

void B2dIAOBitmapExReference::SetBitmapEx(BitmapEx* pNew)
{
	if(*pNew != *pBmpEx)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new BitmapEx
		pBmpEx = pNew;
	}
}

void B2dIAOBitmapExReference::SetCenterXY(UINT16 nNewX, UINT16 nNewY)
{
	if(nNewX != nCenterX || nNewY != nCenterY)
	{
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// remember new values
		if(nNewX != nCenterX)
			nCenterX = nNewX;
		if(nNewY != nCenterY)
			nCenterY = nNewY;
	}
}


