/*************************************************************************
 *
 *  $RCSfile: opluginframedispatcher.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: as $ $Date: 2001/12/20 13:32:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_OPLUGINFRAMEDISPATCHER_HXX_
#include <helper/opluginframedispatcher.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_TARGETS_H_
#include <targets.h>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::beans			;
using namespace ::com::sun::star::frame			;
using namespace ::com::sun::star::io			;
using namespace ::com::sun::star::lang			;
using namespace ::com::sun::star::mozilla		;
using namespace ::com::sun::star::uno			;
using namespace ::com::sun::star::util			;
using namespace ::cppu							;
using namespace ::osl							;
using namespace ::rtl							;

struct DispatchArgs
{
    ::rtl::OUString             sURL;
    Sequence < PropertyValue >  aArgs;
};

static DispatchArgs* pLastDispatchArgs = 0;
static DispatchArgs* pDispatchArgs = 0;

void OPlugInFrameDispatcher::AddArguments( const Sequence< PropertyValue > & rArgs, const OUString& rURL )
{
    if ( pLastDispatchArgs && pDispatchArgs )
        delete pLastDispatchArgs;
    pLastDispatchArgs = pDispatchArgs;
    pDispatchArgs = new DispatchArgs;
    pDispatchArgs->sURL = rURL;
    pDispatchArgs->aArgs = rArgs;
}

const Sequence < PropertyValue >* OPlugInFrameDispatcher::GetArguments( const OUString& rURL )
{
    if ( pDispatchArgs && pDispatchArgs->sURL.equals( rURL ) )
        return &pDispatchArgs->aArgs;
    else if ( pLastDispatchArgs && pLastDispatchArgs->sURL.equals( rURL ) )
        return &pLastDispatchArgs->aArgs;
    else
        return NULL;
}

void OPlugInFrameDispatcher::RemoveArguments( const OUString& rURL )
{
    if ( pDispatchArgs && pDispatchArgs->sURL.equals( rURL ) )
    {
        delete pDispatchArgs;
        pDispatchArgs = 0;
    }
    else if ( pLastDispatchArgs && pLastDispatchArgs->sURL.equals( rURL ) )
    {
        delete pLastDispatchArgs;
        pLastDispatchArgs = 0;
    }
}

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
OPlugInFrameDispatcher::OPlugInFrameDispatcher(	const	Reference< XMultiServiceFactory >&		xFactory			,
												const	Reference< XPluginInstance >&			xOwner				,
												const	Reference< XPluginInstancePeer >&		xPlugInDLL			)
		//	Init baseclasses first
        :   ThreadHelpBase      ( &Application::GetSolarMutex() )
        ,   OWeakObject         (                               )
        // Init member
        ,   m_xFactory          ( xFactory                      )
        ,   m_xOwnerWeak        ( xOwner                        )
        ,   m_xPlugInDLL        ( xPlugInDLL                    )
        ,   m_aListenerContainer( m_aLock.getShareableOslMutex())
{
	// Safe impossible cases.
	// These object need valid information for working.
    LOG_ASSERT( impldbg_checkParameter_OPlugInFrameDispatcherCtor( xFactory, xOwner, xPlugInDLL ), "OPlugInFrameDispatcher::OPlugInFrameDispatcher()\nInvalid parameter detected!\n" )
}

//*****************************************************************************************************************
//	destructor (protected!)
//*****************************************************************************************************************
OPlugInFrameDispatcher::~OPlugInFrameDispatcher()
{
}

//*****************************************************************************************************************
//	XInterface
//*****************************************************************************************************************

DEFINE_XINTERFACE_3		(	OPlugInFrameDispatcher						,
							OWeakObject				  					,
							DIRECT_INTERFACE(XDispatchProvider			),
							DIRECT_INTERFACE(XDispatch					),
							DIRECT_INTERFACE(XPluginInstanceNotifySink	)
						)

//*****************************************************************************************************************
//	XDispatchProvider
//*****************************************************************************************************************
Reference< XDispatch > SAL_CALL OPlugInFrameDispatcher::queryDispatch(	const	URL&		aURL				,
			  															const	OUString&	sTargetFrameName	,
																				sal_Int32	nSearchFlags		) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter
	LOG_ASSERT( impldbg_checkParameter_queryDispatch( aURL, sTargetFrameName, nSearchFlags ), "OPlugInFrameDispatcher::queryDispatch()\nInvalid parameter detected!\n" )

	// Set default return value.
	Reference< XDispatch > xReturn;
	// We need information from ouer ownerframe!
	// Try to get a "lock" to ouer owner-frame.
	Reference< XFrame > xOwnerFrame( m_xOwnerWeak.get(), UNO_QUERY );

	// We must forward _blank, _self to browser.
	// All other requests we can handle by our baseclass implementation. (Task,Frame)
	// see PlugInFrame::queryDispatch() too for further informations!

	// a)
	// Forward to browser if follow cases occure:
	//		- new frame (plugged into a browser window) is required for "_blank"
	//		- dispatch has THIS frame as target ("_self", "" or Flag::SELF && name=<target>)

	// b)
	// There exist another case! ... Using of Flag::CREATE
	// If searched target not already exist and must be created => forward it to browser to get new window!
	// If searched frame exist => ignore flag and dispatch it internal!

	if	(
            ( nSearchFlags&FrameSearchFlag::CREATE    )   &&
            ( nSearchFlags&FrameSearchFlag::TASKS     )   &&
            ( sTargetFrameName!=SPECIALTARGET_BLANK   )   &&
            ( sTargetFrameName!=SPECIALTARGET_DEFAULT )
		)
	{
		sal_Int32 nTempFlags = nSearchFlags;
		nTempFlags&= ~FrameSearchFlag::CREATE;
		Reference< XDispatchProvider > xTarget( xOwnerFrame->findFrame( sTargetFrameName, nTempFlags ), UNO_QUERY );
		if( xTarget.is()==sal_True && xTarget!=xOwnerFrame )
		{
            xReturn = xTarget->queryDispatch( aURL, SPECIALTARGET_SELF, 0 );
		}
		else if( xTarget.is() == sal_False )
		{
            m_sTargetFrameName = sTargetFrameName;
            xReturn = Reference< XDispatch >( (OWeakObject*)this, UNO_QUERY );
		}
	}

	if	(
			( xReturn.is() == sal_False ) &&
			(
                ( sTargetFrameName             == SPECIALTARGET_BLANK   ) ||
                ( sTargetFrameName             == SPECIALTARGET_DEFAULT ) ||
                ( sTargetFrameName             == SPECIALTARGET_SELF    ) ||
                ( sTargetFrameName.getLength() <  1                     ) ||
				(
					( nSearchFlags&FrameSearchFlag::SELF )	&&
					( xOwnerFrame->getName()==sTargetFrameName 		 )
				)
			)
		)
	{
        if( xOwnerFrame.is() == sal_True )
        {
			// First ask controller! If URL an internal URL like "slot:..." or "macro:..."
			// He can dispatch it by himself. Otherwise we can forward it to browser!
            Reference< XDispatchProvider > xProvider( xOwnerFrame->getController(), UNO_QUERY );
            if( xProvider.is() == sal_True )
			{
                xReturn = xProvider->queryDispatch( aURL, sTargetFrameName, nSearchFlags );
			}
        }

		// If controller don't handle these dispatch ...
		// and URL-protocol isn't one of the follow ones ...
		// we should forward it to browser!
        OUString sTmp( aURL.Protocol );
        if	(
                ( xReturn.is()                       == sal_False ) &&
                ( sTmp.compareToAscii( ".uno"  , 4 ) != 0         ) &&
                ( sTmp.compareToAscii( "slot:" , 5 ) != 0         ) &&
                ( sTmp.compareToAscii( "macro:", 6 ) != 0         )
            )
        {
            // Don't forget to save current target frame name!
            // We need it, if a dispatch is called at this instance!
            m_sTargetFrameName = sTargetFrameName;
            xReturn = Reference< XDispatch >( (OWeakObject*)this, UNO_QUERY );
        }
	}

    // Return result of this operation.
	return xReturn;

}

//*****************************************************************************************************************
//	XDispatchProvider
//*****************************************************************************************************************
Sequence< Reference< XDispatch > > SAL_CALL OPlugInFrameDispatcher::queryDispatches( const Sequence< DispatchDescriptor >& seqDescripts ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter
	LOG_ASSERT( impldbg_checkParameter_queryDispatches( seqDescripts ), "OPlugInFrameDispatcher::queryDispatches()\nInvalid parameter detected!\n" )

	// Set default return value if no dispatcher will be found.
	Sequence< Reference< XDispatch > > seqDispatcher;

	// Get count of all given discriptors ...
	sal_Int32 nDescriptorCount = seqDescripts.getLength();
	if ( nDescriptorCount > 0 )
	{
		// ... to get enough memory for expected dispatcher.
		// We can't get more dispatcher as descriptors exist!
		Reference< XDispatch >*	pDispatcher	= new Reference< XDispatch >[nDescriptorCount];
		// We must count all getted dispatcher to create return sequence.
		// There can't be more but fewer dispatcher then given descriptors!
		sal_Int32				nDispatcher	= 0;
		// This is a helper variable to hold current returned dispatcher of query.
		Reference< XDispatch >	xDispatcher;

		// Step over all descriptors and try to get any dispatcher for it.
		for ( sal_Int32 nPosition=0; nPosition<nDescriptorCount; ++nPosition )
		{
			xDispatcher = queryDispatch(	seqDescripts[nPosition].FeatureURL	,
											seqDescripts[nPosition].FrameName	,
											seqDescripts[nPosition].SearchFlags	);
			// If any dispatcher for given parameters found ...
			if ( xDispatcher.is() == sal_True )
			{
				// ... safe it temporaly in "memory list" ...
				pDispatcher[nDispatcher] = xDispatcher;
				// ... and count of found dispatcher.
				++nDispatcher;
			}
		}

		// Safe impossible cases.
		// If we have more dispatcher then descriptors => we have a problem in algorithm!
		LOG_ASSERT( !(nDispatcher>nDescriptorCount), "OPlugInFrameDispatcher::queryDispatch()\nAlgorithm error. There are more dispatcher as reserved fields in memory!\n" )

		// Copy "memory list" to return sequence.
		seqDispatcher = Sequence< Reference< XDispatch > >( pDispatcher, nDispatcher );
	}

	// Return result of this operation.
	return seqDispatcher;
}

//*****************************************************************************************************************
//	XDispatch
//*****************************************************************************************************************
void SAL_CALL OPlugInFrameDispatcher::dispatch(	const	URL&						aURL		,
												const	Sequence< PropertyValue >&	seqArguments) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter
	LOG_ASSERT( impldbg_checkParameter_dispatch( aURL, seqArguments ), "OPlugInFrameDispatcher::dispatch()\nInvalid parameter detected!\n" )

	AddArguments( seqArguments, aURL.Main );

	// Set default parameter for latter call of postURL.
	Reference< XInputStream > xInputStream;

	// extract all possible arguments for forwarding to browser!
	ArgumentAnalyzer aAnalyzer( seqArguments );

	OUString					sReferrer		;
	Reference< XInputStream >	xPostData		;
	sal_Bool					bReferrerExist	;
	sal_Bool					bPostDataExist	;

	bReferrerExist	= aAnalyzer.getArgument( E_REFERRER, sReferrer );
	bPostDataExist	= aAnalyzer.getArgument( E_POSTDATA, xPostData );

	// We need a valid URL for forwarding to browser.
	if ( aURL.Complete.getLength() > 0 )
	{
		// Convert URL to praesentation URL!
		// It's neccessary for plugin dll and browser. He don't understand private URLs!
		// By the way - encode it!
		UniString sOriginalURL = aURL.Complete;
		UniString sPraesentationURL;
		INetURLObject::translateToExternal( sOriginalURL, sPraesentationURL, INetURLObject::WAS_ENCODED, INetURLObject::NO_DECODE );
		OUString sURL( sPraesentationURL );

		// We hold a member m_sTargetFrameName to use it as target for follow dispatches ...
		// but if user of this dispatch object use us more then ones ...
		// we will send the same target name for every dispatch call!
		// It's better to delete these value and use it one times only!
		OUString sTarget = m_sTargetFrameName;
		m_sTargetFrameName = OUString();
/*
		Reference< XURLTransformer > xTransformer( m_xFactory->createInstance( SERVICENAME_URLTRANSFORMER ), UNO_QUERY );
		LOG_ASSERT( !(xTransformer.is()==sal_False), "OPlugInFrameDispatcher::dispatch()\nCan't find service URLTransformer!\n" )
		OUString sURL = xTransformer->getPresentation( aURL, sal_False );
*/
		// Have we enough parameter for postURL() WITH a referrer ?
		if	(
				( bReferrerExist	==	sal_True	)	&&
				( bPostDataExist	==	sal_True	)
			)
		{
			// Yes; then do it.
			// Before log special informations about URL converting and send method. (if right mode is set!)
			LOG_URLSEND( "OPluginFrameDispatcher!", "(referrer) postURL", aURL.Complete, sURL )
			m_xPlugInDLL->postURL(	sURL						,
						 			xPostData					,
						 			sTarget						,
						 			OUString()					,
						 			sReferrer					,
						 			Reference< XInputStream >()	,
						 			this						);
		}
		else
		// Have we enough parameter for postURL() WITHOUT a referrer ?
		if	(
				( bReferrerExist	==	sal_False	)	&&
				( bPostDataExist	==	sal_True	)
			)
		{
			// Yes; then do it.
			// Before log special informations about URL converting and send method. (if right mode is set!)
			LOG_URLSEND( "OPluginFrameDispatcher!", "(without referrer) postURL", aURL.Complete, sURL )
			m_xPlugInDLL->postURL(	sURL						,
									xPostData					,
									sTarget						,
									OUString()					,
									OUString()					,
									Reference< XInputStream >()	,
									this						);
		}
		else
		// Have we enough parameter for getURL() WITH a referrer ?
		if	(
				( bReferrerExist	==	sal_True	)	&&
				( bPostDataExist	==	sal_False	)
			)
		{
			// Yes; then do it.
			// Before log special informations about URL converting and send method. (if right mode is set!)
			LOG_URLSEND( "OPluginFrameDispatcher!", "(referrer) getURL", aURL.Complete, sURL )
			m_xPlugInDLL->getURL(	sURL		,
									sTarget		,
									OUString()	,
									sReferrer	,
									this		);
		}
		else
		// We have enough parameter for getURL() WITHOUT a referrer !
		{
			// Yes; then do it.
			// Before log special informations about URL converting and send method. (if right mode is set!)
			LOG_URLSEND( "OPluginFrameDispatcher!", "(without referrer) getURL", aURL.Complete, sURL )
			m_xPlugInDLL->getURL(	sURL		,
									sTarget		,
									OUString()	,
									OUString()	,
									this		);
		}
	}
}

//*****************************************************************************************************************
//	XPluginInstanceNotifySink
//*****************************************************************************************************************
void SAL_CALL OPlugInFrameDispatcher::notifyURL( const OUString& sURL ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_notifyURL( sURL ), "OPlugInFrameDispatcher::notifyURL()\nInvalid parameter detected.\n" )
	// Send status event to all listener for this URL!
	impl_sendStatusEvent( sURL, sal_True );
}

//*****************************************************************************************************************
//	XDispatch
//*****************************************************************************************************************
void SAL_CALL OPlugInFrameDispatcher::addStatusListener(	const	Reference< XStatusListener >&	xControl,
															const	URL&							aURL	) throw( RuntimeException )
{
	// Safe impossible cases
	// Method not defined for all incoming parameter
	LOG_ASSERT( impldbg_checkParameter_addStatusListener( xControl, aURL ), "OPlugInFrameDispatcher::addStatusListener()\nInvalid parameter detected.\n" )
	// Add listener to container.
	m_aListenerContainer.addInterface( aURL.Complete, xControl );
}

//*****************************************************************************************************************
//	XDispatch
//*****************************************************************************************************************
void SAL_CALL OPlugInFrameDispatcher::removeStatusListener(	const	Reference< XStatusListener >&	xControl,
															const	URL&							aURL	) throw( RuntimeException )
{
	// Safe impossible cases
	// Method not defined for all incoming parameter
	LOG_ASSERT( impldbg_checkParameter_addStatusListener( xControl, aURL ), "OPlugInFrameDispatcher::removeStatusListener()\nInvalid parameter detected.\n" )
	// Add listener to container.
	m_aListenerContainer.removeInterface( aURL.Complete, xControl );
}
/*
//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
tIMPLExtractedArguments OPlugInFrameDispatcher::impl_extractArguments( const Sequence< PropertyValue >& seqArguments )
{
	// Set default return values
	tIMPLExtractedArguments aReturnStruct;
	aReturnStruct.nValidMask = 0;	// Mark all entry values as invalid!

	// Step over argument list and extract all needed informations.
	sal_Int32 nCount = seqArguments.getLength();
	for ( sal_Int32 nPosition=0; nPosition<nCount; ++nPosition )
	{
		// If REFERRER found ... set state to valid and safe value.
		if ( seqArguments[nPosition].Name == ARGUMENT_REFERRER )
		{
			seqArguments[nPosition].Value >>= aReturnStruct.sReferrer;
			aReturnStruct.nValidMask |= MASK_REFERRER;
		}
		else
		// If POSTDATA found ... set state to valid and safe value.
		if ( seqArguments[nPosition].Name == ARGUMENT_POSTDATA )
		{
			seqArguments[nPosition].Value >>= aReturnStruct.xPostDataStream;
			aReturnStruct.nValidMask |= MASK_POSTDATA;
		}
	}

	// Retrn extracted informations.
	return aReturnStruct;
}
*/
//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void OPlugInFrameDispatcher::impl_sendStatusEvent(	const	OUString&	sURL				,
															sal_Bool	bLoadingSuccessful	)
{
	// Get listener for given URL!
	OInterfaceContainerHelper* pListenerForURL = m_aListenerContainer.getContainer( sURL );
	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if( pListenerForURL != NULL )
	{
		// Build event for send to listener.
		FeatureStateEvent aEvent;
    	aEvent.FeatureURL.Complete	=	sURL							;
    	aEvent.FeatureDescriptor	=	FEATUREDESCRIPTOR_LOADSTATE		;
    	aEvent.IsEnabled			=	bLoadingSuccessful				;
    	aEvent.Requery				=	sal_False						;
    	aEvent.State				=	Any()							;

		// Send message to all listener on this URL.
		OInterfaceIteratorHelper aIterator(*pListenerForURL);
		while( aIterator.hasMoreElements() )
		{
			((XStatusListener*)aIterator.next())->statusChanged( aEvent );
		}
	}
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// sTargetFrameName can be empty! But we need valid references for working.
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_OPlugInFrameDispatcherCtor(	const	Reference< XMultiServiceFactory >&		xFactory	,
																					const	Reference< XPluginInstance >&			xOwner		,
																					const	Reference< XPluginInstancePeer >&		xPlugInDLL	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xFactory			==	NULL		)	||
			( &xOwner			==	NULL		)	||
			( &xPlugInDLL		==	NULL		)	||
			( xFactory.is()		==	sal_False	)	||
			( xOwner.is()		==	sal_False	)	||
			( xPlugInDLL.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_queryDispatch(	const	URL&	 	aURL			,
		 																const	OUString&	sTargetFrameName,
																				sal_Int32	nSearchFlags	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aURL							==	NULL		)	||
			( aURL.Complete.getLength()		<	1			)	||
			( &sTargetFrameName				==	NULL		)	||
			// sTargetFrameName can be ""!
			(
				( 	 nSearchFlags != FrameSearchFlag::AUTO		  )	&&
				( !( nSearchFlags &  FrameSearchFlag::PARENT	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::SELF		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::CHILDREN	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::CREATE	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::SIBLINGS	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::TASKS		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::ALL		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::GLOBAL	) )
			)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_queryDispatches( const Sequence< DispatchDescriptor >& seqDescriptor )
{
	// Set default return value.
	sal_Bool bOK = sal_True;

	// Check parameter.
	if	(
			( &seqDescriptor			==	NULL	)	||
			( seqDescriptor.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}

	// Return result of check.
	return bOK ;
}


//*****************************************************************************************************************
// We don't know anything about right values of aURL and seqArguments!
// Check valid references only.
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_dispatch(	const	URL&					  	aURL		,
																	const	Sequence< PropertyValue >&	seqArguments)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aURL						==	NULL	)	||
			( aURL.Complete.getLength()	<	1		)	||
			( &seqArguments				==	NULL	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
// We need a valid URL. What is meaning with "register for nothing"?!
// xControl must correct to - nobody can advised otherwise!
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_addStatusListener(	const	Reference< XStatusListener >&	xControl,
																			const	URL&							aURL	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xControl					==	NULL	)	||
			( &aURL						==	NULL	)	||
			( aURL.Complete.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
// The same goes for these case! We have added valid listener for correct URL only.
// We can't remove invalid listener for nothing!
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_removeStatusListener(	const	Reference< XStatusListener >&	xControl,
							   													const	URL&							aURL	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xControl					==	NULL	)	||
			( &aURL						==	NULL	)	||
			( aURL.Complete.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool OPlugInFrameDispatcher::impldbg_checkParameter_notifyURL( const OUString& sURL )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sURL				==	NULL	)	||
			( sURL.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
