/*************************************************************************
 *
 *  $RCSfile: blankdispatcher.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: as $ $Date: 2001/12/14 11:31:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_DISPATCH_BLANKDISPATCHER_HXX_
#include <dispatch/blankdispatcher.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TASKCREATOR_HXX_
#include <classes/taskcreator.hxx>
#endif

#include <classes/filtercache.hxx>

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XTASKSSUPPLIER_HPP_
#include <com/sun/star/frame/XTasksSupplier.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XTASK_HPP_
#include <com/sun/star/frame/XTask.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_XTOPWINDOW_HPP_
#include <com/sun/star/awt/XTopWindow.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XACTIONLOCKABLE_HPP_
#include <com/sun/star/document/XActionLockable.hpp>
#endif

#include <services/documentlist.hxx>
//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
    @short      standard ctor
    @descr      These initialize a new instance of this class with needed informations for work.

    @seealso    using at owner

    @param      "xFactory", reference to servicemanager for creation of new services
    @param      "xDesktop", reference to our owner, the Desktop!!!
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
BlankDispatcher::BlankDispatcher( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                  const css::uno::Reference< css::frame::XFrame >&              xDesktop, sal_Bool bDef )
		//	Init baseclasses first
        :   BaseDispatcher( xFactory, xDesktop )
        , m_bIsDefaultDispatcher( bDef )
        // Init member
{
	// Safe impossible cases
    // We need valid informations about ouer owner for work.
    LOG_ASSERT2( implcp_ctor( xFactory, xDesktop ), "BlankDispatcher::BlankDispatcher()", "Invalid parameter detected!" )
}

/*-************************************************************************************************************//**
    @interface  XDispatch
    @short      try to handle(!) or load URL with arguments into new created task
    @descr      We try to handle it without creation of a new task. If this will fail - we start loading of it into
                a new created task. Some started proccesses are asynchron. So we are listener for different callbacks.

    @attention  These listener mechanism is implemented by our base class "BaseDispatcher"! So we don't must look at it ...
                Overwrite dispatch() and reactForLoadingState() only. Base class call this one.

    @seealso    baseclass BaseDispatcher

    @param      "aURL"      , URL to dispatch.
    @param      "lArguments", list of optional arguments.
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL BlankDispatcher::dispatch( const css::util::URL&                                  aURL,
                                         const css::uno::Sequence< css::beans::PropertyValue >& lArguments ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_dispatch( aURL, lArguments ), "BlankDispatcher::dispatch()", "Invalid parameter detected." )

    // Register transaction and reject wrong calls
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    // Make snapshot of neccessary members
    ReadGuard aReadLock( m_aLock );
    css::uno::Reference< css::frame::XFrame >              xDesktop             ( m_xOwner.get(), css::uno::UNO_QUERY );
    css::uno::Reference< css::lang::XMultiServiceFactory > xFactory             = m_xFactory;
    sal_Bool                                               bIsDefaultDispatcher = m_bIsDefaultDispatcher;
    aReadLock.unlock();

	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    sal_Bool                                  bDispatched    = sal_False;
    sal_Bool                                  bCreateNewTask = sal_False;
    css::uno::Reference< css::frame::XFrame > xTask                     ;

    if( bIsDefaultDispatcher==sal_True )
        bDispatched = implts_findAndActivateAlreadyLoadedTask( aURL, lArguments, xDesktop );

    if( bDispatched == sal_False )
    {
        //---------------------------------------------------------------------------------------------------------
        // I)   First we must know type of dispatch URL. It's neccessary to find registered handler or loader.
        //      But we must copy given argument descriptor. Because; detection, handling or loading of URL
        //      will change this descriptor. And it's not a good idea to do that on a const parameter!
        css::uno::Sequence< css::beans::PropertyValue > lDescriptor ( lArguments );
        ::rtl::OUString sTypeName = implts_detectType( aURL, lDescriptor, sal_True ); // last parameter allow deep detection!

        //---------------------------------------------------------------------------------------------------------
        // II)  Try to handle it. In this case we doesn't need and new created/recycleable task.
        //      We forward it to a special registered handler service and wait for his callbacks.
        //      Check type name before! If automatic detection failed AND user don't select any filter
        //      in our filter dialog (implts_askTyp()!) ... this case will occure. So we should do nothing.
        if( sTypeName.getLength() > 0 )
            bDispatched = implts_handleIt( aURL, lDescriptor, sTypeName );

        //---------------------------------------------------------------------------------------------------------
        // III) If handling failed ... try to load it. Create new task as target of loading proccess.
        //      Normaly we are called for target "_blank". But this name isn't allowed as valid frame name!
        //      But user can give us as a optional argument ... search for it.
        if(
            ( bDispatched           == sal_False )  &&
            ( sTypeName.getLength() >  0         )
          )
        {
            // Special mode for dispatches by _default!
            // Try to find recyclable task and use it for loading of these new URL.
            if( bIsDefaultDispatcher==sal_True )
                xTask = implts_findAndLockRecycleTask( aURL, lDescriptor, xDesktop );
            bCreateNewTask = ( xTask.is() == sal_False );
            if( bCreateNewTask == sal_True )
            {
                ::rtl::OUString  sName                   ;
                sal_Bool         bHidden  = sal_False    ;
                ArgumentAnalyzer aAnalyzer( lDescriptor );

                aAnalyzer.getArgument( E_FRAMENAME, sName   );
                aAnalyzer.getArgument( E_HIDDEN   , bHidden );

                TaskInfo aCreateInfo( xFactory, xDesktop, sName, !bHidden );
                xTask = TaskCreator::createSystemTask( aCreateInfo );
            }

            if( xTask.is() == sal_True )
                bDispatched = implts_loadIt( aURL, lDescriptor, sTypeName, xTask );
		}
    }

    // Normal our base class handle sending of status events to our listener ...
    // But if this method failed (e.g. task couldn't be created, neccessary services couldn't be getted ...)
    // we must send our own event! Don't forget to "react for this failed operation".
    // You can do it here ... but it's better to implement it one times only in "reactForLoadingState()".
    // So you mustn't look at different places for bugfixes!
    if( bDispatched == sal_False )
    {
        if( xTask.is() && bCreateNewTask )
            implts_disableFrame( xTask ); // dispose it!
        implts_sendResultEvent( xTask, aURL.Complete, sal_False );
    }
}

/*-************************************************************************************************************//**
    @short          react for return state of dispatch call
    @descr          If we started our dispatch call ... our baseclass call us back to give us some informations about it.
                    So we can react for it. This implmentation create new tasks and try to load something in it.
                    If dispatch was successfully we must set visible state of this task - otherwise task must be deleted.
                    But there exist another mode: Some URLs was handled by an registered content handler.
                    These dispatches works without any tasks or frames!

    @attention      Base class call us back without any set lock or mutex. So we must do it by ourself!
                    BUT ... We don't need any lock here yet ... we don't work on internal member!
                    If YOU change it ... you should think about it again ...

    @seealso        base class BaseDispatcher

    @param          "aURL"       , dispatched URL
    @param          "lDescriptor", optional arguments of original dispatch call
    @param          "xTarget"    , target of dispatch (should be our new created task)
    @param          "bState"     , state of loading proccess (ok or failed)
    @return         -

    @onerror        -
    @threadsafe     yes
*//*-*************************************************************************************************************/
void SAL_CALL BlankDispatcher::reactForLoadingState( const css::util::URL&                                   aURL        ,
                                                     const css::uno::Sequence< css::beans::PropertyValue >&  lDescriptor ,
                                                     const css::uno::Reference< css::frame::XFrame >&        xTarget     ,
                                                           sal_Bool                                          bState      ,
                                                     const css::uno::Any&                                    aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // We don't need any lock here ... we don't work on internal member here!
    // But if YOU change it ... you should think about it again ...

    if( bState == sal_True )
    {
        implts_enableFrame( xTarget, lDescriptor ); // set visible state!
    }
    else if ( !xTarget->getController().is() )
    {
        implts_disableFrame( xTarget ); // dispose it!
    }
}

//*****************************************************************************************************************
void SAL_CALL BlankDispatcher::reactForHandlingState( const css::util::URL&                                  aURL        ,
                                                      const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                                            sal_Bool                                         bState      ,
                                                      const css::uno::Any&                                   aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    // TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* TODO?!

        I don't know, what I can do here ... URL was handled without using of a task or frame.
        There is nothing to do. Listener are informaed by our baseclass automaticly - frame mustn't be
        initialized or deinitialized.
     */
}

/*-************************************************************************************************************//**
    @short          Tries to find frame that has already loaded the document specified by URL.
    @descr          We search on our desktop container to find any task, which has already loaded
                    given URL. If we found anyone we try to set focus on it to bring it to front.
                    But dont do it in special cases ... like: - hidden loaded documents
                                                              - loaded from template
                                                              - second view of a document ...

    @seealso        method dispatch()

    @param          "aURL"       , dispatched URL
    @param          "lArguments" , optional arguments of original dispatch call
    @param          "xDesktop"   , used for task access
    @return         true for found task
                    false otherwise

    @onerror        We return false.
    @threadsafe     yes
*//*-*************************************************************************************************************/
sal_Bool BlankDispatcher::implts_findAndActivateAlreadyLoadedTask( const css::util::URL&                                   aURL       ,
                                                                   const css::uno::Sequence< css::beans::PropertyValue >&  lArguments ,
                                                                   const css::uno::Reference< css::frame::XFrame >         xDesktop   )
{
    ArgumentAnalyzer aAnalyzer( lArguments );

    // break search if new load proccess is a special request!
    sal_Bool bValue = sal_False;
    if(
        ( aAnalyzer.getArgument( E_ASTEMPLATE , bValue ) && bValue )    ||
        ( aAnalyzer.getArgument( E_HIDDEN     , bValue ) && bValue )    ||
        ( aAnalyzer.getArgument( E_OPENNEWVIEW, bValue ) && bValue )
      )
    {
        return sal_False;
    }

    // iterate through the tasks
    css::uno::Reference< css::frame::XFrame >                   xTask        ;
    css::uno::Reference< css::frame::XTasksSupplier >           xSupplier    ( xDesktop, css::uno::UNO_QUERY );
    css::uno::Reference< css::container::XEnumerationAccess >   xTaskList    = xSupplier->getTasks();
    css::uno::Reference< css::container::XEnumeration >         xEnumeration = xTaskList->createEnumeration();
    while( xEnumeration->hasMoreElements() )
    {
        css::uno::Any aElement = xEnumeration->nextElement();
        aElement >>= xTask;

        css::uno::Reference< css::frame::XController > xController  ;
        css::uno::Reference< css::frame::XModel >      xModel       ;

        if( xTask.is() )
            xController = xTask->getController();

        if( xController.is() )
			xModel = xController->getModel();

        if(
            ( xModel.is()   == sal_True         )   &&
            ( aURL.Complete == xModel->getURL() )
          )
        {
            sal_Int16 nNewVersion = 0;
            aAnalyzer.getArgument( E_VERSION, nNewVersion );

            css::uno::Sequence< css::beans::PropertyValue > lModelArgs = xModel->getArgs();

            sal_Bool  bHidden     = sal_False;
            sal_Int32 nOldVersion = 0;

            aAnalyzer.setArguments( lModelArgs );
            aAnalyzer.getArgument( E_HIDDEN , bHidden     );
            aAnalyzer.getArgument( E_VERSION, nOldVersion );

            if(
                ( bHidden     == sal_False   )   &&
                ( nNewVersion == nOldVersion )
              )
            {
                css::uno::Reference< css::awt::XWindow >    xTaskWindow= xTask->getContainerWindow();
                css::uno::Reference< css::awt::XTopWindow > xTopWindow ( xTaskWindow, css::uno::UNO_QUERY );
                if( xTopWindow.is() )
                {
                    xTaskWindow->setVisible( sal_True );
                    xTopWindow->toFront();
                }
                // Don't forget to send right event to all registered listener!
                // These activation was synchron for user ...
                // If we forget it - he waits for ever.
                implts_sendResultEvent( xTask, aURL.Complete, sal_True );
                return sal_True;
            }
        }
    }

    return sal_False;
}

/*-************************************************************************************************************//**
    @short          Tries to find frame that can be recycled for these dispatch.
    @descr          If new URL use same factory like an current existing one - and these existing one
                    isn't realy used yet - we can recylce the frame. We search on our desktop container to iterate
                    over all current existing tasks ... but we should ignore it, if follow rules match:
                        - document use different factory
                        - document was modified
                        - document was/should be loaded hidden
                        - task already locked by another load process (!!! otherwise we recycle a recyled task again !!!)

    @seealso        method dispatch()

    @param          "aURL"       , dispatched URL
    @param          "lArguments" , optional arguments of original dispatch call
    @param          "xDesktop"   , used for task access
    @return         reference for found task
                    null otherwise

    @onerror        We return NULL.
    @threadsafe     yes
*//*-*************************************************************************************************************/
css::uno::Reference< css::frame::XFrame > BlankDispatcher::implts_findAndLockRecycleTask( const css::util::URL&                                   aURL       ,
                                                                                          const css::uno::Sequence< css::beans::PropertyValue >&  lArguments ,
                                                                                          const css::uno::Reference< css::frame::XFrame >         xDesktop   )
{
    css::uno::Reference< css::frame::XFrame > xRecycleTask;

    ArgumentAnalyzer aAnalyzer( lArguments );

    // break search if new load proccess is a special request!
    sal_Bool bValue = sal_False;
    if(
        ( aAnalyzer.getArgument( E_ASTEMPLATE , bValue ) && bValue )    ||
        ( aAnalyzer.getArgument( E_HIDDEN     , bValue ) && bValue )    ||
        ( aAnalyzer.getArgument( E_OPENNEWVIEW, bValue ) && bValue )
      )
    {
        return NULL;
    }

    // iterate through the tasks
    css::uno::Reference< css::frame::XTasksSupplier >   xSupplier    ( xDesktop, css::uno::UNO_QUERY );
    css::uno::Reference< css::frame::XFrame >           xTask        ( xSupplier->getActiveTask(), css::uno::UNO_QUERY );
    css::uno::Reference< css::frame::XController >      xController  ;
    css::uno::Reference< css::frame::XModel >           xModel       ;

    if( xTask.is() )
        xController = xTask->getController();

    if( xController.is() )
        xModel = xController->getModel();

    if( xModel.is() == sal_True )
    {
        FilterCache aCache    ;
        Filter      aNewFilter;
        Filter      aOldFilter;

        ::rtl::OUString sFilterName;
        if( aAnalyzer.getArgument( E_FILTERNAME, sFilterName ) )
            aNewFilter = aCache.getFilter( sFilterName );

        css::uno::Sequence< css::beans::PropertyValue > lModelArgs = xModel->getArgs();
        aAnalyzer.setArguments( lModelArgs );

        sFilterName = ::rtl::OUString();
        if( aAnalyzer.getArgument( E_FILTERNAME, sFilterName ) )
            aOldFilter = aCache.getFilter( sFilterName );

        css::uno::Reference< css::util::XModifiable > xModifyCheck( xModel, css::uno::UNO_QUERY );

        if(
            ( xModifyCheck.is()            == sal_True                    )  &&
            ( xModifyCheck->isModified()   == sal_False                   )  &&
            ( xModel->getURL().getLength() <  1                           )  &&
            ( aOldFilter.sDocumentService  == aNewFilter.sDocumentService )
          )
        {
            css::uno::Reference< css::document::XActionLockable > xLockCheck( xTask, css::uno::UNO_QUERY );
            if( xLockCheck.is() )
            {
                WriteGuard aExclusivLock( m_aLock );
                if( xLockCheck->isActionLocked() == sal_False )
                {
                    xLockCheck->addActionLock();
                    xRecycleTask = xTask;
                }
                aExclusivLock.unlock();
            }
        }
    }
    return xRecycleTask;
}

/*-************************************************************************************************************//**
    @short      debug-method to check incoming parameter of some other mehods of this class
    @descr      The following methods are used to check parameters for other methods
                of this class. The return value is used directly for an ASSERT(...).

    @seealso    ASSERTs in implementation!

    @param      references to checking variables
    @return     sal_True  on invalid parameter<BR>
                sal_False otherway

    @onerror    -
    @threadsafe yes / They don't work on members - they are static!
*//*-*************************************************************************************************************/
#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool BlankDispatcher::implcp_ctor( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                       const css::uno::Reference< css::frame::XFrame >&              xDesktop )
{
    return(
            ( &xFactory                                                                         ==  NULL      ) ||
            ( &xDesktop                                                                         ==  NULL      ) ||
            ( xFactory.is()                                                                     ==  sal_False ) ||
            ( xDesktop.is()                                                                     ==  sal_False ) ||
            ( css::uno::Reference< css::frame::XDesktop >( xDesktop, css::uno::UNO_QUERY ).is() ==  sal_False )
          );
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
