/*************************************************************************
 *
 *  $RCSfile: wildcard.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:29:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_WILDCARD_HXX_
#include <classes/wildcard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::rtl	;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	definitions
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
Wildcard::Wildcard()
{
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
Wildcard::~Wildcard()
{
}

//*****************************************************************************************************************
//	interface
//*****************************************************************************************************************
sal_Bool Wildcard::match(	const	OUString&	sText		,
							const	OUString&	sPattern	)
{
	// Safe impossible cases.
	// These method is not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_match( sText, sPattern ), "Wildcard::match()\nInvalid parameter detected!\n" )

	// Set some initial values for follow algorithm.
	// We get the length now for better performance and copy
	// the strings to buffers for direct access on all letters!
	sal_Int32		nTextLength				=	sText.getLength()		;
	sal_Int32		nPatternLength	   		=	sPattern.getLength()	;
	OUStringBuffer	sSearchText				( sText		)				;
	OUStringBuffer	sSearchPattern			( sPattern	)				;
	sal_Int32		nTextPosition			=	0						;
	sal_Int32		nPatternPosition		=	0						;
	sal_Unicode		cPatternLetter										;
	sal_Unicode		cTextLetter											;
	sal_Bool		bLastPatternWasWildcard	=	sal_False				;

	// Set default return value.
	sal_Bool bMatch = sal_False;

	// Step over all letters from bot strings and break if we arrive
	// the end of last one.
	while	(
				( nTextPosition		<	nTextLength		)	||
				( nPatternPosition	<	nPatternLength	)
			)
	{
		// Get the current characters from bot strings to compare.
		cPatternLetter	= sSearchPattern.charAt	( nPatternPosition	);
		cTextLetter		= sSearchText.charAt	( nTextPosition		);

		//_________________________________________________________________________________________________________
		// Pattern is a '?'. => Skip one letter in text.
		if ( cPatternLetter == '?' )
		{
			// Set current state of matching for return!
			bMatch = sal_True;
			// If we are in "multiple-wildcard-mode" ...
			if ( bLastPatternWasWildcard == sal_True )
			{
				// Skip this pattern only and not the current text letter!
				// BECAUSE: 1x'*' && 1x'?' = 1x'*' !!!
				++nPatternPosition;
			}
			else
			{
				// A '?' skip one letter in text.
				// Step to next positions in both strings.
				++nPatternPosition	;
				++nTextPosition		;
			}
		}
		else
		//_________________________________________________________________________________________________________
		// Pattern is a '*'. => Compare next letter from pattern with all letters from text, up to compare is equal!
		if ( cPatternLetter == '*' )
		{
				// Set current state of matching to return.
				bMatch = sal_True;
				// Forget this pattern!
				++nPatternPosition;
				if ( nPatternPosition >= nPatternLength )
				{
					// But; If end of search pattern arrived, we know - this pattern match the text!
					// Break loop and return with TRUE.
					break;
				}
				else
				{
					// If end of pattern not arrived - activate "multiple-wildcard-mode"!
					// It can be, that follow search pattern are wildcards to ... skip this in follow loops.
					// Other way; get the next pattern-letter and search for it in text, to find next equal position
					// in both strings!
					bLastPatternWasWildcard = sal_True;
				}
		}
		else
		//_________________________________________________________________________________________________________
		// Both letters are equal.
		if ( cPatternLetter == cTextLetter )
		{
				// Set current state of matching to return.
				bMatch = sal_True;
				// We have found 100% of matching!
				// Step to next positions in both strings and forget these current letters.
				++nPatternPosition;
				++nTextPosition;
				// If last pattern was a wildcard ('*' or '?') and we are in "multiple-wildcard-mode" ...
				// reset this mode. We have found a sign, which is not a wildcard!
				// (We don't must ask the state of this special variable - we WILL reset his value now!)
				bLastPatternWasWildcard = sal_False;
		}
		//_________________________________________________________________________________________________________
		// Both letters are NOT equal and there is no wildcard.
		else
		{
			// Set current state of matching to return.
			bMatch = sal_False;
			// Normaly, the searched pattern don't match the given text!
			// But, if we are in the special "multiple-wildcard-mode", we will skip all letters in text,
			// which are not equal with current letter from pattern!
			if ( bLastPatternWasWildcard == sal_True )
			{
				// Thats why; we step in text, but not in pattern!
				++nTextPosition;
			}
			else
			{
				// In this case, we are not in the special mode and the letters from both strings are not equal.
				// This text don't match the pattern! Break loop and return with FALSE.
				break;
			}
		}
	}

	// Return state of this operation.
	return bMatch;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods check parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// Special signs '*' and '?' are allowed in pattern only!
sal_Bool Wildcard::impldbg_checkParameter_match(	const	OUString&	sText	,
													const	OUString&	sPattern)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sText	==	NULL	)	||
			( &sPattern	==	NULL	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif // #ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
//	private debug method for testing class implementation
//*****************************************************************************************************************

#ifdef ENABLE_CLASSDEBUG

void Wildcard::impldbg_testWildcard()
{
	sal_Bool	bMatch		;
	OUString	sText		;
	OUString	sPattern	;

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEFG" );
	bMatch		= Wildcard::match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 1\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF"  );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 2\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEFGI");
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 3\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "_BCDEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 4\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB_DEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 5\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF_" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 6\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "aBCDEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 7\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "abcdefg" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 8\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "?BCDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 9\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB?DEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 10\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF?");
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 11\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "??CDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 12\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABC??FG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 13\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDE??" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 14\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "?BCDEF"  );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 15\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "_BCDEF?" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 16\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "???????" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 17\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*BCDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 18\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB*DEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 19\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF*" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 20\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*EFG"	   );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 21\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABC*"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 22\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*G"     );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 23\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*"       );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 24\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "**CDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 25\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB**EFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 26\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB**"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 27\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*******" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 28\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*?*G"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 29\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*?*G"   );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 30\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*?*"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 31\n" )
}

#endif	//	#ifdef ENABLE_CLASSDEBUG

}		//	namespace framework
