#!/bin/sh
#*************************************************************************
#
#   $RCSfile: dtpatch.sh,v $
#
#   $Revision: 1.6 $
#
#   last change: $Author: svesik $ $Date: 2001/02/08 15:21:16 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************


if test "$OS" = "SOLARIS"; then

  _dtver=`pkginfo -l SUNWdtinc | awk '/VERSION/ { print ( substr($2,1,4) ) }' 2> /dev/null`
  rm -f patcherror

#
# Solaris 6
#

  if test "$_dtver" = "1.2,"; then
    echo found a SUNWdtinc package Version 1.2
    gunzip dt6.pat.tar.gz
    tar xf dt6.pat.tar
    gzip dt6.pat.tar
    
    rm -f patcherror
 
    for _FNAME in `cat flist.cp`
    do
      if test ! -s "$_FNAME"; then
        echo $_FNAME file is missing >> patcherror
      else
        cp -f $_FNAME rtufiles/
      fi
    done

    for _RNL in `cat flist.rnl`
    do
      _OLDFN=`echo $_RNL | awk ' { FS=","; print($1) } '`
      _NEWFN=`echo $_RNL | awk ' { FS=","; print($2) } '`
      mv rtufiles/$_OLDFN rtufiles/$_NEWFN
    done

    chmod -R +w rtufiles/*.h
    patch -i pat/editor.h.pat rtufiles/editor.h 2> newpatch

    if test -s "patcherror"; then
       echo "Please install the SUNWdtinc Version 1.2 package on your Solaris machine" >> patcherror
       echo "Please install the SUNWdtinc Version 1.2 package on your Solaris machine"
    elif test -s "newpatch"; then
       echo "Please install the Larry Wall's GNU patch."
       echo "Please install the Larry Wall's GNU patch" >> patcherror
    else
       echo "Patch done." > patchinf
       echo "Patch done."
    fi
    rm -rf pat
    rm -f newpatch

#
# Solaris 7 or 8
#

  elif test "$_dtver" = "1.3," -o "$_dtver" = "1.4,"; then
    echo found a SUNWdtinc package Version 1.3
    gunzip dt7.pat.tar.gz
    tar xf dt7.pat.tar
    gzip dt7.pat.tar
   
    rm -f patcherror

    for _FNAME in `cat flist.cp`
    do
      if test ! -s "$_FNAME"; then
        echo $_FNAME file is missing >> patcherror
      else
        cp -f $_FNAME rtufiles/
      fi
    done

    for _RNL in `cat flist.rnl`
    do
      _OLDFN=`echo $_RNL | awk ' { FS=","; print($1) } '`
      _NEWFN=`echo $_RNL | awk ' { FS=","; print($2) } '`
      mv rtufiles/$_OLDFN rtufiles/$_NEWFN
    done

    chmod -R +w rtufiles/*.h
    for _PNAME in `cat flist.pat`
    do
      patch -i pat/$_PNAME.pat rtufiles/$_PNAME 2> newpatch
    done

    if test -s "patcherror"; then
       echo "Please install the SUNWdtinc Version 1.2 package on your Solaris machine" >> patcherror
       echo "Please install the SUNWdtinc Version 1.2 package on your Solaris machine"
    elif test -s "newpatch"; then
       echo "Please install the Larry Wall's GNU patch."
       echo "Please install the Larry Wall's GNU patch" >> patcherror
    else
       echo "Patch done." > patchinf
       echo "Patch done."
    fi
    rm -rf pat
    rm -f newpatch

  else
    echo "Please install the SUNWdtinc package on your Solaris machine" >> patcherror
    echo "Please install the SUNWdtinc package on your Solaris machine"
  fi
fi

