/*************************************************************************
 *
 *  $RCSfile: testpgpfactory.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

#include <uno/api.h>

#include <usr/uno.hxx>
#include <usr/weak.hxx>
#include <usr/refl.hxx>
#include <usr/sequ.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>

#include <vos/mutex.hxx>
#include <vos/dynload.hxx>

#include <stardiv/uno/repos/serinfo.hxx>
#include <stardiv/uno/repos/implementationregistration.hxx>
#include <stardiv/uno/lang/factory.hxx>
#include <stardiv/uno/lang/serviceinfo.hxx>

#include <stardiv/pgp/pgp.hxx>

#include "extensionstest.hxx"

#if defined ( UNX ) || defined ( MAC )
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif


void test_pgpfactory()
{
	UString pgpModuleName;
	XMultiServiceFactoryRef xMgr(getProcessServiceManager(), USR_QUERY);
	TEST_ENSHURE( xMgr.is(), "getProccessServcieManager failed !!" );
	
	XImplementationRegistrationRef xInst( xMgr->createInstance(L"stardiv.uno.repos.ImplementationRegistration"), USR_QUERY );
	TEST_ENSHURE( xInst.is(), "no ImplementationRegistration" );
	TRY
	{
		char szDllName[_MAX_PATH]="";

		ORealDynamicLoader::computeModuleName("pgf", szDllName, _MAX_PATH);
		pgpModuleName = StringToOUString(szDllName, CHARSET_SYSTEM);
		xInst->registerImplementation(L"stardiv.loader.SharedLibrary", pgpModuleName, XSimpleRegistryRef() );
	}
	CATCH( CannotRegisterImplementationException, e )
	{
		TEST_ENSHURE( FALSE, "register implementation failed" );
	}
	END_CATCH;

	XMultiServiceFactoryRef xPGPFact(xMgr->createInstance(L"stardiv.pgp.PGPFactory"), USR_QUERY);
	TEST_ENSHURE( xPGPFact.is(), "no PGPFactory available" );

	Sequence<UString> serviceNames(xPGPFact->getAvailableServiceNames());
	TEST_ENSHURE( serviceNames.getLen() > 0, "no PGP service available" );	
	TEST_ENSHURE( serviceNames.getConstArray()[0] == L"stardiv.pgp.SimplePGPMailer", "not the correct PGP service available" );		

	XInterfaceRef xIface( xPGPFact->createInstance(L"stardiv.pgp.SimplePGPMailer"), USR_QUERY);
	XPGPDecoderRef xDecoder(xIface, USR_QUERY);
	TEST_ENSHURE( xDecoder.is(), "no PGP60 Decoder available" );
	XPGPEncoderRef xEncoder(xIface, USR_QUERY);
	TEST_ENSHURE( xEncoder.is(), "no PGP60 Encoder available" );
	XPGPPreferencesRef xPref(xIface, USR_QUERY);
	TEST_ENSHURE( xPref.is(), "no PGP60 Preferences available" );
	XPGPDecoderListenerRef xListener(xIface, USR_QUERY);
	TEST_ENSHURE( xListener.is(), "no PGP60 Listener available" );

	xInst->revokeImplementation(pgpModuleName, XSimpleRegistryRef() );
}
