/*************************************************************************
 *
 *  $RCSfile: vfscontentprovider.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_VFSCONTENTPROVIDER_HXX
#define _EXTENSIONS_VFSCONTENTPROVIDER_HXX


#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include <tools/list.hxx>	// Nur solange TOOLS-Liste


using namespace rtl;
using namespace cppu;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;

class VFSRootContent;


// =======================================================================
// VFSContentProvider
// =======================================================================

class VFSContentProvider :	public OWeakObject,
							public XContentProvider,
							public XContentIdentifierFactory
{
	OUString						aVFSScheme;
	List 							aOpenContentsRoots;
	
	VFSRootContent*					ImplFindRoot( const OUString& rRootIdentifier, sal_Bool bCreateIfNotExists );

public:
									VFSContentProvider();

	// XInterface
	Any 							SAL_CALL queryInterface( const Type& type ) throw(RuntimeException);
	void 							SAL_CALL acquire() throw(RuntimeException);
	void 							SAL_CALL release() throw(RuntimeException);

	// XContentProvider				
    Reference< XContent > 			SAL_CALL queryContent( const Reference< XContentIdentifier >& Identifier ) throw( IllegalIdentifierException, RuntimeException );
    sal_Int32						SAL_CALL compareContentIds( const Reference< XContentIdentifier >& Id1, const Reference< XContentIdentifier >& Id2 ) throw(RuntimeException);

	// XContentIdentifierFactory
    Reference< XContentIdentifier >	SAL_CALL createContentIdentifier( const OUString& ContentId ) throw(RuntimeException);
};

#endif // _EXTENSIONS_VFSCONTENTPROVIDER_HXX


