/*************************************************************************
 *
 *  $RCSfile: vfscontentprovider.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vfscontentprovider.hxx>
#include <vfsrootcontent.hxx>

// =======================================================================
// VFSContentProvider
// =======================================================================

VFSContentProvider::VFSContentProvider()
{
	aVFSScheme = L"vfs://";
}

VFSRootContent* VFSContentProvider::ImplFindRoot( const OUString& rRootIdentifier, sal_Bool bCreateIfNotExists )
{
	VFSRootContent* pRoot = NULL;
	for ( USHORT n = aOpenContentsRoots.Count(); n && !pRoot; ) 
	{
		VFSRootContent* pR = (VFSRootContent*)aOpenContentsRoots.GetObject( --n );
		if ( pR->getIdentifier()->getContentIdentifier() == rRootIdentifier )
			pRoot = pR;
	}
	if ( !pRoot && bCreateIfNotExists ) 
	{
		pRoot = new VFSRootContent( rRootIdentifier );
		pRoot->acquire();	// !?!?!?!
		aOpenContentsRoots.Insert( pRoot );
	}
	return pRoot;
}

// ----------------------------------------
// Interface XInterface
// ----------------------------------------

Any VFSContentProvider::queryInterface( const Type &type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface( type,
										SAL_STATIC_CAST( XContentProvider*, this ), 
										SAL_STATIC_CAST( XContentIdentifierFactory*, this )	);

	return (aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ));
}

void VFSContentProvider::acquire() throw(RuntimeException)
{
	OWeakObject::acquire();
}

void VFSContentProvider::release() throw(RuntimeException)
{
	OWeakObject::release();
}

// ----------------------------------------
// Interface XContentProvider
// ----------------------------------------

Reference< XContent > VFSContentProvider::queryContent( const Reference< XContentIdentifier >& rxIdentifier ) throw( IllegalIdentifierException, RuntimeException )
{
	Reference< XContent > xNewContent;
	OUString aIdentifier = rxIdentifier->getContentIdentifier();
	if ( aIdentifier.compareTo( aVFSScheme, aVFSScheme.getLength() ) == 0 ) 
	{
		sal_Int32 n = aIdentifier.indexOf( L"?/" );
		if ( n != (-1) )
		{
			OUString aRootIdentifier = aIdentifier.copy( 0, n+3 );	// "?!" included
			VFSRootContent* pRoot = ImplFindRoot( aIdentifier, sal_True );
			pRoot->QueryContent( rxIdentifier->getContentIdentifier(), xNewContent );
		}
	}
	return xNewContent;
}

sal_Int32 VFSContentProvider::compareContentIds( const Reference< XContentIdentifier >& Id1, const Reference< XContentIdentifier >& Id2 ) throw(RuntimeException)
{
	OUString ID1 = Id1->getContentIdentifier();
	OUString ID2 = Id2->getContentIdentifier();
	return ID1.compareTo( ID2 );
}

// ----------------------------------------
// Interface XContentIdentifierFactory
// ----------------------------------------

Reference< XContentIdentifier > VFSContentProvider::createContentIdentifier( const OUString& ContentId ) throw(RuntimeException)
{
	return new OSimpleContentIdentifier( ContentId, aVFSScheme );
}


