/*************************************************************************
 *
 *  $RCSfile: vfscontent.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_VFSCONTENT_HXX
#define _EXTENSIONS_VFSCONTENT_HXX

#ifndef _UCBHELPER_CONTENT_HXX_
#include <ucbhelper/content.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutext.hxx>
#endif

#include <tools/string.hxx>	// soll mal weg!

using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;

typedef com::sun::star::util::DateTime UNODateTime;

#define VFSCOMMAND_OPEN			1
#define VFSCOMMAND_CLOSE		2
#define VFSCOMMAND_INSERT		3
#define VFSCOMMAND_DELETE		4

#define VFSCONTENT_FILE			1
#define VFSCONTENT_FOLDER		2


#define VFSSCHEME		L"vfs"
#define ENCODINGHACK	RTL_TEXTENCODING_MS_1252

#define CONTENTDIR		"/Cnt"
#define ATTRIBDIR		"/Attr" 
#define TRASHDIR		"/Trash"


// Attribs from STORE, don't overwrite!!!

// #define STORE_ATTRIB_ISLINK		0x10000000
// #define STORE_ATTRIB_ISDIR		0x20000000
// #define STORE_ATTRIB_ISFILE		0x40000000

// #define VFSSTORE_ATTRIB_DELETED		0x00000001
#define VFSSTORE_ATTRIB_READONLY	0x00000002
#define VFSSTORE_ATTRIB_HIDDEN		0x00000004
#define VFSSTORE_ATTRIB_ARCHIVE		0x00000008



// typical URI:	"vfs://file:///d|MyVFS.vfs?/Sub1/test.txt"


template<class T> class SafeList:public osl::Mutex, public std::list<T>{};


class VFSRootContent;


// VFSSimpleAttributes are stored in the attrib value from the store.
// VFSSimpleAttributes are valid without ReadAttributes()

struct VFSSimpleAttributes
{
	sal_Bool	bIsFolder;		// Not persistent, 
	sal_Bool	bIsDocument;	// Not persistent, Valid without ReadAttributes()
	sal_Bool	bIsReadOnly;
	sal_Bool	bIsHidden;
	sal_Bool	bIsArchive;
};

// VFSExtendedAttributes are stored in a separate stream.

struct VFSExtendedAttributes
{
	OUString	aFileName;		// Not persistent, needed for XContentCreator
	OUString	aTitle;
	UNODateTime	aDateCreated;
	UNODateTime	aDateModified;
	UNODateTime	aDateAccessed;
};


// =======================================================================
// VFSContent
// =======================================================================

class VFSContent : public OContent
{
	friend class VFSRootContent;
	friend class InfoWindow;		// !!!!!!!!!!!!!!!!!

private:
	Mutex							maMutex;

	Reference<XContentIdentifier>	xIdentifier;
	VFSRootContent*					pRootContent;

	sal_Bool						bReadExtendedAttributes;	// Simple attribute are allways valid
	sal_Bool						bStoreExtendedAttributes;
	sal_Bool						bStoreSimpleAttributes;
	sal_Bool						bIsValid;
	sal_Bool						bIsOpen;
	VFSSimpleAttributes				aSimpleAttributes;
	VFSExtendedAttributes			aExtendedAttributes;

protected:
									VFSContent( const OUString& rIdentifier, sal_Int32 nAttrs, VFSRootContent* pRootContent );
									~VFSContent();
	
	Mutex&							GetMutex() { return maMutex; }

	void							StoreSimpleAttributes();
	void							StoreExtendedAttributes();
	void							ReadExtendedAttributes();

	sal_Int32						GetCommandHandle( const Command& rCommand ) const;

	sal_Bool						IsValidName( const OUString& rName ) const;
	OUString						CalcTitle( const OUString& rFileName ) const;
	OUString						CalcFileName( const OUString& rTitle ) const;


public:
//	virtual sal_Int16				GetVFSContentType() const = 0;

	Any								SetPropertyValue( PropertyValueInfo& rProperty );
	void							GetPropertyValue( PropertyValueInfo& rProperty );

	VFSRootContent*					GetRoot() const { return pRootContent; }
	void							ClearRoot() { pRootContent = NULL; }

	void							ChangeContentIdentifier( const OUString& rIdentifier );
	OUString						CreateContentIdentifier( const OUString& rPath, const OUString& rName ) const;

	sal_Bool						IsValid() const { return bIsValid; }
	void							SetValid( sal_Bool bValid ) { bIsValid = bValid; }

	sal_Bool						IsOpen() const { return bIsOpen; }
	void							SetOpen( sal_Bool bOpen ) { bIsOpen = bOpen; }

	void							InitAttributes();
	VFSSimpleAttributes&			GetSimpleAttributes() { return aSimpleAttributes; }
	VFSExtendedAttributes&			GetExtendedAttributes()
									{
										if ( bReadExtendedAttributes && IsValid() )
											ReadExtendedAttributes();
										return aExtendedAttributes;
									}


	const OUString&					GetFileName()		{ return GetExtendedAttributes().aFileName; }
	const OUString&					GetTitle()			{ return GetExtendedAttributes().aTitle; }
	const UNODateTime&				GetDateCreated()	{ return GetExtendedAttributes().aDateCreated; }
	const UNODateTime&				GetDateModified()	{ return GetExtendedAttributes().aDateModified; }
	const UNODateTime&				GetDateAccessed()	{ return GetExtendedAttributes().aDateAccessed; }
	sal_Bool						IsFolder()			{ return GetSimpleAttributes().bIsFolder; }
	sal_Bool						IsDocument() 		{ return GetSimpleAttributes().bIsDocument; }
	sal_Bool						IsReadOnly()		{ return GetSimpleAttributes().bIsReadOnly; }
	sal_Bool						IsHidden()			{ return GetSimpleAttributes().bIsHidden; }
	sal_Bool						IsArchive()			{ return GetSimpleAttributes().bIsArchive; }

	sal_Bool						SetFileName( const OUString& rName );
	sal_Bool						SetTitle( const OUString& rName );
	void							SetDateModified( const UNODateTime& rDT )	{ GetExtendedAttributes().aDateModified = rDT;	bStoreExtendedAttributes = sal_True;}
	void							SetDateAccessed( const UNODateTime& rDT )	{ GetExtendedAttributes().aDateAccessed = rDT;	bStoreExtendedAttributes = sal_True;}
	void							SetReadOnly( sal_Bool b )					{ GetSimpleAttributes().bIsReadOnly = b;		bStoreSimpleAttributes = sal_True; }
	void							SetHidden( sal_Bool b )						{ GetSimpleAttributes().bIsHidden = b;			bStoreSimpleAttributes = sal_True; }
	void							SetArchive( sal_Bool b )					{ GetSimpleAttributes().bIsArchive = b;			bStoreSimpleAttributes = sal_True; }


	static void						CreatePathAndName( const OUString& rIdentifier, String& rPath, String& rName, const char* pPre )
										{ CreatePathAndName( OUStringToOString( rIdentifier, RTL_TEXTENCODING_UTF8 ).getStr(), rPath, rName, pPre ); }
	static void						CreatePathAndName( const String& rIdentifier, String& rPath, String& rName, const char* pPre );
	static UNODateTime				GetCurrentDateTime();

	// XContent
	Reference< XContentIdentifier >	SAL_CALL getIdentifier() throw();

	// XCommmandTaskProcessor
	Reference< XCommandTask >		SAL_CALL createCommandTask(const Command& rCommand, const Reference< XResultAcceptor >& rResultAcceptor, const Reference< XContentTaskEnvironment >& rEnvironment ) throw();

	// XPropertyTaskProcessor
	Reference< XPropertyTask >		SAL_CALL createPropertyTask( PropertyTaskType Type, const Sequence< PropertyValue >& Properties, const Reference< XContentTaskEnvironment >& Environment ) throw();

	// XPropertySetInfo
	Sequence< Property >			SAL_CALL getProperties() throw();

};

#endif	// _EXTENSIONS_VFSCONTENT_HXX


