/*************************************************************************
 *
 *  $RCSfile: synccont.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SYNCCONT_HXX
#define _SYNCCONT_HXX

#include "synccom.hxx"

// ------------------
// - SyncContent -
// ------------------

class SyncContent : public OWeakObject, public XContentEventListener,
					public XPropertiesChangeListener, public XContentTaskClient
{
private:						

	REF( XMultiServiceFactory )			mxFact;
	REF( XContentProviderManager )		mxMgr;
	REF( XContentProvider )				mxProv;
	REF( XContentIdentifierFactory )	mxIdFact;
	REF( XContent )						mxContent;

	sal_Bool							ImplExists( const OUString& rURL, sal_uInt32 nType );
	sal_Bool							ImplCreateContent( const OUString& rURL, sal_uInt32 nType );
										
protected:								

	sal_uInt32							mnCntType;

										SyncContent();
	virtual								~SyncContent();
										
	virtual SyncContent*				Init( REF( XMultiServiceFactory )& rxFact, 
											  REF( XContentProviderManager )& rxMgr, 
											  const OUString& rURL, sal_uInt32 nType,
											  sal_Bool bCreate );
	virtual SyncContent*				Init( REF( XMultiServiceFactory )& rxFact,
											  REF( XContentProviderManager )& rxMgr, 
											  REF( XContent )& rxContent );
	virtual void						Destroy();
										
public:									
										
										
	// XInterface						
	virtual Any SAL_CALL				queryInterface( const Type & rType ) throw (RuntimeException);
    virtual void SAL_CALL				acquire() throw( RuntimeException );
    virtual void SAL_CALL				release() throw( RuntimeException );
										
	// XEventListener					
    virtual void SAL_CALL				disposing( const EventObject& Source ) throw( RuntimeException );
										
	// XContentEventListener			
    virtual void SAL_CALL				contentEvent( const ContentEvent& evt ) throw( RuntimeException );
										
	// XPropertiesChangeListener		
	virtual void SAL_CALL				propertiesChange( const SEQ( PropertyChangeEvent )& evt ) throw( RuntimeException );
										
	// XContentTaskClient				
    virtual void SAL_CALL				contentTaskEvent( const ContentTaskEvent& Event ) throw( RuntimeException );
										
public:									
										
	static SyncContent*					Create( REF( XMultiServiceFactory )& rxFact,
												REF( XContentProviderManager )& rxMgr, 
												const OUString& rURL, 
												sal_uInt32 nType, 
												sal_Bool bCreate )
										{
											SyncContent* pRet = new SyncContent;

											pRet->acquire();
											pRet->Init( rxFact, rxMgr, rURL, nType, bCreate );

											return pRet;
										}
										
	static SyncContent*					Create( REF( XMultiServiceFactory )& rxFact,
												REF( XContentProviderManager )& rxMgr, 
												REF( XContent )& rxContent )
										{	
											SyncContent* pRet = new SyncContent;

											pRet->acquire();
											pRet->Init( rxFact, rxMgr, rxContent );

											return pRet;
										}

	static void							Destroy( SyncContent* pSyncContent )
										{
											if( pSyncContent )
											{
												pSyncContent->Destroy();
												pSyncContent->release();
											}
										}

	static OUString						TypeIdToType( sal_uInt32 nType );
	static sal_uInt32					TypeToTypeId( const OUString& rType );
	static REF( XContent )				CreatePhysicalContent( SyncContent& rParent, const OUString& rTitle, sal_uInt32 nType );

public:

										
	sal_Bool							IsValid() const { return mxContent.is(); }
	REF( XContent )						GetXContent() const { return mxContent; }
										
	void								Dispose();
										
	const OUString						GetURL() const;
	const OUString						GetType() const;
	sal_uInt32							GetTypeId() const { return mnCntType; }
										
	SEQ( CommandInfo )					GetCommands();
	SEQ( Property )						GetProperties();
										
	Any									GetPropertyValue( const OUString& rName );
	void								SetPropertyValue( const OUString& rName, const Any& rValue );
										
	void								ExecuteCommand( const OUString& rName, const Any& rArgument );
};

#endif
