/*************************************************************************
 *
 *  $RCSfile: syncbase.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SYNCBASE_HXX
#define _SYNCBASE_HXX

#include "synccom.hxx"
#include <bdb/db_cxx.h>

// -----------
// - Defines -
// -----------

#define GET_OWSTRING_READ_STRLEN	0
#define BASE_FLUSH_ALWAYS_MODE		sal_False

#define BASE_FLAGS_NONE				0x00000000
#define BASE_FLAGS_AUTOFLUSH		0x00000001


// -------------------
// - SyncBaseElement -
// -------------------

class SyncBase;
class Dbt;

class SyncBaseElement : public SyncElement
{
	friend class SyncBase;
	friend class SyncCursor;

private:

							SyncBaseElement( const OUString& rElementIdentifier, const Dbt* pData );
							SyncBaseElement( const Dbt* pKey, const Dbt* pData );
	Dbt*					GetDbt() const;

	void					ImplInit( const OUString& rElementIdentifier, const Dbt* pData );
	void					ImplAssign( const SyncElement& rElement )
							{
								ContentIdentifier = rElement.ContentIdentifier;
								Type = rElement.Type;
								UID = rElement.UID;
								Generation = rElement.Generation;
								Event = rElement.Event;
								Action = rElement.Action;
							}

public:

	static sal_uInt32		GenerateUID();
	
	static sal_uInt32		Add_uInt32( sal_uChar*& rpBuf, sal_uInt32 nVal );
	static sal_uInt32		Add_OWString( sal_uChar*& rpBuf, const OUString& rStr, sal_Bool bLenInfo = sal_True );

	static sal_uInt32		Get_uInt32( sal_uChar*& rpBuf );
	static OUString			Get_OWString( sal_uChar*& rpBuf, sal_uInt32 nStrLen = GET_OWSTRING_READ_STRLEN );
	
public:

							SyncBaseElement();
							SyncBaseElement( const OUString& rContentIdentifier,
											 sal_uInt32 nType = SyncType::NONE,
										     sal_uInt32 nUID = 0, sal_uInt32 nGeneration = 0, 
											 sal_uInt32 nEvent = SyncEvent::NONE, sal_uInt32 nAction = SyncAction::NONE );
							SyncBaseElement( const SyncElement& rElement ) { ImplAssign( rElement ); }
							SyncBaseElement( const SyncBaseElement& rElement ) { ImplAssign( rElement ); }
							~SyncBaseElement() {}

	SyncBaseElement*		Clone() const { return new SyncBaseElement( *this ); }

	const OUString&			GetContentIdentifier() const { return ContentIdentifier; }

	sal_uInt32				GetType() const { return Type; }

	sal_uInt32				GetUID() const { return UID; }
	void					SetUID( sal_uInt32 nUID ) { UID = nUID; }
	
	sal_uInt32				GetGeneration() const { return Generation; } 
	void					SetGeneration( sal_uInt32 nGeneration ) { Generation = nGeneration; } 

	sal_uInt32				GetEvent() const { return Event; }
	void					SetEvent( sal_uInt32 nEvent ) { Event = nEvent; }

	sal_Bool				IsEmpty() const { return( 0 == ContentIdentifier.getLength() ); }
	void					SetEmpty() { ContentIdentifier = OUString(); UID = Generation = Event = Action = 0; }

	sal_uInt32				GetAction() const { return Action; }
	void					SetAction( sal_uInt32 nAction ) { Action = nAction; }

	sal_Bool				Matches( const SyncBaseElement& rElem ) const { return( ContentIdentifier == rElem.ContentIdentifier ); }
	sal_Bool				Matches( const OUString& rFilter ) const { return( ContentIdentifier.compareTo( rFilter, rFilter.getLength() ) == 0 ); }
};

// ------------
// - SyncBase -
// ------------

class Db;
class BaseTimer;

class SyncBase
{
	friend class SyncCursor;

private:

	OUString			maBaseFile;
	OUString			maName;
	Db*					mpBase;
	BaseTimer*			mpTimer;
	sal_Bool			mbModified;
						
						SyncBase();
						SyncBase( const SyncBase& rBase );
	SyncBase&			operator=( const SyncBase& rBase );

protected:				
						
	Dbt*				GetKey( const OUString& rElementIdentifier );
	void				ReleaseDbt( Dbt* pDbt );
						
public:					
						
						SyncBase( const OUString& rBaseFile, const OUString& rName, sal_uInt32 nFlags = BASE_FLAGS_NONE );
						~SyncBase();

	void				RemovePermanent();
						
	sal_Bool			PutElement( const SyncBaseElement& rElement, sal_Bool bFlush = BASE_FLUSH_ALWAYS_MODE );
	SyncBaseElement*	GetElement( const OUString& rElementIdentifier );

	sal_Bool			RemoveElement( const OUString& rElementIdentifier, sal_Bool bFlush = BASE_FLUSH_ALWAYS_MODE );
	SyncCursor*			GetCursor();
						
	sal_uInt32			Count();
	void				Flush();

	const OUString&		GetBaseFile() const { return maBaseFile; }
	const OUString&		GetName() const { return maName; }

	sal_Bool			IsModified() const { return mbModified; }
};

typedef SyncBase* PSYNCBASE;

// --------------
// - SyncCursor -
// --------------

class SyncCursor
{
	friend class SyncBase;

private:

	SyncBase*				mpBase;
	Dbc*					mpCursor;
	SyncBaseElement*		mpAct;
							
							SyncCursor( SyncBase* pBase = NULL ) : mpBase( pBase ), mpCursor( NULL ), mpAct( NULL ) {}
	Dbc*&					Cursor() { return mpCursor; }

protected:

	const SyncBaseElement*	GetElement( sal_uInt32 nCursorPos );
					
public:				
					
	virtual 				~SyncCursor();
							
	const SyncBaseElement*	First() { return GetElement( DB_FIRST ); }
	const SyncBaseElement*	Next() { return GetElement( DB_NEXT ); }
							
	const SyncBaseElement*	Last() { return GetElement( DB_LAST ); }
	const SyncBaseElement*	Prev() { return GetElement( DB_PREV ); }
							
	const SyncBaseElement*	Current() { return mpAct; }
};

#endif
