/*************************************************************************
 *
 *  $RCSfile: propertyinfo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tbe $ $Date: 2001/10/19 12:58:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PROPCTRLR_PROPERTYINFO_HXX_
#define _EXTENSIONS_PROPCTRLR_PROPERTYINFO_HXX_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

//............................................................................
namespace pcr
{
//............................................................................

	//========================================================================
	//= IPropertyInfoService
	//========================================================================
	class IPropertyInfoService
	{
	public:
		virtual sal_Int32				getPropertyId(const String& _rName) const = 0;
		virtual String					getPropertyTranslation(sal_Int32 _nId) const = 0;
		virtual sal_Int32				getPropertyHelpId(sal_Int32 _nId) const = 0;
		virtual sal_Int16				getPropertyPos(sal_Int32 _nId) const = 0;
		virtual sal_Bool				getPropertyMultiFlag(sal_Int32 _nId) const = 0;
        virtual sal_uInt32              getPropertyUIFlags(sal_Int32 _nId) const = 0;
		virtual ::com::sun::star::uno::Sequence< ::rtl::OUString >
										getPropertyEnumRepresentations(sal_Int32 _nId) const = 0;
	};

//............................................................................
} // namespace pcr
//............................................................................

#endif // _EXTENSIONS_PROPCTRLR_PROPERTYINFO_HXX_

/*************************************************************************
 * history:
 *	$Log: propertyinfo.hxx,v $
 *	Revision 1.2  2001/10/19 12:58:51  tbe
 *	#92755# Assign Standard Values for Basic Controls in Designmode
 *	
 *	Revision 1.1  2001/01/12 11:31:43  fs
 *	initial checkin - outsourced the form property browser
 *	
 *
 *	Revision 1.0 08.01.01 12:02:53  fs
 ************************************************************************/

