/*************************************************************************
 *
 *  $RCSfile: DecryptPassPhraseDialogImpl.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.pgp.ui;

import java.util.*;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

import com.sun.star.pgp.IPGP;
import com.sun.star.pgp.UserInfo;

// This class is not used like the other graphical classes from within SimplePGPMailer.
// Although PGP263x could directly instanciate this class it is
// done in SimplePGPMailer and the IPassPhraseDialog interface is passed
// to the methods in PGP263x. This is done for the following reasons:
// 1. Object of PGP263x, PGP50x etc are accessed through the IPGP interface.
// and PGP263x etc should not make assumptions about the graphical classes,
// otherwice we could simply do without the IPGP interface.
// 2. Since the service consists of several packages, it is useful to use
// interfaces to avoid circular references (which is a problem with the
// currently used development environment).
public class DecryptPassPhraseDialogImpl extends JPanel
	implements IPassPhraseDialog
{
	private static final boolean DEBUG = true;

	private ResourceBundle m_aBundle;
	private JPasswordField _phraseField;

	
	// IPassPhraseDialogImpl ---------------------------------------------------
	// Returns a pass word when the ok button has been pressed, null otherwise.
	public String getPassPhrase()
	{
		Object obj[]={ m_aBundle.getString("g_ok"), m_aBundle.getString("g_cancel")};
		JOptionPane pane= new JOptionPane(this, JOptionPane.QUESTION_MESSAGE,
								  JOptionPane.OK_CANCEL_OPTION, null,
								  obj, obj[0] );
		JDialog dlg= pane.createDialog(null, m_aBundle.getString("d2_title1"));
		dlg.show();

		if( obj[0].equals( pane.getValue())) // OK button?
			return new String( _phraseField.getPassword() );
		else
			return null;
	}

	//----------------------------------------------------------------------------------------------
	public DecryptPassPhraseDialogImpl(ResourceBundle bundle)
	{
		super( new GridBagLayout() );
		m_aBundle= bundle;
		Insets insets = new Insets( 2, 2, 2, 2 );

		// Passphrase label
		// d2_label1= "Enter valid Passphrase to decrypt:"
		add( new JLabel( m_aBundle.getString("d2_title1")  ),
			 new JXGridBagConstraints( 0, 0, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.NONE,
									   insets, 0, 0 ) );

		// Passphrase field
		_phraseField = new JPasswordField();
		// d2_toolTip1= "Enter any valid Passphrase to decrypt"
		_phraseField.setToolTipText( m_aBundle.getString("d2_toolTip1"));
		add( _phraseField,
			 new JXGridBagConstraints( 0, 1, 2, 1, 1.0, 0.0,
				   GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				   insets, 0, 0 ) );

	}
}
