/*************************************************************************
 *
 *  $RCSfile: installuser.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: dbo $ $Date: 2001/11/26 17:57:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include <vos/diagnose.hxx>

#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XHIERARCHICALPROPERTYSET_HPP_
#include <com/sun/star/beans/XHierarchicalPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_SECURITYEXCEPTION_HPP_
#include <com/sun/star/uno/SecurityException.hpp>
#endif

#include <tools/isolang.hxx>
#include <tools/resmgr.hxx>
#include <cppuhelper/implbase1.hxx>
#include <cppuhelper/factory.hxx>
#include <vos/process.hxx>
#include <osl/file.hxx>
#include <rtl/textenc.h>
#include <rtl/uri.h>
#include <rtl/uri.hxx>

using namespace osl;
using namespace vos;
using namespace std;
using namespace rtl;
using namespace cppu;
using namespace com::sun::star::util;
using namespace com::sun::star::registry;
using namespace com::sun::star::container;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;

namespace extensions {
namespace installuser {

    class InstallUser : public WeakImplHelper1< XInitialization >
    {
        Reference< XMultiServiceFactory > m_xMgr;
    public:
        InstallUser( const Reference< XMultiServiceFactory > & xMgr );
        virtual ~InstallUser();

        // XInitialization
        virtual void SAL_CALL initialize( const Sequence< Any >& aArguments ) throw(Exception, RuntimeException);

    };

#define HIERARCHY_ROOT_DB_KEY    "org.openoffice.Setup"
#define HIERARCHY_ROOT_DB_KEY2   "org.openoffice.Webtop.Security"


InstallUser::InstallUser( const Reference< XMultiServiceFactory > & xMgr )
    : m_xMgr( xMgr )
{
}

InstallUser::~InstallUser()
{
}

static osl::FileBase::RC SAL_CALL create_recursive( const OUString& rPath )
{
    OUString aPath( rPath );
    if( aPath[ rPath.getLength() - 1 ] == '/' ) aPath = aPath.copy( 0, rPath.getLength() - 1 );
    osl::FileBase::RC err = osl::Directory::create( aPath );
    if( err == osl::FileBase::E_NOENT )
    {
        sal_Int32 nIndex = aPath.lastIndexOf( '/' );
        if( nIndex != -1 )
        {
            create_recursive( aPath.copy( 0, nIndex ) );
            return osl::Directory::create( aPath );
        }
    }
    return err;
}


static osl::FileBase::RC SAL_CALL
copy_recursive( const rtl::OUString& srcUnqPath, const rtl::OUString& dstUnqPath,
                sal_Int32 TypeToCopy )
{
    osl::FileBase::RC err;

    if( TypeToCopy == -1 ) // Document
    {
        err = osl::File::copy( srcUnqPath,dstUnqPath );
    }
    else if( TypeToCopy == +1 ) // Folder
    {
        err = osl::Directory::create( dstUnqPath );
        if( err == osl::FileBase::E_EXIST )
            err = osl::FileBase::E_None;
        osl::FileBase::RC next = err;
        if( err == osl::FileBase::E_None )
        {
            sal_Int32 n_Mask = FileStatusMask_FileURL | FileStatusMask_FileName | FileStatusMask_Type;

            osl::Directory aDir( srcUnqPath );
            aDir.open();
            osl::DirectoryItem aDirItem;

            while( err ==  osl::FileBase::E_None &&
                   ( next = aDir.getNextItem( aDirItem ) ) == osl::FileBase::E_None )
            {
                sal_Bool IsDocument;
                osl::FileStatus aFileStatus( n_Mask );
                aDirItem.getFileStatus( aFileStatus );
                if( aFileStatus.isValid( FileStatusMask_Type ) )
                    IsDocument =
                        aFileStatus.getFileType() == osl::FileStatus::Regular ||
                        aFileStatus.getFileType() == osl::FileStatus::Link;

                // Getting the information for the next recursive copy
                sal_Int32 newTypeToCopy = IsDocument ? -1 : +1;

                rtl::OUString newSrcUnqPath;

                if( aFileStatus.isValid( FileStatusMask_FileURL ) )
                    newSrcUnqPath = aFileStatus.getFileURL();

                rtl::OUString newDstUnqPath = dstUnqPath;
                rtl::OUString tit;
                if( aFileStatus.isValid( FileStatusMask_FileName ) )
                    tit = aFileStatus.getFileName();
                if( newDstUnqPath.lastIndexOf( sal_Unicode('/') ) != newDstUnqPath.getLength()-1 )
                    newDstUnqPath += rtl::OUString::createFromAscii( "/" );
                newDstUnqPath += tit;


                err = copy_recursive( newSrcUnqPath,newDstUnqPath,newTypeToCopy );
            }

            aDir.close();
            if( next != osl::FileBase::E_NOENT )
                err = osl::FileBase::E_INVAL;
        }
    }

    return err;
}



void SAL_CALL InstallUser::initialize( const Sequence< Any >& aArguments ) throw(Exception, RuntimeException)
{




    sal_Bool bInstalled = FALSE;
    OStartupInfo aInfo;

    OUString aTargetPath;
    sal_Int32 nCount = aInfo.getCommandArgCount();
    OUString aComp( RTL_CONSTASCII_USTRINGPARAM( "-userid" ) );
    OUString aArg;
    for(;nCount--;)
    {
        aInfo.getCommandArg( nCount, aArg );
        if( !aArg.compareTo( aComp, aComp.getLength() ) )
        {
            sal_Int32 nPos = aArg.indexOf( '[' );
            sal_Int32 nEndpos = aArg.lastIndexOf( ']' );
            if( nPos != -1 && nEndpos != -1 )
                aTargetPath = Uri::decode(
                    aArg.copy( nPos + 1, nEndpos - nPos - 1 ),
                    rtl_UriDecodeWithCharset,
                    RTL_TEXTENCODING_UTF8 );
            break;
        }
    }
    if( !aTargetPath.getLength() )
        throw SecurityException() ;

    FileBase::getFileURLFromSystemPath( aTargetPath, aTargetPath );
    OUString aTest( aTargetPath );
    aTest += OUString( RTL_CONSTASCII_USTRINGPARAM( "/user" ) );
    DirectoryItem aItem;
    DirectoryItem::get( aTest, aItem );
    FileStatus aStatus(
        FileStatusMask_Validate | osl_FileStatus_Mask_FileName );
    if( aItem.getFileStatus( aStatus ) == osl_File_E_None &&
        aStatus.isValid( osl_FileStatus_Mask_FileName ) )
        bInstalled = TRUE;

    Reference< XMultiServiceFactory > xConfigProvider = Reference< XMultiServiceFactory >(
        m_xMgr->createInstance(
            OUString::createFromAscii(
                "com.sun.star.configuration.ConfigurationProvider" ) ),
        UNO_QUERY );

    Sequence< Any > aArgs( 1 );
    aArgs[ 0 ]
        <<= OUString::createFromAscii( HIERARCHY_ROOT_DB_KEY );
    Reference< XHierarchicalNameAccess > xRootHierAccess(
        xConfigProvider->createInstanceWithArguments(
            OUString::createFromAscii(
                "com.sun.star.configuration.ConfigurationAccess" ),
            aArgs ),
        UNO_QUERY );


    Sequence< Any > aArgs2( 1 );
    aArgs2[ 0 ]
        <<= OUString::createFromAscii( HIERARCHY_ROOT_DB_KEY2 );
    Reference< XHierarchicalNameAccess > xRootHierAccess2(
        xConfigProvider->createInstanceWithArguments(
            OUString::createFromAscii(
                "com.sun.star.configuration.ConfigurationAccess" ),
            aArgs2 ),
        UNO_QUERY );

    Any aBool = xRootHierAccess->getByHierarchicalName(
        OUString::createFromAscii( "Office/ooSetupInstCompleted" ) );

    sal_Bool bUserDirSet;
    aBool >>= bUserDirSet;

    OUString aLangCode;
    OUString aLang;
    if( !bInstalled || !bUserDirSet)
    {

        OUString aUserPath;

        Any aValue = xRootHierAccess->getByHierarchicalName(
            OUString::createFromAscii( "L10N/ooLocale" ) );
        if( !(aValue >>= aLang ))
            throw Exception() ;

        aValue = xRootHierAccess2->getByHierarchicalName(
            OUString::createFromAscii( "Authentication/homeDirectory" ) );
        if( !(aValue >>= aUserPath ))
            throw Exception();

        if( aUserPath.getLength() != 0 )
        {
            sal_Unicode aChar = aUserPath[ aUserPath.getLength() - 1 ];
            // this will possibly break on windows. Later osl normalize paths
            if( aChar != '/' && aChar != '\\' )
                aUserPath += OUString::createFromAscii( "/" );
            aUserPath += OUString::createFromAscii( "user" );

            Reference< XHierarchicalPropertySet > xPropSet(
                xConfigProvider->createInstanceWithArguments(
                    OUString::createFromAscii(
                        "com.sun.star.configuration.ConfigurationUpdateAccess" ),
                    aArgs ),
                UNO_QUERY );
            Any aValue;
            aValue <<= aUserPath;

            xPropSet->setHierarchicalPropertyValue(
                OUString::createFromAscii( "Office/ooSetupInstallPath" ), aValue );
            aValue <<= sal_Bool( sal_True );
            xPropSet->setHierarchicalPropertyValue(
                OUString::createFromAscii( "Office/ooSetupInstCompleted" ), aValue );

            Reference< XChangesBatch> xBatch( xPropSet, UNO_QUERY );
            xBatch->commitChanges();
        }
    }
    if( !bInstalled )
    {
        LanguageType eLang = ConvertIsoStringToLanguage( aLang, '-' );
        aLangCode = OUString::createFromAscii( ResMgr::GetLang( eLang, 0 ) );

    // Install from template directory

        OUString aBuffer;
        OUString aSourcePath;

        aInfo.getExecutableFile( aSourcePath );
        sal_Int32 nPos = aSourcePath.lastIndexOf( '/' );
        if( nPos != -1 )
        {
            aSourcePath = aSourcePath.copy( 0, nPos );
            nPos = aSourcePath.lastIndexOf( '/' );
        }
        if( nPos != -1 ) aSourcePath = aSourcePath.copy( 0, nPos );

        OUString aRelative( RTL_CONSTASCII_USTRINGPARAM( "UserProfiles/" ) );
        aRelative += aLangCode;
        FileBase::getAbsoluteFileURL( aSourcePath, aRelative, aBuffer );
        aSourcePath = aBuffer;


        OString aByteSource( aSourcePath, aSourcePath.getLength(), RTL_TEXTENCODING_ASCII_US );
        OString aByteTarget( aTargetPath, aTargetPath.getLength(), RTL_TEXTENCODING_ASCII_US );

        fprintf( stderr, "%s -> %s\n", (const char*) aByteSource, (const char*) aByteTarget );



        osl::FileBase::RC err = create_recursive( aTargetPath );
        if( err == osl::FileBase::E_EXIST || err == osl::FileBase::E_None )
            err = copy_recursive( aSourcePath, aTargetPath, 1 );

        if( err != 0 ) throw SecurityException();

        if ( xConfigProvider.is() )
        {
            Sequence< Any > aArguments( 1 );
            aArguments[ 0 ]
                <<= OUString::createFromAscii( HIERARCHY_ROOT_DB_KEY );

            Reference< XHierarchicalNameAccess > xRootHierAccess(
                xConfigProvider->createInstanceWithArguments(
                    OUString::createFromAscii(
                        "com.sun.star.configuration.ConfigurationAccess" ),
                    aArguments ),
                UNO_QUERY );

            Any aValue = xRootHierAccess->getByHierarchicalName(
                OUString::createFromAscii( "L10N/ooLocale" ) );

            OUString aLang;
            if( !(aValue >>= aLang ))
                throw Exception() ;

            LanguageType eLang = ConvertIsoStringToLanguage( aLang, '_' );
            aLangCode = OUString::createFromAscii( ResMgr::GetLang( eLang, 0 ) );
        }


    }
}

} // namespace
} // namespace

static Reference< XInterface > SAL_CALL InstallUser_create( const Reference< XMultiServiceFactory > & xMgr )
{
    return Reference< XInterface >( *new ::extensions::installuser::InstallUser( xMgr ) );
}

/*
 * component info
 */
extern "C"
{
//==================================================================================================
void SAL_CALL component_getImplementationEnvironment(
    const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
    *ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}
//==================================================================================================
sal_Bool SAL_CALL component_writeInfo(
    void * pServiceManager, void * pRegistryKey )
{
    if (pRegistryKey)
    {
        try
        {
            reinterpret_cast< XRegistryKey * >( pRegistryKey )->createKey(
                OUString::createFromAscii(
                    "/com.sun.star.portal.InstallUser/UNO/SERVICES/com.sun.star.portal.InstallUser" ) );
            return sal_True;
        }
        catch (InvalidRegistryException &)
        {
            OSL_ENSURE( sal_False, "### InvalidRegistryException!" );
        }
    }
    return sal_False;
}
//==================================================================================================
void * SAL_CALL component_getFactory(
    const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
    void * pRet = 0;

    if (pServiceManager && rtl_str_compare( pImplName, "com.sun.star.portal.InstallUser" ) == 0)
    {
        OUString aServiceName( OUString::createFromAscii( "com.sum.star.portal.InstallUser" ) );
        Reference< XSingleServiceFactory > xFactory( cppu::createSingleFactory(
            reinterpret_cast< XMultiServiceFactory * >( pServiceManager ),
            OUString::createFromAscii( pImplName ),
            InstallUser_create, Sequence< OUString >( &aServiceName, 1 ) ) );

        if (xFactory.is())
        {
            xFactory->acquire();
            pRet = xFactory.get();
        }
    }

    return pRet;
}
}

