/*************************************************************************
 *
 *  $RCSfile: test_inimanager.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

//_________________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#include <stdio.h>

//_________________________________________________________________________________________________________________________
//	namesapces
//_________________________________________________________________________________________________________________________

using namespace	::rtl						;
using namespace	::cppu						;
using namespace	::com::sun::star::uno		;
using namespace	::com::sun::star::lang		;
using namespace	::com::sun::star::registry	;

//_________________________________________________________________________________________________________________________
//	defines
//_________________________________________________________________________________________________________________________

#define	RDBNAME											"test_inimanager.rdb"

#define	SERVICENAME_INIMANAGER							"com.sun.star.config.inimanager"
#define	SERVICENAME_CONFIGMANAGER						"com.sun.star.config.configmanager"
#define	SERVICENAME_SPECIALCONFIGMANAGER				"com.sun.star.config.specialconfigmanager"

#define	ERRORID_CREATE_SERVICEMANAGER					1
#define	ERRORID_CREATE_CONFIGMANAGER					2
#define	ERRORID_NOT_XCOMPONENT							3

#define	ERRORDESCRIPTION_CREATE_SERVICEMANAGER			"Can't create global servicemanager."
#define	ERRORDESCRIPTION_CREATE_CONFIGMANAGER			"Can't create configmanager."
#define	ERRORDESCRIPTION_NOT_XCOMPONENT					"Servicemanager is not a XComponent."

//_________________________________________________________________________________________________________________________
//	global variables
//_________________________________________________________________________________________________________________________

Reference< XMultiServiceFactory >	g_xFactory	;

//_________________________________________________________________________________________________________________________
//	helper methods
//_________________________________________________________________________________________________________________________

/**************************************************************************************************************************
	This method print an error message and exit with an error code.
 **************************************************************************************************************************/
void breakTest( sal_uInt8 nErrorID )
{
	// Build error description
	ByteString sErrorDescription( "Error: ");

	switch( nErrorID )
	{
		case ERRORID_CREATE_SERVICEMANAGER:		sErrorDescription += ERRORDESCRIPTION_CREATE_SERVICEMANAGER;
												break;

		case ERRORID_CREATE_CONFIGMANAGER:		sErrorDescription += ERRORDESCRIPTION_CREATE_CONFIGMANAGER;
												break;

		case ERRORID_NOT_XCOMPONENT:			sErrorDescription += ERRORDESCRIPTION_NOT_XCOMPONENT;
												break;
	}

	// Print a message
	sErrorDescription += "\n";
	printf( sErrorDescription.GetBuffer() );
	// Exit program with right error id.
	exit( nErrorID );
}

/**************************************************************************************************************************
	This method get a reference to the global servicemanager which you can use to create services.
 **************************************************************************************************************************/
void startMain()
{
	// initialize this program!
	#ifdef SOLARIS
	ChangeGlobalInit();
	#endif

	// Get global factory for uno services.
	Reference< XMultiServiceFactory > g_xFactory( createRegistryServiceFactory( ( OUString(RTL_CONSTASCII_USTRINGPARAM(RDBNAME)) ) ) );

	// Print a message if an error occured.
	if ( g_xFactory.is() == sal_False )
	{
		breakTest( ERRORID_CREATE_SERVICEMANAGER );
	}
}

/**************************************************************************************************************************
	This method finish this program, clear memory and dispose alle used services.
 **************************************************************************************************************************/
void endMain()
{
	// Cast factory to XComponent
	Reference< XComponent > xComponent( g_xFactory, UNO_QUERY );

	// Print a message if an error occured.
	if ( xComponent.is() == sal_False )
	{
		breakTest( ERRORID_NOT_XCOMPONENT );
	}

	// Dispose and clear factory
	xComponent->dispose();
	g_xFactory.clear();
	g_xFactory = Reference< XMultiServiceFactory >();
}

/**************************************************************************************************************************
	This method is the beginning of the test.
 **************************************************************************************************************************/
void testServices()
{
	// Create ConfigManager
	Reference< XSimpleRegistry > xConfigManager( g_xFactory->createInstance( OUString(RTL_CONSTASCII_USTRINGPARAM(SERVICENAME_CONFIGMANAGER)) ), UNO_QUERY );

	if ( xConfigManager.is() == sal_False )
	{
		breakTest( ERRORID_CREATE_CONFIGMANAGER );
	}
}

//_________________________________________________________________________________________________________________________
//	main
//_________________________________________________________________________________________________________________________

#ifdef SOLARIS
	extern "C" void ChangeGlobalInit();
#endif

int SAL_CALL main(	int		nArguments		,
					char**	cArguments		,
					char**	cEnvironment	)
{
	// initialize main
	startMain();

	// test services
	testServices();

	// shutdown main
	endMain();

	printf( "Test of inimanager successful!\n" );
	return 0;
}
