/*************************************************************************
 *
 *  $RCSfile: sectionkey.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________________________________________________________________________________
//	my own include
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_SECTIONKEY_HXX_
#include "sectionkey.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_ENTRYKEY_HXX_
#include "entrykey.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

using namespace ::osl						;
using namespace ::rtl						;
using namespace ::cppu						;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::registry	;
using namespace ::com::sun::star::lang		;

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	DEFAULT_XINIMANAGER					Reference< XSimpleRegistry >()
#define	DEFAULT_PINIFILE		   			NULL
#define	DEFAULT_SSECTION					OUString()

#define	KEYTYPE_UNKNOWN						0
#define	KEYTYPE_SECTION						1
#define	KEYTYPE_ENTRY						2
#define	KEYTYPE_VALUE						3

#define	KEYSEPERATOR						'/'
#define	MAX_LINELENGTH						1024

//_______________________________________________________________________________________________________________________
//	macros
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	constructor
//_______________________________________________________________________________________________________________________

SectionKey::SectionKey( Mutex& aMutex )
	: m_aMutex			( aMutex				)
	, m_xINIManager		( DEFAULT_XINIMANAGER	)
	, m_pINIFile		( DEFAULT_PINIFILE		)
	, m_sSection		( DEFAULT_SSECTION		)
{
}

//_______________________________________________________________________________________________________________________
//	destructor
//_______________________________________________________________________________________________________________________

SectionKey::~SectionKey()
{
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL SectionKey::createKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
								  															RuntimeException			)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_createKey( sKeyName ), "SectionKey::createKey()\nInvalid parameter detected.\n" );

	if ( isValid() == sal_False )
	{
		throw  InvalidRegistryException();
	}

	// Set default return value.
	Reference< XRegistryKey > xKey = Reference< XRegistryKey >();

    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sNewEntry	;
	OUString	sNewValue	;
	switch( impl_getKeyInformation( sKeyName, sNewEntry, sNewValue ) )
	{
		// New key is a sub-entry. A value is optional and can be "".
		case	KEYTYPE_ENTRY	:
		case	KEYTYPE_VALUE	:	xKey = impl_createEntry( sNewEntry, sNewValue );
									break ;
	}

	return xKey ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::deleteKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_deleteKey( sKeyName ), "SectionKey::deleteKey()\nInvalid parameter detected.\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sNewEntry	;
	OUString	sNewValue	;
	switch( impl_getKeyInformation( sKeyName, sNewEntry, sNewValue ) )
	{
		// Searched key is a sub-entry. (Value is ignored)
		case	KEYTYPE_ENTRY   :
		case	KEYTYPE_VALUE	:	m_pINIFile->removeEntry( m_sSection, sNewEntry );
									break ;
	}
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL SectionKey::openKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
						 																	RuntimeException			)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_openKey( sKeyName ), "SectionKey::openKey()\nInvalid parameter detected.\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException ();
	}

	// Set default return value
	Reference< XRegistryKey > xKey = Reference< XRegistryKey >();

    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Split keyname
	OUString	sNewEntry	;
	OUString	sNewValue	;
	switch( impl_getKeyInformation( sKeyName, sNewEntry, sNewValue ) )
	{
		// Searched key is a sub-entry. (Value is ignored)
		case	KEYTYPE_ENTRY	:
		case	KEYTYPE_VALUE	:	xKey = impl_openEntry( sNewEntry );
									break ;
	}

	return xKey ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< Reference< XRegistryKey > > SAL_CALL SectionKey::openKeys() throw(	InvalidRegistryException	,
									 											RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();

	}

	// Set default return value, if method failed.
	Sequence< Reference< XRegistryKey > > seqKeys = Sequence< Reference< XRegistryKey > >();

    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

    // Get name of all entries and count it.
	Sequence< OUString >	seqEntries	= m_pINIFile->getSectionEntries( m_sSection );
	sal_uInt32				nEntryCount	= seqEntries.getLength();

	// If we have found entries ...
    if ( nEntryCount > 0 )
    {
		// ... create key-objects, build sequence and return it.
		// Get memory for right sequence.
		seqKeys.realloc( nEntryCount );
		// Get pointer to fields of entries and keys to copy elements from one section to another.
		const OUString*					pEntry	=	seqEntries.getConstArray();
		Reference< XRegistryKey >*		pKey	=	seqKeys.getArray();

		// Create for all entries a key object and set it into return sequence.
    	for ( sal_uInt32 nEntryNumber=0; nEntryNumber<nEntryCount; ++nEntryNumber )
    	{
			// Create key object to given entryname...
			Reference< XRegistryKey > xNewKey = impl_openEntry( pEntry[nEntryNumber] );
			// Safe impossible cases.
			DBG_ASSERT( !(xNewKey.is() == sal_False ), "SectionKey::openKeys()\nCan't open entry!\n" );
			// ... and copy it into return sequence.
			pKey[nEntryNumber] = xNewKey ;
    	}
    }

	// Return entries
	return seqKeys ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::closeKey() throw(	InvalidRegistryException	,
											RuntimeException			)
{
    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

	impl_resetObject();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL SectionKey::createLink(	const	OUString&	sLinkName	,
											const	OUString&	sLinkTarget	) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Not valid method at this object. A INI-key has no link!
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::createLink()\nAn INI key has no link!\n" );

	return sal_False ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::deleteLink( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																			RuntimeException			)
{
	// Not valid method at this object. A INI-key has no link!
	// Warn programmers!
	DBG_ASSERT( sal_False, "EntryKey::deleteLink()\nAn INI key has no link!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL SectionKey::isReadOnly() throw(	InvalidRegistryException	,
													RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Forwarded to INIManager.
	// In the moment a key is readonly, if file is readonly!
	return m_xINIManager->isReadOnly();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL SectionKey::isValid() throw( RuntimeException )
{
	// Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Set default return value.
	sal_Bool bValid = sal_True ;

	// Check state of current keyobject.
	if	(
			( m_xINIManager.is()		==	sal_False	)	||	//is INIManager open ?
			( m_xINIManager->isValid()	==	sal_False	)	||	//is INI-file open ?
			( m_pINIFile				==	NULL		)	||	//is INI-file open ?
			( m_sSection.getLength()	<	1			)		//is Section known ?
		)
	{
		impl_resetObject();
		bValid = sal_False ;
	}

	return bValid ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL SectionKey::getKeyName() throw( RuntimeException )
{
	// Read for multithreading
    MutexGuard aGuard( Mutex::getGlobalMutex() );

	return m_sSection ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL SectionKey::getKeyNames() throw(	InvalidRegistryException	,
																RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

    // Read for multithreading
    MutexGuard aGuard( m_aMutex );

	// Return names of entries.
	return m_pINIFile->getSectionEntries( m_sSection );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryKeyType SAL_CALL SectionKey::getKeyType( const OUString& sKeyName ) throw(	InvalidRegistryException	,
			   																		RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Other types unknown for this interface!
	// This object know KEYTYPE_UNKNOWN, KEYTYPE_ENTRY, KEYTYPE_VALUE.
	// But  RegistryKeyType" known only KEY and LINK!

	return RegistryKeyType_KEY ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL SectionKey::getResolvedName( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																					RuntimeException			)
{
	// Method not implemented yet.
	DBG_ASSERT( sal_False, "SectionKey::getResolvedName()\nNot implemented yet!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryValueType SAL_CALL SectionKey::getValueType() throw(	InvalidRegistryException	,
				 												RuntimeException			)
{
	return RegistryValueType_NOT_DEFINED ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Int32 SAL_CALL SectionKey::getLongValue() throw(	InvalidRegistryException	,
		 												InvalidValueException		,
														RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return 0 ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int32 > SAL_CALL SectionKey::getLongListValue() throw(	InvalidRegistryException	,
					 													InvalidValueException		,
																		RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return Sequence< sal_Int32 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL SectionKey::getAsciiValue() throw(	InvalidRegistryException	,
														InvalidValueException		,
														RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL SectionKey::getAsciiListValue() throw(	InvalidRegistryException	,
																		InvalidValueException		,
																		RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL SectionKey::getStringValue() throw(	InvalidRegistryException	,
														InvalidValueException		,
														RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL SectionKey::getStringListValue() throw(	InvalidRegistryException	,
																		InvalidValueException		,
																		RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL SectionKey::getBinaryValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	// Sectionkey has NO value.
	throw InvalidValueException();
	return Sequence< sal_Int8 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL SectionKey::getLinkTarget( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																				RuntimeException			)
{
	// Sectionkey has NO link.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::getLinkTarget()\nSectionKey has no link!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setLongValue( sal_Int32 nValue ) throw(	InvalidRegistryException	,
																	RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setLongValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setLongListValue( const Sequence< sal_Int32 >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setLongListValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setAsciiValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																			RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setAsciiValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setAsciiListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setAsciiListValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setStringValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																			RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setStringValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setStringListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setStringListValue()\nSectionKey has no value! Nothing to set.\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL SectionKey::setBinaryValue( const Sequence< sal_Int8 >& seqValue ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Sectionkey has NO value.
	// Warn programmers!
	DBG_ASSERT( sal_False, "SectionKey::setBinaryValue()\nSectionKey has no value! Nothing to set.\n" );
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

Any SAL_CALL SectionKey::queryInterface( const Type& aType ) throw( RuntimeException )
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Ask for my own supported interfaces ...
	Any aReturn	( ::cppu::queryInterface(	aType								  ,
									   		static_cast< XTypeProvider*	> ( this ),
									   		static_cast< XRegistryKey*	> ( this )
										)
				);

	// If searched interface not supported by this class ...
	if ( aReturn.hasValue() == sal_False )
	{
		// ... ask baseclass for interfaces!
		return OWeakObject::queryInterface( aType );
	}

	return aReturn ;
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL SectionKey::acquire() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::acquire();
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL SectionKey::release() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::release();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< Type > SAL_CALL SectionKey::getTypes() throw( RuntimeException )
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pTypeCollection is NULL - for the second call pTypeCollection is different from NULL!
	static OTypeCollection* pTypeCollection = NULL ;

	if ( pTypeCollection == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pTypeCollection == NULL )
		{
			// Create a static typecollection ...
			static OTypeCollection aTypeCollection	(	::getCppuType(( const Reference< XTypeProvider	>*)NULL ),
												  		::getCppuType(( const Reference< XRegistryKey	>*)NULL )
													);

			// ... and set his address to static pointer!
			pTypeCollection = &aTypeCollection ;
		}
	}

	return pTypeCollection->getTypes();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL SectionKey::getImplementationId() throw( RuntimeException )
{
	// Create one Id for all instances of this class.
	// Use ethernet address to do this! (sal_True)

	// Optimize this method
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pID is NULL - for the second call pID is different from NULL!
	static OImplementationId* pID = NULL ;

	if ( pID == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pID == NULL )
		{
			// Create a new static ID ...
			static OImplementationId aID( sal_False );
			// ... and set his address to static pointer!
			pID = &aID ;
		}
	}

	return pID->getImplementationId();
}

//________________________________________________________________________________________________________
//	public but not exported methods (impl!)
//________________________________________________________________________________________________________

void SectionKey::impl_initializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
												ProfileCache*					pINIFile	,
										const	OUString&						sSection	)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_implinitializeKey( xINIManager, pINIFile, sSection ), "SectionKey::impl_initializeKey()\nInvalid Parameter detected!\n" );

	// This method overwrite ALL member of this object ... (RESET)
	// You must call this at first after construct.
	m_xINIManager	=	xINIManager	;
	m_pINIFile		=	pINIFile	;
	m_sSection		=	sSection	;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

void SectionKey::impl_resetObject()
{
	// Set default values for the member of this object.
	// Needs for initialisation or reset.
	m_xINIManager	=	DEFAULT_XINIMANAGER	;
	m_pINIFile		=	DEFAULT_PINIFILE	;
	m_sSection		=	DEFAULT_SSECTION	;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

sal_uInt16 SectionKey::impl_getKeyInformation(	const	OUString&	sKey	,
														OUString&	sEntry	,
														OUString&	sValue	)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_implgetKeyInformation( sKey, sEntry, sValue ), "SectionKey::impl_getKeyInformation()\nInvalid Parameter detected!\n" );

	sEntry	=	sKey		;	// If no "/" exist, key is a entry. But it can be an empty string!
	sValue	=	OUString()	;	// Value is unknown at this time!

	// Special mode! If incoming key quoted - we don't parse for entry or value!
	// The whole key is handled as entry only.
	// We accept FULL quoted names only!
	// zB ["aaa/bbb/ccc"] but not [aaa"/bbb/ccc"]
	if	(
			( sKey.indexOf( '"', 0 ) == 0					)	&&
			( sKey.indexOf( '"', 1 ) == sKey.getLength()-1	)
		)
	{
		// We must decode keyname.
		sEntry = sKey.copy( 1, sKey.getLength()-2 );
	}
	else
	{
		// We have an entry ... ( perhaps! ) ... search for value.
		sal_Int32 nPosition = sKey.indexOf( KEYSEPERATOR );
		if ( nPosition != -1 )
		{
			// Value was found.
			// Split string in entry and value.
			sEntry = sKey.copy( 0, nPosition );
			++nPosition ;	// Don't use the delemitter!
			sValue = sKey.copy( nPosition, sKey.getLength()-nPosition );
		}
	}

	// Get information about keytype.
	sal_uInt16 aReturnKeyType = KEYTYPE_UNKNOWN ;
	if ( sEntry.getLength() > 0 )
	{
		aReturnKeyType = KEYTYPE_ENTRY ;
	}
	if ( sValue.getLength() > 0 )
	{
		aReturnKeyType = KEYTYPE_VALUE ;
	}

	// Return default (UNKNOWN) or well known keytype and values.
	return aReturnKeyType ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

sal_Bool SectionKey::impl_existKey( const OUString& sEntry )
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_implexistKey( sEntry ), "SectionKey::impl_existKey()\nInvalid Parameter detected!\n" );

	// Search section and entry.
	// sValue is ignored!
	OUString sValue ;
	return m_pINIFile->readString( m_sSection, sEntry, sValue );
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > SectionKey::impl_createEntry(	const	OUString&	sEntry	,
														const	OUString&	sValue	)
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_implcreateEntry( sEntry, sValue ), "SectionKey::impl_createEntry()\nInvalid Parameter detected!\n" );

	// Set defaul return value.
	Reference< XRegistryKey > xReturn = Reference< XRegistryKey >();

	// We have a valid section AND entry.
	// Look for existing key width the same name.
	if ( impl_existKey( sEntry ) == sal_True )
	{
		// The key already exist. Open it ...
		xReturn = impl_openEntry( sEntry );

		// ... and write NEW value, if it exist.
		if (
			( xReturn.is()			==	sal_True	) &&
			( sValue.getLength()	>	0			)
			)
		{
			xReturn->setStringValue( sValue );
		}
	}
	else
	{
		// Key not exist ... we must create it.
		// First, we write it to file.
		if ( m_pINIFile->writeString( m_sSection, sEntry, sValue ) == sal_True )
		{
			// OK ... we have create the new key.
			// Now, we must build a new instance of a keyreference.
			// DON'T delete this dynamical key!!! This is the return value of this method.
			EntryKey* pNewKey = new EntryKey( m_aMutex ) ;

			// Safe impossible cases
			// Never been reached, but its better to control!
			DBG_ASSERT( !(pNewKey == NULL), "SectionKey::impl_createEntry()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

			if ( pNewKey != NULL )
			{
				// Create the new keyreference and set right information on it.
				pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, m_sSection, sEntry );
				xReturn = static_cast< XRegistryKey* >( pNewKey );
			}
		}
	}

	return xReturn ;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

Reference< XRegistryKey > SectionKey::impl_openEntry( const OUString& sEntry )
{
	// Safe impossible cases
	// Check incoming parameter
	DBG_ASSERT( impl_checkParameter_implopenEntry( sEntry ), "SectionKey::impl_openEntry()\nInvalid Parameter detected!\n" );

	// Set defaul return value.
	Reference< XRegistryKey > xReturn = Reference< XRegistryKey >();

	if ( impl_existKey( sEntry ) == sal_True )
	{
		// We have a valid and existing section with entry.
		// Now, we must build a new instance of a keyreference.
		// DON'T delete this dynamical key!!! This is the return value of this method.
		EntryKey* pNewKey = new EntryKey( m_aMutex );

		// Safe impossible cases
		// Never been reached, but its better to control!
		DBG_ASSERT( !(pNewKey == NULL), "SectionKey::impl_openEntry()\nIts not necessary to create a new key! Memorymanager works not fine.\n" );

		if ( pNewKey != NULL )
		{
			// Create the new keyreference and set right information on it.
			pNewKey->impl_initializeKey( m_xINIManager, m_pINIFile, m_sSection, sEntry );
			xReturn = static_cast< XRegistryKey*>( pNewKey );
		}
	}

	return xReturn ;
}

//_______________________________________________________________________________________________________________________
//	debug and check methods
//_______________________________________________________________________________________________________________________

#ifdef _DEBUG

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_createKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_deleteKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_openKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_implinitializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
															const	ProfileCache*					pINIFile	,
															const	OUString&						sSection	)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &xINIManager			==	NULL		)	||
			( xINIManager.is()		==	sal_False	)	||
			( pINIFile				==	NULL		)	||
			( &sSection				==	NULL		)	||
			( sSection.getLength()	<	1			)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_implgetKeyInformation(	const	OUString&	sKey	,
																const	OUString&	sEntry	,
																const	OUString&	sValue	)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKey					==	NULL	)	||
			( sKey.getLength()		<	1		)	||
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	>	0		)	||
			( &sValue				==	NULL	)	||
			( sValue.getLength()	>	0		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_implexistKey( const OUString& sEntry )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_implcreateEntry(	const	OUString&	sEntry	,
															const	OUString&	sValue	)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	<	1		)	||
			( &sValue				==	NULL	)
			// sValue can be empty!
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_impldeleteEntry( const OUString& sEntry )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//***********************************************************************************************************************
sal_Bool SectionKey::impl_checkParameter_implopenEntry( const OUString& sEntry )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sEntry				==	NULL	)	||
			( sEntry.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

#endif // _DEBUG

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com

