/*************************************************************************
 *
 *  $RCSfile: rootkey.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_ROOTKEY_HXX_
#define _EXTENSIONS_ROOTKEY_HXX_

//_______________________________________________________________________________________________________________________
// includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HPP_
#include <com/sun/star/registry/InvalidValueException.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HPP_
#include <com/sun/star/registry/RegistryKeyType.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HPP_
#include <com/sun/star/registry/RegistryValueType.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HPP_
#include <com/sun/star/registry/InvalidRegistryException.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_PROFILECACHE_HXX_
#include "profilecache.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	defines and namespaces :-)
//_______________________________________________________________________________________________________________________

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

#define	XTYPEPROVIDER				::com::sun::star::lang::XTypeProvider
#define	XREGISTRYKEY				::com::sun::star::registry::XRegistryKey
#define	XSIMPLEREGISTRY				::com::sun::star::registry::XSimpleRegistry
#define	OUSTRING					::rtl::OUString
#define	OWEAKOBJECT					::cppu::OWeakObject
#define	INVALIDREGISTRYEXCEPTION	::com::sun::star::registry::InvalidRegistryException
#define	INVALIDVALUEEXCEPTION		::com::sun::star::registry::InvalidValueException
#define	RUNTIMEEXCEPTION			::com::sun::star::uno::RuntimeException
#define	ANY							::com::sun::star::uno::Any
#define	MUTEX						::osl::Mutex
#define	REFERENCE					::com::sun::star::uno::Reference
#define	REGISTRYKEYTYPE				::com::sun::star::registry::RegistryKeyType
#define	REGISTRYVALUETYPE			::com::sun::star::registry::RegistryValueType
#define	SEQUENCE					::com::sun::star::uno::Sequence
#define	UNOTYPE						::com::sun::star::uno::Type

//_______________________________________________________________________________________________________________________
//	classes
//_______________________________________________________________________________________________________________________

class RootKey	: public XTYPEPROVIDER
		   		, public XREGISTRYKEY
		   		, public OWEAKOBJECT
{

//_______________________________________________________________________________________________________________________
//	public methods
//_______________________________________________________________________________________________________________________

public:

	//____________________________________________________________________________________________________
	//	constructor / destructor
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	RootKey( MUTEX& aMutex );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual	~RootKey();

	//____________________________________________________________________________________________________
	//	XSimpleRegistry
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual REFERENCE< XREGISTRYKEY > SAL_CALL createKey( const OUSTRING& sKeyName ) throw(	INVALIDREGISTRYEXCEPTION	,
																							RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL deleteKey( const OUSTRING& sKeyName ) throw(	INVALIDREGISTRYEXCEPTION	,
																		RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual REFERENCE< XREGISTRYKEY > SAL_CALL openKey( const OUSTRING& sKeyName ) throw(	INVALIDREGISTRYEXCEPTION	,
																							RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< REFERENCE< XREGISTRYKEY > > SAL_CALL openKeys() throw(	INVALIDREGISTRYEXCEPTION	,
																				RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL closeKey() throw(	INVALIDREGISTRYEXCEPTION	,
											RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool SAL_CALL createLink(	const	OUSTRING&	sLinkName	,
											const	OUSTRING&	sLinkTarget	) throw(	INVALIDREGISTRYEXCEPTION	,
																						RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL deleteLink( const OUSTRING& sLinkName ) throw(	INVALIDREGISTRYEXCEPTION	,
																			RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual sal_Bool SAL_CALL isReadOnly() throw(	INVALIDREGISTRYEXCEPTION	,
													RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual sal_Bool SAL_CALL isValid() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getKeyName() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< OUSTRING > SAL_CALL getKeyNames() throw(	INVALIDREGISTRYEXCEPTION	,
																RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual REGISTRYKEYTYPE SAL_CALL getKeyType( const OUSTRING& sKeyName ) throw(	INVALIDREGISTRYEXCEPTION	,
																					RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getResolvedName( const OUSTRING& sKeyName ) throw(	INVALIDREGISTRYEXCEPTION	,
																					RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual REGISTRYVALUETYPE SAL_CALL getValueType() throw(	INVALIDREGISTRYEXCEPTION	,
																RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual sal_Int32 SAL_CALL getLongValue() throw(	INVALIDREGISTRYEXCEPTION	,
														INVALIDVALUEEXCEPTION		,
														RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< sal_Int32 > SAL_CALL getLongListValue() throw(	INVALIDREGISTRYEXCEPTION	,
																		INVALIDVALUEEXCEPTION		,
																		RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getAsciiValue() throw(	INVALIDREGISTRYEXCEPTION	,
														INVALIDVALUEEXCEPTION		,
														RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< OUSTRING > SAL_CALL getAsciiListValue() throw(	INVALIDREGISTRYEXCEPTION	,
																		INVALIDVALUEEXCEPTION		,
																		RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getStringValue() throw(	INVALIDREGISTRYEXCEPTION	,
														INVALIDVALUEEXCEPTION		,
														RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< OUSTRING > SAL_CALL getStringListValue() throw(	INVALIDREGISTRYEXCEPTION	,
																		INVALIDVALUEEXCEPTION		,
																		RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual SEQUENCE< sal_Int8 > SAL_CALL getBinaryValue() throw(	INVALIDREGISTRYEXCEPTION	,
																	INVALIDVALUEEXCEPTION		,
																	RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getLinkTarget( const OUSTRING& sLinkName ) throw(	INVALIDREGISTRYEXCEPTION,
																				RUNTIMEEXCEPTION		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setLongValue( sal_Int32 nValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																	RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setLongListValue( const SEQUENCE< sal_Int32 >& seqValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																							RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setAsciiValue( const OUSTRING& sValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																			RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setAsciiListValue( const SEQUENCE< OUSTRING >& seqValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																							RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setStringValue( const OUSTRING& sValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																			RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setStringListValue( const SEQUENCE< OUSTRING >& seqValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																							RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL setBinaryValue( const SEQUENCE< sal_Int8 >& seqValue ) throw(	INVALIDREGISTRYEXCEPTION	,
																						RUNTIMEEXCEPTION			);

	//____________________________________________________________________________________________________
	//	XInterface
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		give answer, if interface is supported
		@descr		The interfaces are searched by type.

		@seealso	XInterface

		@param      "rType" is the type of searched interface.

		@return		Any		information about found interface

		@onerror	A RuntimeException is thrown.
	*/

	virtual ANY SAL_CALL queryInterface( const UNOTYPE& aType ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		increment refcount
		@descr		-

		@seealso	XInterface
		@seealso	release()

		@param		-

		@return		-

		@onerror	A RuntimeException is thrown.
	*/

    virtual void SAL_CALL acquire() throw() ;

	/**___________________________________________________________________________________________________
		@short		decrement refcount
		@descr		-

		@seealso	XInterface
		@seealso	acquire()

		@param		-

		@return		-

		@onerror	A RuntimeException is thrown.
	*/

    virtual void SAL_CALL release() throw() ;

	//____________________________________________________________________________________________________
	//	XTypeProvider
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		get information about supported interfaces
		@descr      -

		@seealso	XTypeProvider

		@param      -

		@return		Sequence of types of all supported interfaces

		@onerror	A RuntimeException is thrown.
	*/

	virtual SEQUENCE< UNOTYPE > SAL_CALL getTypes() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		get implementation id
		@descr      This ID is neccessary for UNO-caching. If there no ID, cache is disabled.
					Another way, cache is enabled.

		@seealso	XTypeProvider

		@param		-

		@return		ID as Sequence of byte

		@onerror	A RuntimeException is thrown.
	*/

	virtual SEQUENCE< sal_Int8 > SAL_CALL getImplementationId() throw( RUNTIMEEXCEPTION );

//_______________________________________________________________________________________________________________________
//	public but not exported methods (impl!)
//_______________________________________________________________________________________________________________________

public:

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_initializeKey(	const	REFERENCE< XSIMPLEREGISTRY >&	xINIManager	,
										ProfileCache*					pINIFile	);

//_______________________________________________________________________________________________________________________
//	protected methods
//_______________________________________________________________________________________________________________________

protected:

//_______________________________________________________________________________________________________________________
//	private methods
//_______________________________________________________________________________________________________________________

private:

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_resetObject();

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	sal_uInt16 impl_getKeyInformation(	const	OUSTRING&	sKey	,
												OUSTRING&	sSection,
												OUSTRING&	sEntry	,
												OUSTRING&	sValue	);

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	sal_Bool impl_existKey(	const	OUSTRING&	sSection	,
							const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	REFERENCE< XREGISTRYKEY > impl_createSection( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	REFERENCE< XREGISTRYKEY > impl_createEntry(	const	OUSTRING&	sSection	,
												const	OUSTRING&	sEntry		,
												const	OUSTRING&	sValue		);

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	REFERENCE< XREGISTRYKEY > impl_openSection( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	REFERENCE< XREGISTRYKEY > impl_openEntry(	const	OUSTRING&	sSection	,
												const	OUSTRING&	sEntry		);

//_______________________________________________________________________________________________________________________
//	debug and check methods
//_______________________________________________________________________________________________________________________

private:

	#ifdef _DEBUG

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	static sal_Bool impl_checkParameter_createKey				(	const	OUSTRING&						sKeyName	);
	static sal_Bool impl_checkParameter_deleteKey				(	const	OUSTRING&						sKeyName	);
	static sal_Bool impl_checkParameter_openKey					(	const	OUSTRING&						sKeyName	);
	static sal_Bool impl_checkParameter_getKeyType				(	const	OUSTRING&						sKeyName	);
	static sal_Bool impl_checkParameter_implinitializeKey		(	const	REFERENCE< XSIMPLEREGISTRY >&	xINIManager	,
																	const	ProfileCache*					pINIFile	);
	static sal_Bool impl_checkParameter_implgetKeyInformation	(	const	OUSTRING&						sKey		,
																	const	OUSTRING&						sSection	,
																	const	OUSTRING&						sEntry		,
																	const	OUSTRING&						sValue		);
	static sal_Bool impl_checkParameter_implexistKey			(	const	OUSTRING&						sSection	,
																	const	OUSTRING&						sEntry		);
	static sal_Bool impl_checkParameter_implcreateSection		(	const	OUSTRING&						sSection	);
	static sal_Bool impl_checkParameter_implcreateEntry			(	const	OUSTRING&						sSection	,
																	const	OUSTRING&						sEntry		,
																	const	OUSTRING&						sValue		);
	static sal_Bool impl_checkParameter_impldeleteSection		(	const	OUSTRING&						sSection	);
	static sal_Bool impl_checkParameter_impldeleteEntry			(	const	OUSTRING&						sSection	,
																	const	OUSTRING&						sEntry		);
	static sal_Bool impl_checkParameter_implopenSection			(	const	OUSTRING&						sSection	);
	static sal_Bool impl_checkParameter_implopenEntry			(	const	OUSTRING&						sSection	,
																	const	OUSTRING&						sEntry		);

	#endif // _DEBUG

//_______________________________________________________________________________________________________________________
//	private variables
//_______________________________________________________________________________________________________________________

private:

	MUTEX&							m_aMutex		;
	REFERENCE< XSIMPLEREGISTRY >	m_xINIManager	;	// We need this reference to know: "The INI-file is open."!
	ProfileCache*					m_pINIFile		;

};	// class RootKey

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com

#endif	// #ifndef _EXTENSIONS_ROOTKEY_HXX_
