/*************************************************************************
 *
 *  $RCSfile: profilecache.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:21:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PROFILECACHE_HXX_
#define _EXTENSIONS_PROFILECACHE_HXX_

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_UTIL_XMODIFYLISTENER_HPP_
#include <com/sun/star/util/XModifyListener.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFYBROADCASTER_HPP_
#include <com/sun/star/util/XModifyBroadcaster.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUES_HPP_
#include <com/sun/star/beans/PropertyValues.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HPP_
#include <com/sun/star/beans/XFastPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HPP_
#include <com/sun/star/beans/XVetoableChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATE_HPP_
#include <com/sun/star/beans/XPropertyState.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyStateChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include <com/sun/star/beans/XPropertyAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyStateChangeEvent.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_
#include <com/sun/star/util/XFlushable.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _VOS_PROFILE_HXX_
#include <vos/profile.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef __SGI_STL_HASH_MAP
#include <hash_map>
#endif

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

#define	OPROFILE									::vos::OProfile
#define	OUSTRING									::rtl::OUString
#define	XPROPERTYCHANGELISTENER						::com::sun::star::beans::XPropertyChangeListener
#define	XMODIFYLISTENER								::com::sun::star::util::XModifyListener
#define	XINTERFACE									::com::sun::star::uno::XInterface
#define	XSIMPLEREGISTRY								::com::sun::star::registry::XSimpleRegistry
#define	XREGISTRYKEY								::com::sun::star::registry::XRegistryKey
#define	XFLUSHABLE									::com::sun::star::util::XFlushable
#define	XMULTISERVICEFACTORY						::com::sun::star::lang::XMultiServiceFactory
#define	EVENTOBJECT									::com::sun::star::lang::EventObject
#define	RUNTIMEEXCEPTION							::com::sun::star::uno::RuntimeException
#define	OINTERFACECONTAINERHELPER					::cppu::OInterfaceContainerHelper
#define	PROPERTYCHANGEEVENT							::com::sun::star::beans::PropertyChangeEvent
#define	MUTEX										::osl::Mutex
#define	OMULTITYPEINTERFACECONTAINERHELPERVAR		::cppu::OMultiTypeInterfaceContainerHelperVar
#define	OMULTITYPEINTERFACECONTAINERHELPER			::cppu::OMultiTypeInterfaceContainerHelper
#define	REFERENCE									::com::sun::star::uno::Reference
#define	SEQUENCE									::com::sun::star::uno::Sequence
#define	ANY											::com::sun::star::uno::Any
#define	UNOTYPE										::com::sun::star::uno::Type

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	OPENFLAG_READONLY							0
#define	OPENFLAG_WRITEABLE							1

//_______________________________________________________________________________________________________________________
//	impl declarations
//_______________________________________________________________________________________________________________________

// Helper to implement a hash table to bind listener at special ini-keys.
struct tIMPL_StringHashCode
{
	size_t operator()(const OUSTRING& sString) const
	{
		return sString.hashCode();
	}
};

typedef OMULTITYPEINTERFACECONTAINERHELPERVAR<	OUSTRING					,
												tIMPL_StringHashCode		,
												std::equal_to< OUSTRING >	> tIMPL_ListenerContainerHelper;

// Helper to implement a hash table to divert some keys of soffice.ini to our new configuration management.
struct tIMPL_KeyInfo
{
	// member
	OUSTRING						sConfigKeyName	;
	REFERENCE< XSIMPLEREGISTRY >	xRegistry		;
	REFERENCE< XREGISTRYKEY >		xRootKey		;

	// default ctor
	tIMPL_KeyInfo::tIMPL_KeyInfo()
	{}

	// copy ctor
	tIMPL_KeyInfo::tIMPL_KeyInfo(	const	OUSTRING&						sNewConfigKeyName	,
									const	REFERENCE< XSIMPLEREGISTRY >&	xNewRegistry		,
									const	REFERENCE< XREGISTRYKEY >&		xNewRootKey			)
	{
		sConfigKeyName	=	sNewConfigKeyName	;
		xRegistry		=	xNewRegistry		;
		xRootKey		=	xNewRootKey			;
	}

	// assignment
	tIMPL_KeyInfo& operator= ( const tIMPL_KeyInfo& aCopyInfo )
	{
		sConfigKeyName	=	aCopyInfo.sConfigKeyName	;
		xRegistry		=	aCopyInfo.xRegistry			;
		xRootKey		=	aCopyInfo.xRootKey			;
		return *this;
	}
};

typedef ::std::hash_map<	OUSTRING					,
							tIMPL_KeyInfo				,
							tIMPL_StringHashCode		,
							std::equal_to< OUSTRING >	> tIMPL_ConfigurationMapHelper;

// Struct to hold base informations about different configuration start points!
struct tIMPL_ConfigurationPoint
{
	REFERENCE< XSIMPLEREGISTRY >	xTree		;
	REFERENCE< XREGISTRYKEY >		xBaseNode	;
	REFERENCE< XFLUSHABLE >			xFlush		;
};

//_______________________________________________________________________________________________________________________
//	class
//_______________________________________________________________________________________________________________________

class ProfileCache
{

//_______________________________________________________________________________________________________________________
//	public methods
//_______________________________________________________________________________________________________________________

public:

	//____________________________________________________________________________________________________
	//	constructor / destructor
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	ProfileCache(	const	REFERENCE< XMULTISERVICEFACTORY >&	xFactory	,
							MUTEX&								aMutex		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual	~ProfileCache();

	//____________________________________________________________________________________________________
	//	ProfileCache
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	sal_Bool open(	const	OUSTRING&	sProfileName	,
					const	sal_uInt8	aFlag			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void close();

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	sal_Bool flush();

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool readString(	const	OUSTRING&	sSection	,
									const	OUSTRING&	sEntry		,
											OUSTRING&	sValue		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool writeString(	const	OUSTRING&	sSection	,
									const	OUSTRING&	sEntry		,
									const	OUSTRING&	sValue		);
	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool createSection( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool createEntry(	const	OUSTRING&	sSection	,
									const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool removeSection( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual sal_Bool removeEntry(	const	OUSTRING&	sSection	,
									const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual SEQUENCE< OUSTRING > getSectionEntries( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual SEQUENCE< OUSTRING > getSections();

	//____________________________________________________________________________________________________
	//	public but not exported methods (impl!)
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    void impl_addPropertyChangeListener(	const	OUSTRING&								sKeyName	,
											const	REFERENCE< XPROPERTYCHANGELISTENER >&	xListener	) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    void impl_removePropertyChangeListener(	const	OUSTRING&								sKeyName	,
											const	REFERENCE< XPROPERTYCHANGELISTENER >&	xListener	) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    void impl_addModifyListener( const REFERENCE< XMODIFYLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    void impl_removeModifyListener( const REFERENCE< XMODIFYLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_setConfigManagerReference( XINTERFACE* pConfigManager );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_disposing( const EVENTOBJECT& rSource ) throw( RUNTIMEEXCEPTION );

//_______________________________________________________________________________________________________________________
//	private methods
//_______________________________________________________________________________________________________________________

private:

	/**___________________________________________________________________________________________________
		@short		send message to listener on a section, if section was created.

		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendCreateEvent( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendCreateEvent(	const	OUSTRING&	sSection	,
								const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendChangeEvent(	const	OUSTRING&	sSection		,
								const	OUSTRING&	sChangedEntry	);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendChangeEvent(	const	OUSTRING&	sSection	,
								const	OUSTRING&	sEntry		,
								const	OUSTRING&	sOldValue	,
								const	OUSTRING&	sNewValue	);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendRemoveEvent( const OUSTRING& sSection );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendRemoveEvent(	const	OUSTRING&	sSection	,
								const	OUSTRING&	sEntry		,
								const	OUSTRING&	sOldValue	);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendPropertyChangeEvent(			OINTERFACECONTAINERHELPER*	pListener	,
										const	PROPERTYCHANGEEVENT&		aEvent		);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	void impl_sendModifyEvent();

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	sal_Bool impl_isModified(	const	OUSTRING&	sSection	,
								const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short		initialize the new configuration hash map
		@descr		We do this only, if soffice.ini is opened to froward some special keys to the
					new configuration management.

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	sal_Bool impl_initConfigurationMap( const sal_uInt8 nFlag );

	/**___________________________________________________________________________________________________
		@short		look, if key exist in configuration map
		@descr		If this key exist in this map we must handle this by the new configuration management.

		@seealso	-

		@param		"sSection";	Sectionname of specialkey
		@param		"sEntry"  ;	Entryname of specialkey

		@return		Valid iterator if it exist in map; an invalid iterator otherwise.

		@onerror	-
	*/

	tIMPL_ConfigurationMapHelper::iterator impl_searchSpecialKey(	const	OUSTRING&	sSection	,
																	const	OUSTRING&	sEntry		);

	/**___________________________________________________________________________________________________
		@short		handling of configuration keys for read and write with different types
		@descr		-

		@seealso	-

		@param		-
		@param		-

		@return		-

		@onerror	-
	*/

	OUSTRING impl_readCfgKey(	const	REFERENCE< XREGISTRYKEY >&	xBaseNode	,
								const	OUSTRING&					sName		);
	void impl_writeCfgKey(	const	REFERENCE< XREGISTRYKEY >&	xBaseNode	,
							const	OUSTRING&					sName		,
							const	OUSTRING&					sValue		);

	/**___________________________________________________________________________________________________
		@short		special handling for key "User/User-Adress"
		@descr		This old soffice.ini key is splittet to different keys in our new configuration management.

		@seealso	-

		@param		-
		@param		-

		@return		-

		@onerror	-
	*/

	OUSTRING impl_readUserAdress( const REFERENCE< XREGISTRYKEY >& xBaseNode );
	void impl_writeUserAdress(	const	REFERENCE< XREGISTRYKEY >&	xBaseNode,
			 					const	OUSTRING&					sValue	 );

	//____________________________________________________________________________________________________
	//	debug methods
	//	This functions return a boolean value, which can be use for "DBG_ASSERT" directly!
	//____________________________________________________________________________________________________

	#ifdef _DEBUG

	sal_Bool impl_debug_checkParameter_open				( const OUSTRING& sProfileName	, const sal_uInt8 aFlag								);
	sal_Bool impl_debug_checkParameter_readString		( const OUSTRING& sSection		, const OUSTRING& sEntry, const OUSTRING& sValue	);
	sal_Bool impl_debug_checkParameter_writeString		( const OUSTRING& sSection		, const OUSTRING& sEntry, const OUSTRING& sValue	);
	sal_Bool impl_debug_checkParameter_createSection	( const OUSTRING& sSection															);
	sal_Bool impl_debug_checkParameter_createEntry		( const OUSTRING& sSection		, const OUSTRING& sEntry							);
	sal_Bool impl_debug_checkParameter_removeSection	( const OUSTRING& sSection															);
	sal_Bool impl_debug_checkParameter_removeEntry		( const OUSTRING& sSection		, const OUSTRING& sEntry							);
	sal_Bool impl_debug_checkParameter_getSectionEntries( const OUSTRING& sSection															);

	#endif

//_______________________________________________________________________________________________________________________
//	private variables
//_______________________________________________________________________________________________________________________

private:

	REFERENCE< XMULTISERVICEFACTORY >	m_xFactory					;	/// Factory to create new services on demand
	tIMPL_ListenerContainerHelper		m_aPropertyChangeListener	;	/// Container to hold keys for listener mechanism
	OMULTITYPEINTERFACECONTAINERHELPER	m_aModifyListener			;	/// Container for listener for variable-changes of implementation of "substituteVariables()"
	XINTERFACE*							m_pConfigManager			;	/// Used to adress modify-event
	OPROFILE							m_aProfile					;	/// Access to ini-file
	tIMPL_ConfigurationMapHelper		m_aConfigurationMap			;	/// Hash table to map special keys from soffice.ini to new configuration management
	tIMPL_ConfigurationPoint			m_aCfgPoint_Setup			;	/// Configuration information for "com.sun.star.Setup"
	tIMPL_ConfigurationPoint			m_aCfgPoint_Common			;	/// Configuration information for "com.sun.star.Office.Common"
	tIMPL_ConfigurationPoint			m_aCfgPoint_UserProfile		;	/// Configuration information for "com.sun.star.UserProfile"
	tIMPL_ConfigurationPoint			m_aCfgPoint_Inet			;	/// Configuration information for "com.sun.star.Inet"
	sal_Bool							m_bCfgEnabled				;	/// We need it to enable some special handlings!

};	// class ProfileCache

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com

#endif	// #ifndef _EXTENSIONS_PROFILECACHE_HXX_
