/*************************************************************************
 *
 *  $RCSfile: entrykey.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________________________________________________________________________________
//	my own include
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_ENTRYKEY_HXX_
#include "entrykey.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	namespaces
//_______________________________________________________________________________________________________________________

using namespace ::osl						;
using namespace ::rtl						;
using namespace ::cppu						;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::registry	;
using namespace ::com::sun::star::lang		;

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

//_______________________________________________________________________________________________________________________
//	defines
//_______________________________________________________________________________________________________________________

#define	DEFAULT_XINIMANAGER				Reference< XSimpleRegistry >()
#define	DEFAULT_PINIFILE				NULL
#define	DEFAULT_SSECTION				OUString()
#define	DEFAULT_SENTRY					OUString()

#define	MAX_LINELENGTH					1024

//_______________________________________________________________________________________________________________________
//	macros
//_______________________________________________________________________________________________________________________

//_______________________________________________________________________________________________________________________
//	constructor
//_______________________________________________________________________________________________________________________

EntryKey::EntryKey( Mutex& aMutex )
	: m_aMutex			( aMutex				)
	, m_xINIManager		( DEFAULT_XINIMANAGER	)
	, m_pINIFile		( DEFAULT_PINIFILE		)
	, m_sSection		( DEFAULT_SSECTION		)
	, m_sEntry			( DEFAULT_SENTRY		)
{
}

//_______________________________________________________________________________________________________________________
//	destructor
//_______________________________________________________________________________________________________________________

EntryKey::~EntryKey()
{
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL EntryKey::createKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Safe impossible cases
	// Metohod is not declared for invalid parameter!
	DBG_ASSERT( impl_checkParameter_createKey( sKeyName ), "EntryKey::createKey()\nInvalid parameter detected!\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Entrykey has no subkeys
	return Reference< XRegistryKey >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::deleteKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Safe impossible cases
	// Metohod is not declared for invalid parameter!
	DBG_ASSERT( impl_checkParameter_deleteKey( sKeyName ), "EntryKey::deleteKey()\nInvalid parameter detected!\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// An entry has no subkeys!
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Reference< XRegistryKey > SAL_CALL EntryKey::openKey( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Safe impossible cases
	// Metohod is not declared for invalid parameter!
	DBG_ASSERT( impl_checkParameter_openKey( sKeyName ), "EntryKey::openKey()\nInvalid parameter detected!\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// An entry has no subkeys!
	return Reference< XRegistryKey >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< Reference< XRegistryKey > > SAL_CALL EntryKey::openKeys() throw(	InvalidRegistryException	,
																			RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// An entry has no subkeys!
	return Sequence< Reference< XRegistryKey > >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::closeKey() throw(	InvalidRegistryException	,
											RuntimeException			)
{
	// Ready for multithreading
	MutexGuard aGuard( m_aMutex );

	impl_resetObject();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL EntryKey::createLink(	const	OUString&	sLinkName	,
										const	OUString&	sLinkTarget	) throw(	InvalidRegistryException	,
																					RuntimeException			)
{
	// Not valid method at this object. A INI-key has no link!
	// Warn programmers!
	DBG_ASSERT( sal_False, "EntryKey::createLink()\nAn INI key has no link!\n" );
	return sal_False ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::deleteLink( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Not valid method at this object. A INI-key has no link!
	// Warn programmers!
	DBG_ASSERT( sal_False, "EntryKey::deleteLink()\nAn INI key has no link!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL EntryKey::isReadOnly() throw(	InvalidRegistryException	,
												RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Forwarded to INIManager.
	return m_xINIManager->isReadOnly();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Bool SAL_CALL EntryKey::isValid() throw( RuntimeException )
{
	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	// Set default return value
	sal_Bool bValid = sal_True ;

	// Check state of current keyobject.
	if (
		( m_xINIManager.is()		==	sal_False	)	||		//is INIManager open ?
		( m_xINIManager->isValid()	==	sal_False	)	||		//is INI file open ?
		( m_pINIFile				==	NULL		)	||		//is INI file open ?
		( m_sSection.getLength()	<	1			)	||		//is section well known ?
		( m_sEntry.getLength()		<	1			)	  		//is entry well known ?
	   )
	{
		impl_resetObject();
		bValid = sal_False ;
	}

	return bValid ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL EntryKey::getKeyName() throw( RuntimeException )
{
	// Ready for multithreading
    MutexGuard aGuard( Mutex::getGlobalMutex() );

	return m_sEntry ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL EntryKey::getKeyNames() throw(	InvalidRegistryException	,
																RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// An entry has no subkeys!
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryKeyType SAL_CALL EntryKey::getKeyType( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																					RuntimeException			)
{
	// Safe impossible cases
	// Metohod is not declared for invalid parameter!
	DBG_ASSERT( impl_checkParameter_getKeyType( sKeyName ), "EntryKey::getKeyType()\nInvalid parameter detected!\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Other types unknown for this interface!
	// RegistryKeyType" known only KEY and LINK!
	return RegistryKeyType_KEY ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL EntryKey::getResolvedName( const OUString& sKeyName ) throw(	InvalidRegistryException	,
																				RuntimeException			)
{
	// Not implemented yet!
	DBG_ASSERT( sal_False, "EntryKey::getResolvedNames()\nNot implemented yet!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

RegistryValueType SAL_CALL EntryKey::getValueType() throw(	InvalidRegistryException	,
															RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
    MutexGuard aGuard( m_aMutex );

	return impl_getValueType();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

sal_Int32 SAL_CALL EntryKey::getLongValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return 0 ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int32 > SAL_CALL EntryKey::getLongListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return Sequence< sal_Int32 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL EntryKey::getAsciiValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL EntryKey::getAsciiListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL EntryKey::getStringValue() throw(	InvalidRegistryException	,
													InvalidValueException		,
													RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
	MutexGuard aGuard( m_aMutex );

	// Work only, if type of key is right!
	if ( impl_getValueType() != RegistryValueType_STRING )
	{
		throw InvalidValueException();
	}

	// Set default value if method failed.
	OUString sValue ;
	// Try to get value.
	sal_Bool bState = m_pINIFile->readString( m_sSection, m_sEntry, sValue );
	// If operation faild ...
	if ( bState == sal_False )
	{
		// ... throw an exception.
		throw InvalidValueException();
	}

	return sValue ;
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< OUString > SAL_CALL EntryKey::getStringListValue() throw(	InvalidRegistryException	,
																	InvalidValueException		,
																	RuntimeException			)
{
	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return Sequence< OUString >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL EntryKey::getBinaryValue () throw( InvalidRegistryException, InvalidValueException, RuntimeException  )
{
	if ( isValid() == sal_False )
	{
		impl_resetObject();
		throw InvalidRegistryException();
	}

	// Object support strings only.
	throw InvalidValueException();
	return Sequence< sal_Int8 >();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

OUString SAL_CALL EntryKey::getLinkTarget( const OUString& sLinkName ) throw(	InvalidRegistryException	,
																				RuntimeException			)
{
	// An entry has no link!
	// Warn programmers!
	DBG_ASSERT( sal_False, "EntryKey::getLinkTarget()\nAn entry key has no link!\n" );
	return OUString();
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setLongValue( sal_Int32 nValue ) throw(	InvalidRegistryException	,
																RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setLongValue()\nYou can set only a string value!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setLongListValue( const Sequence< sal_Int32 >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setLongListValue()\nYou can set only a string value!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setAsciiValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setAsciiValue()\nYou can set only a string value!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setAsciiListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setAsciiListValue()\nYou can set only a string value!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setStringValue( const OUString& sValue ) throw(	InvalidRegistryException	,
																		RuntimeException			)
{
	// Safe impossible cases
	// Metohod is not declared for invalid parameter!
	DBG_ASSERT( impl_checkParameter_setStringValue( sValue ), "EntryKey::setStringValue()\nInvalid parameter detected!\n" );

	if ( isValid() == sal_False )
	{
		throw InvalidRegistryException();
	}

	// Ready for multithreading
	MutexGuard aGuard( m_aMutex );

	// Work only, if type of key is right!
	if ( impl_getValueType() != RegistryValueType_STRING )
	{
		throw InvalidValueException();
	}

	m_pINIFile->writeString( m_sSection, m_sEntry, sValue );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setStringListValue( const Sequence< OUString >& seqValue ) throw(	InvalidRegistryException	,
																							RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setStringListValue()\nYou can set only a string value!\n" );
}

//_______________________________________________________________________________________________________________________
//	XSimpleRegistry
//_______________________________________________________________________________________________________________________

void SAL_CALL EntryKey::setBinaryValue( const Sequence< sal_Int8 >& seqValue ) throw(	InvalidRegistryException	,
																						RuntimeException			)
{
	// Warn programmers!
	// This implementation works only with strings!
	DBG_ASSERT( sal_False, "EntryKey::setBinaryValue()\nYou can set only a string value!\n" );
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

Any SAL_CALL EntryKey::queryInterface( const Type& aType ) throw( RUNTIMEEXCEPTION )
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Ask for my own supported interfaces ...
	Any aReturn	( ::cppu::queryInterface	(	aType								  ,
										   		static_cast< XTypeProvider*	> ( this ),
										   		static_cast< XRegistryKey*	> ( this )
						 					)
				);

	// If searched interface not supported by this class ...
	if ( aReturn.hasValue() == sal_False )
	{
		// ... ask baseclass for interfaces!
		aReturn = OWeakObject::queryInterface( aType );
	}

	return aReturn ;
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL EntryKey::acquire() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::acquire();
}

//________________________________________________________________________________________________________
//	XInterface
//________________________________________________________________________________________________________

void SAL_CALL EntryKey::release() throw()
{
	// Attention:
	//	Don't use mutex or guard in this method!!! Is a method of XInterface.

	// Forward to baseclass
	OWeakObject::release();
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< Type > SAL_CALL EntryKey::getTypes() throw( RuntimeException )
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pTypeCollection is NULL - for the second call pTypeCollection is different from NULL!
	static OTypeCollection* pTypeCollection = NULL ;

	if ( pTypeCollection == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pTypeCollection == NULL )
		{
			// Create a static typecollection ...
			static OTypeCollection aTypeCollection	(	::getCppuType(( const Reference< XTypeProvider	>*)NULL ),
												   		::getCppuType(( const Reference< XRegistryKey	>*)NULL )
													);

			// ... and set his address to static pointer!
			pTypeCollection = &aTypeCollection ;
		}
	}

	return pTypeCollection->getTypes() ;
}

//________________________________________________________________________________________________________
//	XTypeProvider
//________________________________________________________________________________________________________

Sequence< sal_Int8 > SAL_CALL EntryKey::getImplementationId() throw( RuntimeException )
{
	// Create one Id for all instances of this class.
	// Use ethernet address to do this! (sal_True)

	// Optimize this method
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pID is NULL - for the second call pID is different from NULL!
	static OImplementationId* pID = NULL ;

	if ( pID == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MutexGuard aGuard( Mutex::getGlobalMutex() );

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pID == NULL )
		{
			// Create a new static ID ...
			static OImplementationId aID( sal_False );
			// ... and set his address to static pointer!
			pID = &aID ;
		}
	}

	return pID->getImplementationId();
}

//________________________________________________________________________________________________________
//	public but not exported methods (impl!)
//________________________________________________________________________________________________________

void EntryKey::impl_initializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
											ProfileCache*					pINIFile	,
									const	OUString&						sSection	,
									const	OUString&						sEntry		)
{
	// Safe impossible cases
	// Method is not declared fo invalid parameter!
	DBG_ASSERT(	impl_checkParameter_implinitializeKey( xINIManager, pINIFile, sSection, sEntry ), "EntryKey::impl_initializeKey()\nInvalid parameter detected!\n" );

	// This method overwrite ALL member of this object ...
	// You must call this at first after construct.
	m_xINIManager	=	xINIManager		;
	m_pINIFile		=	pINIFile		;
	m_sSection		=	sSection		;
	m_sEntry		=	sEntry			;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

void EntryKey::impl_resetObject()
{
	// Set default values at member of this object.
	// Needs for initialisation or reset.
	m_xINIManager	=	DEFAULT_XINIMANAGER	;
	m_pINIFile		=	DEFAULT_PINIFILE	;
	m_sSection		=	DEFAULT_SSECTION	;
	m_sEntry		=	DEFAULT_SENTRY		;
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

sal_Bool EntryKey::impl_existKey()
{
	// Search section and entry.
	OUString sValue ;
	return m_pINIFile->readString( m_sSection, m_sEntry, sValue );
}

//________________________________________________________________________________________________________
//	private method
//________________________________________________________________________________________________________

RegistryValueType EntryKey::impl_getValueType()
{
	// Class supports strings only!
	return RegistryValueType_STRING ;
}

//________________________________________________________________________________________________________
//	debug and check methods
//________________________________________________________________________________________________________

#ifdef _DEBUG

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_createKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_deleteKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_openKey( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_getKeyType( const OUString& sKeyName )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &sKeyName				==	NULL	)	||
			( sKeyName.getLength()	<	1		)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_setStringValue( const OUString& sValue )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if ( &sValue == NULL )
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_implinitializeKey(	const	Reference< XSimpleRegistry >&	xINIManager	,
																	ProfileCache*					pINIFile	,
															const	OUString&						sSection	,
															const	OUString&						sEntry		)
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if	(
			( &xINIManager			==	NULL		)	||
			( xINIManager.is()		==	sal_False	)	||
			( pINIFile				==	NULL		)	||
			( &sSection				==	NULL		)	||
			( sSection.getLength()	<	1			)	||
			( &sEntry				==	NULL		)	||
			( sEntry.getLength()	<	1			)
		)
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

//********************************************************************************************************
sal_Bool EntryKey::impl_checkParameter_implwriteString( const OUString& sValue )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;

	// Check parameter. If an invalid value is detected ...
	if ( &sValue == NULL )
	{
		// ... set return value to WRONG. This is the value to activate DBG_ASSERT in parent method!
		bReturn = sal_False ;
	}

	return bReturn ;
}

#endif // _DEBUG

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com
