/*************************************************************************
 *
 *  $RCSfile: taskwrapper.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _HIERARCHY_TASKWRAPPER_HXX_
#include "taskwrapper.hxx"
#endif

#ifndef _SEQUENCE_HELPER_HXX_
#include "sequence_helper.hxx"
#endif
///////////////////////////////////////////////////////////////////////////////
//
//	OContentTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

OContentTaskWrapper::OContentTaskWrapper( const Reference< XContentTaskEnvironment > & xEnv ) :
m_xEnvironment( xEnv ),
m_eStatus( ContentTaskStatus_CREATED ),
m_bAborted( sal_False )
{
}

//-----------------------------------------------------------------------------

int OContentTaskWrapper::appendTask( Reference< XContentTask > & xTask )
{
	Guard< MutexWrap >	aGuard( m_aTaskList );

	m_aTaskList.push_back( xTask );
	return m_aTaskList.size();
}

//-----------------------------------------------------------------------------

int OContentTaskWrapper::removeTask( Reference< XContentTask > & xTask )
{
	Guard< MutexWrap >	aGuard( m_aTaskList );

	m_aTaskList.remove( xTask );
	return m_aTaskList.size();
}

//-----------------------------------------------------------------------------

void OContentTaskWrapper::setStatus( const ContentTaskStatus & eNewStatus ) throw( RuntimeException )
{
	ContentTaskStatus eOldStatus = m_eStatus;
	m_eStatus = eNewStatus;

	if ( eOldStatus != eNewStatus && m_xEnvironment.is() )
	{
		Reference< XContentTaskClient >	xClient = m_xEnvironment->getClient();

		if ( xClient.is() && eNewStatus != eOldStatus )
			xClient->contentTaskEvent( ContentTaskEvent( SAL_STATIC_CAST( XContentTask*, this ), eOldStatus, eNewStatus ) );
	}

	switch ( eNewStatus )
	{
	case ContentTaskStatus_DONE:
	case ContentTaskStatus_ABORTED:
		m_aFinishedCondition.set();
		break;
	default:
		break;
	}
}

//-----------------------------------------------------------------------------
//	XInterface implementation
//-----------------------------------------------------------------------------

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL OContentTaskWrapper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XContentTask*, this ),
		SAL_STATIC_CAST( XContentTaskClient*, this ),
		SAL_STATIC_CAST( XContentTaskEnvironment*, this )
		);

	return ( aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ) );
}
#else
sal_Bool SAL_CALL OContentTaskWrapper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XContentTask*, this ),
		SAL_STATIC_CAST( XContentTaskClient*, this ),
		SAL_STATIC_CAST( XContentTaskEnvironment*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif

//-----------------------------------------------------------------------------
//	XContentClient implementation
//-----------------------------------------------------------------------------

void OContentTaskWrapper::contentTaskEvent( const ContentTaskEvent& rEvent ) throw( RuntimeException )
{
    switch( rEvent.NewStatus )
	{
	case ContentTaskStatus_CREATED:
		if ( appendTask( Reference< XContentTask >::query( rEvent.Source ) ) == 1 )
				setStatus( ContentTaskStatus_CREATED );
		break;
	case ContentTaskStatus_RUNNING:
		setStatus( ContentTaskStatus_RUNNING );
		break;
	case ContentTaskStatus_ABORTED:
		if ( !m_bAborted )
		{
			m_bAborted = sal_True;
			if ( removeTask( Reference< XContentTask >::query( rEvent.Source ) ) == 0 )
				setStatus( ContentTaskStatus_ABORTED );
			else
				abort();
			break;
		}
	case ContentTaskStatus_DONE:
		if ( removeTask( Reference< XContentTask >::query( rEvent.Source ) ) == 0 )
			setStatus( m_bAborted ? ContentTaskStatus_ABORTED : ContentTaskStatus_DONE );
		break;
	default:
		throw RuntimeException();
		break;
	}
}

//-----------------------------------------------------------------------------
// XEventListener implementation
//-----------------------------------------------------------------------------

void SAL_CALL OContentTaskWrapper::disposing( const EventObject& rEvent ) throw(RuntimeException)
{
}

//-----------------------------------------------------------------------------
// XContentTask implementation
//-----------------------------------------------------------------------------

void OContentTaskWrapper::start() throw( RuntimeException )
{
	m_aTaskList.acquire();
	safe_list< Reference< XContentTask > >	aCopyTaskList	= m_aTaskList;
	m_aTaskList.release();

	if ( aCopyTaskList.size() == 0 )
		m_aFinishedCondition.set();
	else
	{
		m_aFinishedCondition.reset();

		for ( safe_list< Reference< XContentTask > >::iterator it = aCopyTaskList.begin(); it != aCopyTaskList.end(); it++ )
		{
			(*it)->start();
		}
	}
}

//-----------------------------------------------------------------------------

void OContentTaskWrapper::execute() throw( RuntimeException )
{
	start();
	m_aFinishedCondition.wait();
}

//-----------------------------------------------------------------------------

void OContentTaskWrapper::abort() throw( RuntimeException )
{
	m_aTaskList.acquire();
	safe_list< Reference< XContentTask > >	aCopyTaskList	= m_aTaskList;
	m_aTaskList.release();

	for ( safe_list< Reference< XContentTask > >::iterator it = aCopyTaskList.begin(); it != aCopyTaskList.end(); it++ )
	{
		(*it)->abort();
	}
}

///////////////////////////////////////////////////////////////////////////////
//
//	OCommandTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
//	XInterface implementation
//-----------------------------------------------------------------------------

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL OCommandTaskWrapper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XCommandTask*, this )
		);

	return ( aRet.hasValue() ? aRet : OContentTaskWrapper::queryInterface( type ) );
}
#else
sal_Bool SAL_CALL OCommandTaskWrapper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XCommandTask*, this )
		)
		|| OContentTaskWrapper::queryInterface( type, ifc );
}
#endif

///////////////////////////////////////////////////////////////////////////////
//
//	OPropertyTaskWrapper
//
///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
//	OPropertyTask implementation
//-----------------------------------------------------------------------------

int OPropertyTaskWrapper::removeTask( Reference< XContentTask > & xTask )
{
	Reference< XPropertyTask >	xPropertyTask = Reference< XPropertyTask >::query( xTask );

	if ( xPropertyTask.is() )
		m_aProperties = concat( m_aProperties, xPropertyTask->getProperties() );

	return OContentTaskWrapper::removeTask( xTask );
}

//-----------------------------------------------------------------------------
//	XInterface implementation
//-----------------------------------------------------------------------------

#if defined(TF_TYPE) || (SUPD >= 564)
Any SAL_CALL OPropertyTaskWrapper::queryInterface( const Type& type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XPropertyTask*, this )
		);

	return ( aRet.hasValue() ? aRet : OContentTaskWrapper::queryInterface( type ) );
}
#else
sal_Bool SAL_CALL OPropertyTaskWrapper::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XPropertyTask*, this )
		)
		|| OContentTaskWrapper::queryInterface( type, ifc );
}
#endif

