/*************************************************************************
 *
 *  $RCSfile: hierarchy_helper.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _HIERARCHY_HELPER_HXXH_
#define _HIERARCHY_HELPER_HXXH_

#include <osl/thread.h>

#ifndef _HIERARCHY_TEMPLATES_HXX_
#include "templates.hxx"
#endif

#include <cppuhelper/weak.hxx>

#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDTASK_HPP_
#include <com/sun/star/ucb/XCommandTask.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASK_HPP_
#include <com/sun/star/ucb/XPropertyTask.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif
using namespace osl;
using namespace rtl;
using namespace std;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;
using namespace com::sun::star::ucb;

//-----------------------------------------------------------------------------
//	OContentHelper
//-----------------------------------------------------------------------------

class OContentHelper : 
public OWeakObject,
public XContent
{
protected:
	safe_list< Reference< XContentEventListener > >	m_aContentEventListeners;
public:
	virtual void broadcastContentEvent( const ContentEvent & aEvent );

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif

	virtual void SAL_CALL acquire() throw( RuntimeException ) { OWeakObject::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OWeakObject::release(); };

	// XContent
    virtual void SAL_CALL addContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException);
    virtual void SAL_CALL removeContentEventListener( const Reference< XContentEventListener >& Listener ) throw(RuntimeException);
};


//-----------------------------------------------------------------------------
//	OPropertyHelper
//-----------------------------------------------------------------------------

class OPropertyHelper : 
public OWeakObject,
public XPropertyTaskProcessor
{
protected:
	struct PropertyListenerEntry
	{
		Reference< XPropertiesChangeListener >	Listener;
		Sequence< OWString >					PropertyNames;

		PropertyListenerEntry( const Sequence< OWString > & aNames, const Reference< XPropertiesChangeListener > & xListener ) :
			PropertyNames( aNames ), Listener( xListener ) {};

		inline int operator == ( const PropertyListenerEntry & Entry ) const
			{ return Listener == Entry.Listener; };
	};

	safe_list< PropertyListenerEntry >	m_aPropertyChangeListeners;
public:
    virtual void broadcastPropertiesChangeEvent( const Sequence< PropertyChangeEvent >& evt ) throw(RuntimeException);
	virtual Sequence< PropertyChangeEvent > matchEvents( const Sequence< PropertyChangeEvent >& Events, const Sequence< OWString > & PropertyNames ) throw(RuntimeException);

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException ) { return OWeakObject::queryInterface( type ); };
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException ) { return OWeakObject::queryInterface( type, ifc ); };
#endif

	virtual void SAL_CALL acquire() throw( RuntimeException ) { OWeakObject::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OWeakObject::release(); };

	// XPropertyTaskProcessor

    virtual void SAL_CALL addPropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);
    virtual void SAL_CALL removePropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);
};

//---------------------------------------------------------------------------
//
//	OContentTaskHelper
//
//---------------------------------------------------------------------------

class OContentTaskHelper :
public OWeakObject,
public XContentTask
{
protected:
	Reference< XContentTaskEnvironment >		m_xEnvironment;
	ContentTaskStatus							m_eStatus;
	oslThread									m_aThread;

	static void executeWorker( void * );
	virtual ContentTaskStatus setStatus( const ContentTaskStatus &eStatus );

	// To be implemented by inheritants
	virtual void doExecute() = 0;
public:
	OContentTaskHelper(  const Reference< XContentTaskEnvironment >& xEnv );
	virtual ~OContentTaskHelper();

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif

	virtual void SAL_CALL acquire() throw(RuntimeException);
	virtual void SAL_CALL release() throw(RuntimeException);

	// XContentTask
	virtual void SAL_CALL start() throw();
	virtual void SAL_CALL execute() throw( Exception );
	virtual void SAL_CALL abort() throw();
	virtual ContentTaskStatus SAL_CALL getStatus() throw();
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw();
};


//---------------------------------------------------------------------------
//
//	OPropertyTaskHelper
//
//---------------------------------------------------------------------------

class OPropertyTaskHelper :
public OContentTaskHelper,
public XPropertyTask
{
protected:
	PropertyTaskType				m_aType;
	Sequence< PropertyValueInfo >	m_aProperties;
public:
	OPropertyTaskHelper( const Reference< XContentTaskEnvironment >& xEnv, const PropertyTaskType & Type ) :
	OContentTaskHelper( xEnv ), m_aType( Type ) {};

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif
	virtual void SAL_CALL acquire() throw( RuntimeException ) { OContentTaskHelper::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OContentTaskHelper::release(); };

	// XPropertyTask

    virtual PropertyTaskType SAL_CALL getType() throw(RuntimeException) { return m_aType; };
    virtual Sequence< PropertyValueInfo > SAL_CALL getProperties() throw(RuntimeException) { return m_aProperties; };

	// XContentTask
	virtual void SAL_CALL start() throw() { OContentTaskHelper::start(); };
	virtual void SAL_CALL execute() throw( Exception ) { OContentTaskHelper::execute(); };
	virtual void SAL_CALL abort() throw() { OContentTaskHelper::abort(); };
	virtual ContentTaskStatus SAL_CALL getStatus() throw() { return OContentTaskHelper::getStatus(); };
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw() { return OContentTaskHelper::getEnvironment(); };
};

//---------------------------------------------------------------------------
//
//	OPropertySetInfoHelper
//
//---------------------------------------------------------------------------

class OPropertySetInfoHelper :
public XPropertySetInfo,
public OWeakObject
{
protected:
	Sequence< Property >	m_aProperties;

public:
	OPropertySetInfoHelper( const Sequence< Property > & Properties ) :
	  m_aProperties( Properties ) {};

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif
	virtual void SAL_CALL acquire() throw( RuntimeException ) { OWeakObject::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OWeakObject::release(); };

	//	XPropertySetInfo

    virtual Sequence< Property > SAL_CALL getProperties(  ) throw(RuntimeException) { return m_aProperties; };
    virtual Property SAL_CALL getPropertyByName( const OWString& aName ) throw(UnknownPropertyException, RuntimeException);
    virtual sal_Bool SAL_CALL hasPropertyByName( const OWString& Name ) throw(RuntimeException);
};

//---------------------------------------------------------------------------
//
//	OCommandTaskHelper
//
//---------------------------------------------------------------------------

class OCommandTaskHelper :
public OContentTaskHelper,
public XCommandTask
{
protected:
	Command	m_aCommand;
	Any		m_aResult;
public:
	OCommandTaskHelper( const Reference< XContentTaskEnvironment >& xEnv, const Command & rCommand ) :
	  OContentTaskHelper( xEnv ), m_aCommand( rCommand ) {};

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif
	virtual void SAL_CALL acquire() throw( RuntimeException ) { OContentTaskHelper::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OContentTaskHelper::release(); };

	// XCommandTask
	virtual Command SAL_CALL getCommand() throw() { return m_aCommand; };
	virtual Any SAL_CALL getResult() throw() { return m_aResult; };

	// XContentTask
	virtual void SAL_CALL start() throw() { OContentTaskHelper::start(); };
	virtual void SAL_CALL execute() throw( Exception ) { OContentTaskHelper::execute(); };
	virtual void SAL_CALL abort() throw() { OContentTaskHelper::abort(); };
	virtual ContentTaskStatus SAL_CALL getStatus() throw() { return OContentTaskHelper::getStatus(); };
	virtual Reference< XContentTaskEnvironment > SAL_CALL getEnvironment() throw() { return OContentTaskHelper::getEnvironment(); };
};

//-----------------------------------------------------------------------------
// OCommandInfoHelper
//-----------------------------------------------------------------------------

class OCommandInfoHelper : public XCommandInfo
{
public:
    // XCommandInfo
    virtual CommandInfo SAL_CALL getCommandInfoByName( const OWString& Name ) throw(UnsupportedCommandException, RuntimeException);
    virtual CommandInfo SAL_CALL getCommandInfoByHandle( sal_Int32 Handle ) throw(UnsupportedCommandException, RuntimeException);
    virtual sal_Bool SAL_CALL hasCommandByName( const OWString& Name ) throw(RuntimeException);
    virtual sal_Bool SAL_CALL hasCommandByHandle( sal_Int32 Handle ) throw(RuntimeException);
};

#endif // _HIERARCHY_HELPER_HXXH_
