/*************************************************************************
 *
 *  $RCSfile: hierarchy.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HIERARCHY_HXX
#define _HIERARCHY_HXX

#define TESTSERVICE

#ifndef _HIERARCHY_HELPER_HXX_
#include "hierarchy_helper.hxx"
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XHIERARCHYREGISTRY_HPP_
#include <com/sun/star/hierarchy/XHierarchyRegistry.hpp>
#endif


#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIER_HPP_
#include <com/sun/star/ucb/XContentIdentifier.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandTaskProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XRESULTACCEPTOR_HPP_
#include <com/sun/star/ucb/XResultAcceptor.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASKPROCESSOR_HPP_
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTCREATOR_HPP_
#include <com/sun/star/ucb/XContentCreator.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYSETREGISTRYFACTORY_HPP_
#include <com/sun/star/ucb/XPropertySetRegistryFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XPROPERTYSETREGISTRY_HPP_
#include <com/sun/star/ucb/XPropertySetRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XDYNAMICHIERARCHY_HPP_
#include <com/sun/star/hierarchy/XDynamicHierarchy.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XCONTENTHIERARCHY_HPP_
#include <com/sun/star/hierarchy/XContentHierarchy.hpp>
#endif

#ifndef _COM_SUN_STAR_HIERARCHY_XHIERARCHYPROVIDER_HPP_
#include <com/sun/star/hierarchy/XHierarchyProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif


using namespace com::sun::star::hierarchy;
using namespace com::sun::star::beans;
using namespace com::sun::star::lang;


//-----------------------------------------------------------------------------
//	OContentHolder
//-----------------------------------------------------------------------------

class OContentHolder : 
public OContentHelper,
public OCommandInfoHelper,
public XCommandTaskProcessor,
public XPropertyTaskProcessor,
public XContentHierarchy,
public XContentEventListener,
public XContentCreator
{
protected:
	Reference< XContent >			m_xPhysicalContent;
	Reference< XPropertySetInfo >	m_xPhysicalPropertySetInfo;

public:
	OContentHolder( const Reference < XContent > &rContent );
	virtual ~OContentHolder();

	virtual Reference< XContent > packContent( const Reference< XContent > & xContent );

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif

	virtual void SAL_CALL acquire() throw( RuntimeException ) { OContentHelper::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OContentHelper::release(); };

	// XEventListener
    virtual void SAL_CALL disposing( const EventObject& Source ) throw(RuntimeException);

	// XContentEventListener
	void SAL_CALL contentEvent( const ContentEvent & evt ) throw(RuntimeException);

	// XContentCreator

    virtual Sequence< ContentInfo > SAL_CALL queryCreatableContentsInfo(  ) throw(RuntimeException);
    virtual Reference< XContent > SAL_CALL createNewContent( const ContentInfo& Info ) throw(RuntimeException);
#if ( SUPD < 565 )
    virtual sal_Bool SAL_CALL insertContent( const Reference< XContent >& Content ) throw(RuntimeException);
#endif

	// XContent

    virtual Reference< XContentIdentifier > SAL_CALL getIdentifier(  ) throw(RuntimeException);
    virtual OWString SAL_CALL getContentType(  ) throw(RuntimeException);

	// XCommandTaskProcessor 

#if ( SUPD >= 566 )
	virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XResultAcceptor > &ResultAcceptor, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#else
    virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#endif
    virtual Reference< XCommandInfo > SAL_CALL getCommandsInfo(  ) throw(RuntimeException);

	// XPropertyTaskProcessor
	virtual Reference< XPropertyTask > SAL_CALL createPropertyTask( PropertyTaskType Type, const Sequence< PropertyValue >& Properties, const Reference< XContentTaskEnvironment >& Environment ) throw();
	virtual Reference< XPropertySetInfo > SAL_CALL getPropertySetInfo() throw();
    virtual void SAL_CALL addPropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);
    virtual void SAL_CALL removePropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);

	// XContentHierarchy
	virtual Sequence< Any > SAL_CALL getHierarchyIdentifierFromContent( const Reference< XContent > & xContent ) throw( IllegalArgumentException );
	virtual Reference< XContent > SAL_CALL getContentFromHierarchyIdentifier( const Sequence< Any > &aIdentifier ) throw( IllegalArgumentException );
	virtual sal_Bool SAL_CALL compareHierarchyIdentifiers( const Sequence< Any > &id1, const Sequence< Any > &id2 ) throw();

    // XCommandInfo
    virtual Sequence< CommandInfo > SAL_CALL getCommands(  ) throw(RuntimeException);
};

//-----------------------------------------------------------------------------
//	ODynamicHierarchy
//-----------------------------------------------------------------------------

class ODynamicHierarchy : 
public OContentHolder,
public OPropertyHelper,
public XHierarchyProvider,
public XDynamicHierarchy,
public XPropertiesChangeListener,
public XPropertyChangeListener
{
protected:
	struct ContentEntry
	{
		Reference< XContent >				xContent;
		Any									aToken;

		inline operator == ( const ContentEntry & rEntry ) const
		{
			return xContent == rEntry.xContent;
		}
	};

	safe_list< ContentEntry >				m_aContentList;
	Sequence< Any >							m_aOwnIdentifier;
	sal_Bool								m_bIsOpen;
	OWString								m_aOwnURL;
	Reference< XPersistentPropertySet >		m_xPropertySet;

	static Reference< XHierarchyRegistry >			s_xDesktopRegistry;
	static Reference< XMultiServiceFactory >		s_xServiceFactory;
	static Reference< XContentProviderManager >		s_xProviderManager;
	static Reference< XContentProvider >			s_xUCBProvider;
	static Reference< XContentIdentifierFactory >	s_xIdentifierFactory;
	static Reference< XPropertySetRegistryFactory >	s_xPropertyRegistryFactory;
	static Reference< XPropertySetRegistry >		s_xPropertyRegistry;

public:
	ODynamicHierarchy( const Reference< XContent > & xContent, const Sequence< Any > & root = Sequence< Any >() );
	ODynamicHierarchy( const Reference< XMultiServiceFactory > & xServiceFactory );

	virtual Sequence< Any > SAL_CALL addChildContent( const Reference< XContent > & Content );
	virtual OWString getKeyName();

	// inherited from OContentHolder

	virtual Reference< XContent > packContent( const Reference< XContent > & xContent );

	// inherited from OContentHelper

	virtual void doCommand(const Command & rCommand );

	virtual Sequence< PropertyValueInfo > getProperties( const Sequence< PropertyValue > & Properties );
	virtual Sequence< PropertyValueInfo > setProperties( const Sequence< PropertyValue > & Properties );

	// XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException );
#endif

	virtual void SAL_CALL acquire() throw( RuntimeException ) { OContentHolder::acquire(); };
	virtual void SAL_CALL release() throw( RuntimeException ) { OContentHolder::release(); };

	// XEventListener
    virtual void SAL_CALL disposing( const EventObject& Source ) throw(RuntimeException);

	// XPropertiesChangeListener

	virtual void SAL_CALL propertiesChange( const Sequence< PropertyChangeEvent >& Events ) throw(RuntimeException);

	// XPropertyChangeListener

	virtual void SAL_CALL propertyChange( const PropertyChangeEvent & Event ) throw(RuntimeException)
	{
		propertiesChange( Sequence< PropertyChangeEvent >( &Event, 1 ) );
	}

	// XHierarchyProvider
	virtual void SAL_CALL setProviderRoot( const Sequence< Any > &aAbsoluteIdentifier ) throw(RuntimeException);
	virtual Sequence< Any > SAL_CALL getProviderRoot() throw(RuntimeException);

    // XDynamicHierarchy
    virtual Sequence< Any > SAL_CALL registerChildContent( const Reference< XContent >& Content ) throw(RuntimeException);
    virtual void SAL_CALL deregisterChildHierarchy( const Sequence< Any > &aIdentifier ) throw(RuntimeException);
    virtual Reference< XDynamicHierarchy > SAL_CALL getSubHierarchy( const Sequence< Any > &aIdentifier ) throw(RuntimeException);

	// XContentHierarchy
	virtual Sequence< Any > SAL_CALL getHierarchyIdentifierFromContent( const Reference< XContent > & xContent );
	virtual Reference< XContent > SAL_CALL getContentFromHierarchyIdentifier( const Sequence< Any > &aIdentifier );
	virtual sal_Bool SAL_CALL compareHierarchyIdentifiers( const Sequence< Any > &id1, const Sequence< Any > &id2 ) throw();

	// XCommandTaskProcessor 
#if ( SUPD >= 566 )
	virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XResultAcceptor > &ResultAcceptor, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#else
    virtual Reference< XCommandTask > SAL_CALL createCommandTask( const Command& TheCommand, const Reference< XContentTaskEnvironment >& Environment ) throw(RuntimeException);
#endif
    virtual Reference< XCommandInfo > SAL_CALL getCommandsInfo(  ) throw(RuntimeException);

	// XPropertyTaskProcessor
	virtual Reference< XPropertyTask > SAL_CALL createPropertyTask( PropertyTaskType Type, const Sequence< PropertyValue >& Properties, const Reference< XContentTaskEnvironment >& Environment ) throw();
	virtual Reference< XPropertySetInfo > SAL_CALL getPropertySetInfo() throw();
    virtual void SAL_CALL addPropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);
    virtual void SAL_CALL removePropertiesChangeListener( const Sequence< OWString >& PropertyNames, const Reference< XPropertiesChangeListener >& Listener ) throw(RuntimeException);

    // XCommandInfo
    virtual Sequence< CommandInfo > SAL_CALL getCommands(  ) throw(RuntimeException);
};

//-----------------------------------------------------------------------------
//	ODynamicHierarchyCommandTask
//-----------------------------------------------------------------------------

class ODynamicHierarchyCommandTask : public OCommandTaskHelper
{
protected:
	Reference< XContent >	m_xHierarchy;
	ODynamicHierarchy		*m_pHierarchy;
public:
	ODynamicHierarchyCommandTask( const Reference< XContentTaskEnvironment >& xEnv, const Command & rCommand, ODynamicHierarchy *pHierarchy ) :
		OCommandTaskHelper( xEnv, rCommand ), m_xHierarchy( pHierarchy ), m_pHierarchy( pHierarchy ) {};


	virtual void doExecute();
};

//-----------------------------------------------------------------------------
//	ODynamicHierarchyPropertyTask
//-----------------------------------------------------------------------------

class ODynamicHierarchyPropertyTask : public OPropertyTaskHelper
{
protected:
	Reference< XContent >		m_xHierarchy;
	ODynamicHierarchy			*m_pHierarchy;
	Sequence< PropertyValue >	m_aPropertyValues;
public:
	ODynamicHierarchyPropertyTask( const Reference< XContentTaskEnvironment >& xEnv, const PropertyTaskType & Type, const Sequence< PropertyValue >& Properties, ODynamicHierarchy *pHierarchy ) :
		OPropertyTaskHelper( xEnv, Type ), m_aPropertyValues( Properties ), m_xHierarchy( pHierarchy ), m_pHierarchy( pHierarchy ) {};

	virtual void doExecute();
};


#endif	// _HIERARCHY_HXX
